/*
 * Decompiled with CFR 0.152.
 */
package forestry.plugins;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import cpw.mods.fml.common.IFuelHandler;
import cpw.mods.fml.common.event.FMLInterModComms;
import cpw.mods.fml.common.network.IGuiHandler;
import cpw.mods.fml.common.registry.GameRegistry;
import forestry.Forestry;
import forestry.core.interfaces.IOreDictionaryHandler;
import forestry.core.interfaces.IPacketHandler;
import forestry.core.interfaces.IPickupHandler;
import forestry.core.interfaces.IResupplyHandler;
import forestry.core.interfaces.ISaveEventHandler;
import forestry.core.proxy.Proxies;
import forestry.plugins.ForestryPlugin;
import forestry.plugins.Plugin;
import forestry.plugins.PluginApiculture;
import forestry.plugins.PluginArboriculture;
import forestry.plugins.PluginBuildCraftFuels;
import forestry.plugins.PluginBuildCraftRecipes;
import forestry.plugins.PluginBuildCraftStatements;
import forestry.plugins.PluginBuildCraftTransport;
import forestry.plugins.PluginCore;
import forestry.plugins.PluginEE;
import forestry.plugins.PluginEnergy;
import forestry.plugins.PluginFactory;
import forestry.plugins.PluginFarmCraftory;
import forestry.plugins.PluginFarming;
import forestry.plugins.PluginFluids;
import forestry.plugins.PluginFood;
import forestry.plugins.PluginIC2;
import forestry.plugins.PluginLepidopterology;
import forestry.plugins.PluginMail;
import forestry.plugins.PluginNatura;
import forestry.plugins.PluginPropolisPipe;
import forestry.plugins.PluginStorage;
import java.io.File;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.Locale;
import java.util.Random;
import java.util.Set;
import net.minecraft.command.CommandHandler;
import net.minecraft.command.ICommand;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.StatCollector;
import net.minecraft.world.World;
import net.minecraft.world.chunk.IChunkProvider;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.common.config.Property;

public class PluginManager {
    public static final String MODULE_CONFIG_FILE_NAME = "modules.cfg";
    public static final String CATEGORY_MODULES = "modules";
    public static final ArrayList<IGuiHandler> guiHandlers = Lists.newArrayList();
    public static final ArrayList<IPacketHandler> packetHandlers = Lists.newArrayList();
    public static final ArrayList<IPickupHandler> pickupHandlers = Lists.newArrayList();
    public static final ArrayList<ISaveEventHandler> saveEventHandlers = Lists.newArrayList();
    public static final ArrayList<IResupplyHandler> resupplyHandlers = Lists.newArrayList();
    public static final ArrayList<IOreDictionaryHandler> dictionaryHandlers = Lists.newArrayList();
    private static final Set<Module> loadedModules = EnumSet.noneOf(Module.class);
    private static final Set<Module> unloadedModules = EnumSet.allOf(Module.class);
    private static Stage stage = Stage.SETUP;
    public static final EnumSet<Module> configDisabledModules = EnumSet.noneOf(Module.class);

    public static Stage getStage() {
        return stage;
    }

    public static EnumSet<Module> getLoadedModules() {
        return EnumSet.copyOf(loadedModules);
    }

    public static boolean isModuleLoaded(Module module) {
        return loadedModules.contains((Object)module);
    }

    public static void addPlugin(ForestryPlugin plugin) {
    }

    public static void runPreInit() {
        ForestryPlugin plugin;
        boolean changed;
        stage = Stage.SETUP;
        Locale locale = Locale.getDefault();
        Locale.setDefault(Locale.ENGLISH);
        Configuration config = new Configuration(new File(Forestry.instance.getConfigFolder(), MODULE_CONFIG_FILE_NAME));
        config.load();
        config.addCustomCategoryComment(CATEGORY_MODULES, "Disabling these modules can greatly change how the mod functions.\nYour mileage may vary, please report any issues.");
        EnumSet<Module> toLoad = EnumSet.allOf(Module.class);
        Iterator it = toLoad.iterator();
        while (it.hasNext()) {
            Module m = (Module)((Object)it.next());
            if (!m.canBeDisabled()) continue;
            if (!PluginManager.isEnabled(config, m)) {
                it.remove();
                Proxies.log.info("Module disabled: {0}", (Object)m);
                continue;
            }
            ForestryPlugin plugin2 = m.instance;
            if (plugin2.isAvailable()) continue;
            it.remove();
            Proxies.log.info("Module {0} failed to load: {1}", plugin2, plugin2.getFailMessage());
        }
        do {
            changed = false;
            it = toLoad.iterator();
            while (it.hasNext()) {
                Module m = (Module)((Object)it.next());
                EnumSet<Module> deps = m.instance().getDependancies();
                if (toLoad.containsAll(deps)) continue;
                it.remove();
                changed = true;
                Proxies.log.warning("Module {0} is missing dependencies: {1}", new Object[]{m, deps});
            }
        } while (changed);
        unloadedModules.removeAll(toLoad);
        loadedModules.addAll(toLoad);
        if (config.hasChanged()) {
            config.save();
        }
        Locale.setDefault(locale);
        stage = Stage.PRE_INIT;
        for (Module m : loadedModules) {
            plugin = m.instance;
            PluginManager.loadPlugin(plugin);
        }
        for (Module m : loadedModules) {
            plugin = m.instance;
            Proxies.log.fine("Pre-Init Start: {0}", (Object)plugin);
            plugin.preInit();
            plugin.registerItems();
            Proxies.log.fine("Pre-Init Complete: {0}", (Object)plugin);
        }
    }

    private static void loadPlugin(ForestryPlugin plugin) {
        IFuelHandler fuelHandler;
        IOreDictionaryHandler dictionaryHandler;
        IResupplyHandler resupplyHandler;
        ISaveEventHandler saveHandler;
        IPickupHandler pickupHandler;
        IPacketHandler packetHandler;
        Proxies.log.fine("Registering Handlers for Plugin: {0}", (Object)plugin);
        IGuiHandler guiHandler = plugin.getGuiHandler();
        if (guiHandler != null) {
            guiHandlers.add(guiHandler);
        }
        if ((packetHandler = plugin.getPacketHandler()) != null) {
            packetHandlers.add(packetHandler);
        }
        if ((pickupHandler = plugin.getPickupHandler()) != null) {
            pickupHandlers.add(pickupHandler);
        }
        if ((saveHandler = plugin.getSaveEventHandler()) != null) {
            saveEventHandlers.add(saveHandler);
        }
        if ((resupplyHandler = plugin.getResupplyHandler()) != null) {
            resupplyHandlers.add(resupplyHandler);
        }
        if ((dictionaryHandler = plugin.getDictionaryHandler()) != null) {
            dictionaryHandlers.add(dictionaryHandler);
        }
        if ((fuelHandler = plugin.getFuelHandler()) != null) {
            GameRegistry.registerFuelHandler((IFuelHandler)fuelHandler);
        }
    }

    public static void runInit() {
        stage = Stage.INIT;
        for (Module m : loadedModules) {
            ForestryPlugin plugin = m.instance;
            Proxies.log.fine("Init Start: {0}", (Object)plugin);
            if (Module.STORAGE.isEnabled()) {
                plugin.registerBackpackItems();
                plugin.registerCrates();
            }
            plugin.doInit();
            Proxies.log.fine("Init Complete: {0}", (Object)plugin);
        }
    }

    public static void runPostInit() {
        ForestryPlugin plugin;
        stage = Stage.POST_INIT;
        for (Module m : loadedModules) {
            plugin = m.instance;
            Proxies.log.fine("Post-Init Start: {0}", (Object)plugin);
            plugin.registerRecipes();
            plugin.postInit();
            Proxies.log.fine("Post-Init Complete: {0}", (Object)plugin);
        }
        stage = Stage.INIT_DISABLED;
        for (Module m : unloadedModules) {
            plugin = m.instance;
            Proxies.log.fine("Disabled-Init Start: {0}", (Object)plugin);
            plugin.disabledInit();
            Proxies.log.fine("Disabled-Init Complete: {0}", (Object)plugin);
        }
        stage = Stage.FINISHED;
    }

    public static void serverStarting(MinecraftServer server) {
        CommandHandler commandManager = (CommandHandler)server.func_71187_D();
        for (Module m : loadedModules) {
            ForestryPlugin plugin = m.instance;
            ICommand[] commands = plugin.getConsoleCommands();
            if (commands == null) continue;
            for (ICommand command : commands) {
                commandManager.func_71560_a(command);
            }
        }
    }

    public static void processIMCMessages(ImmutableList<FMLInterModComms.IMCMessage> messages) {
        for (FMLInterModComms.IMCMessage message : messages) {
            Module m;
            ForestryPlugin plugin;
            Iterator<Module> i$ = loadedModules.iterator();
            while (i$.hasNext() && !(plugin = (m = i$.next()).instance).processIMCMessage(message)) {
            }
        }
    }

    public static void populateChunk(IChunkProvider chunkProvider, World world, Random rand, int chunkX, int chunkZ, boolean hasVillageGenerated) {
        for (Module m : loadedModules) {
            ForestryPlugin plugin = m.instance;
            plugin.populateChunk(chunkProvider, world, rand, chunkX, chunkZ, hasVillageGenerated);
        }
    }

    public static void populateChunkRetroGen(World world, Random rand, int chunkX, int chunkZ) {
        for (Module m : loadedModules) {
            ForestryPlugin plugin = m.instance;
            plugin.populateChunkRetroGen(world, rand, chunkX, chunkZ);
        }
    }

    private static boolean isEnabled(Configuration config, Module m) {
        Plugin info = m.instance().getClass().getAnnotation(Plugin.class);
        String comment = StatCollector.func_74838_a((String)info.unlocalizedDescription());
        Property prop = config.get(CATEGORY_MODULES, m.configName(), true, comment);
        boolean enabled = prop.getBoolean();
        if (!enabled) {
            configDisabledModules.add(m);
        }
        return enabled;
    }

    public static enum Module {
        CORE(new PluginCore(), false),
        FLUIDS(new PluginFluids(), false),
        APICULTURE(new PluginApiculture()),
        ARBORICULTURE(new PluginArboriculture()),
        ENERGY(new PluginEnergy()),
        FACTORY(new PluginFactory()),
        FARMING(new PluginFarming()),
        FOOD(new PluginFood()),
        LEPIDOPTEROLOGY(new PluginLepidopterology()),
        MAIL(new PluginMail()),
        STORAGE(new PluginStorage()),
        BUILDCRAFT_FUELS(new PluginBuildCraftFuels()),
        BUILDCRAFT_RECIPES(new PluginBuildCraftRecipes()),
        BUILDCRAFT_STATEMENTS(new PluginBuildCraftStatements()),
        BUILDCRAFT_TRANSPORT(new PluginBuildCraftTransport()),
        PROPOLIS_PIPE(new PluginPropolisPipe()),
        EQUIVELENT_EXCHANGE(new PluginEE()),
        FARM_CRAFTORY(new PluginFarmCraftory()),
        INDUSTRIALCRAFT(new PluginIC2()),
        NATURA(new PluginNatura());

        private final ForestryPlugin instance;
        private final boolean canBeDisabled;

        private Module(ForestryPlugin plugin) {
            this(plugin, true);
        }

        private Module(ForestryPlugin plugin, boolean canBeDisabled) {
            this.instance = plugin;
            this.canBeDisabled = canBeDisabled;
        }

        public ForestryPlugin instance() {
            return this.instance;
        }

        public boolean isEnabled() {
            return PluginManager.isModuleLoaded(this);
        }

        public boolean canBeDisabled() {
            return this.canBeDisabled;
        }

        public String configName() {
            return this.toString().toLowerCase(Locale.ENGLISH).replace('_', '.');
        }
    }

    public static enum Stage {
        SETUP,
        PRE_INIT,
        INIT,
        POST_INIT,
        INIT_DISABLED,
        FINISHED;

    }
}

