/*
 * Decompiled with CFR 0.152.
 */
package forestry.pipes.gui;

import forestry.api.apiculture.IAlleleBeeSpecies;
import forestry.api.apiculture.IApiaristTracker;
import forestry.api.genetics.AlleleManager;
import forestry.api.genetics.IAllele;
import forestry.api.genetics.IAlleleSpecies;
import forestry.apiculture.items.ItemBeeGE;
import forestry.core.config.Config;
import forestry.core.config.ForestryItem;
import forestry.core.gadgets.TileForestry;
import forestry.core.genetics.ItemGE;
import forestry.core.gui.GuiForestry;
import forestry.core.gui.widgets.Widget;
import forestry.core.proxy.Proxies;
import forestry.core.render.SpriteSheet;
import forestry.core.utils.StringUtil;
import forestry.pipes.EnumFilterType;
import forestry.pipes.PipeItemsPropolis;
import forestry.pipes.PipeLogicPropolis;
import forestry.pipes.gui.ContainerPropolisPipe;
import forestry.plugins.PluginApiculture;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IInventory;
import net.minecraft.util.IIcon;
import net.minecraftforge.common.util.ForgeDirection;
import org.lwjgl.opengl.GL11;

public class GuiPropolisPipe<T extends TileForestry>
extends GuiForestry<T> {
    private final PipeLogicPropolis pipeLogic;

    public GuiPropolisPipe(EntityPlayer player, PipeItemsPropolis pipe) {
        super("textures/gui/analyzer.png", (Container)new ContainerPropolisPipe((IInventory)player.field_71071_by, pipe));
        this.pipeLogic = pipe.pipeLogic;
        if (!Proxies.common.isSimulating(pipe.getWorld())) {
            this.pipeLogic.requestFilterSet();
        }
        this.field_146999_f = 175;
        this.field_147000_g = 225;
        for (int i = 0; i < 6; ++i) {
            this.widgetManager.add(new TypeFilterSlot(8, 18 + i * 18, ForgeDirection.values()[i], this.pipeLogic));
        }
        IApiaristTracker tracker = PluginApiculture.beeInterface.getBreedingTracker(player.field_70170_p, player.func_146103_bH());
        for (int i = 0; i < 6; ++i) {
            for (int j = 0; j < 3; ++j) {
                for (int k = 0; k < 2; ++k) {
                    this.widgetManager.add(new SpeciesFilterSlot(tracker, 44 + j * 45 + k * 18, 18 + i * 18, ForgeDirection.values()[i], j, k, this.pipeLogic));
                }
            }
        }
    }

    @Override
    protected void func_146979_b(int mouseX, int mouseY) {
        super.func_146979_b(mouseX, mouseY);
        this.field_146289_q.func_78276_b("Apiarist's Pipe", 56, 6, 0x303030);
    }

    class SpeciesFilterSlot
    extends Widget {
        private final IApiaristTracker tracker;
        private final ForgeDirection orientation;
        private final PipeLogicPropolis logic;
        private final int pattern;
        private final int allele;

        public SpeciesFilterSlot(IApiaristTracker tracker, int x, int y, ForgeDirection orientation, int pattern, int allele, PipeLogicPropolis logic) {
            super(GuiPropolisPipe.this.widgetManager, x, y);
            this.tracker = tracker;
            this.orientation = orientation;
            this.pattern = pattern;
            this.allele = allele;
            this.logic = logic;
        }

        public IAlleleSpecies getSpecies() {
            return this.logic.getSpeciesFilter(this.orientation, this.pattern, this.allele);
        }

        public boolean isDefined() {
            IAlleleSpecies species = this.logic.getSpeciesFilter(this.orientation, this.pattern, this.allele);
            return species != null;
        }

        @Override
        public void draw(int startX, int startY) {
            if (!this.isDefined()) {
                return;
            }
            IAlleleSpecies species = this.logic.getSpeciesFilter(this.orientation, this.pattern, this.allele);
            GL11.glDisable((int)2896);
            for (int i = 0; i < 3; ++i) {
                IIcon icon = ((ItemBeeGE)ForestryItem.beeDroneGE.item()).getIconFromSpecies((IAlleleBeeSpecies)species, i);
                int color = ((ItemGE)ForestryItem.beeDroneGE.item()).getColourFromSpecies(species, i);
                float colorR = (float)(color >> 16 & 0xFF) / 255.0f;
                float colorG = (float)(color >> 8 & 0xFF) / 255.0f;
                float colorB = (float)(color & 0xFF) / 255.0f;
                GL11.glColor4f((float)colorR, (float)colorG, (float)colorB, (float)1.0f);
                this.manager.gui.func_94065_a(startX + this.xPos, startY + this.yPos, icon, 16, 16);
            }
            GL11.glEnable((int)2896);
        }

        @Override
        protected String getLegacyTooltip(EntityPlayer player) {
            IAlleleSpecies species = this.logic.getSpeciesFilter(this.orientation, this.pattern, this.allele);
            if (species != null) {
                return species.getName();
            }
            return null;
        }

        @Override
        public void handleMouseClick(int mouseX, int mouseY, int mouseButton) {
            IAlleleBeeSpecies change;
            block7: {
                change = null;
                if (mouseButton == 1) {
                    change = null;
                } else if (this.getSpecies() == null) {
                    for (Map.Entry<String, IAllele> entry : AlleleManager.alleleRegistry.getRegisteredAlleles().entrySet()) {
                        if (!(entry.getValue() instanceof IAlleleBeeSpecies)) continue;
                        change = (IAlleleBeeSpecies)entry.getValue();
                        break;
                    }
                } else {
                    Iterator<Map.Entry<String, IAllele>> it = AlleleManager.alleleRegistry.getRegisteredAlleles().entrySet().iterator();
                    while (it.hasNext()) {
                        IAlleleBeeSpecies species;
                        Map.Entry<String, IAllele> entry = it.next();
                        if (!(entry.getValue() instanceof IAlleleBeeSpecies) || !(species = (IAlleleBeeSpecies)entry.getValue()).getUID().equals(this.getSpecies().getUID())) continue;
                        while (it.hasNext()) {
                            Map.Entry<String, IAllele> entry2 = it.next();
                            if (!(entry2.getValue() instanceof IAlleleBeeSpecies)) continue;
                            IAlleleBeeSpecies next = (IAlleleBeeSpecies)entry2.getValue();
                            if (!Config.isDebug && next.isSecret() && !this.tracker.isDiscovered(next)) continue;
                            change = next;
                            break block7;
                        }
                        break;
                    }
                }
            }
            GuiPropolisPipe.this.pipeLogic.setSpeciesFilter(this.orientation, this.pattern, this.allele, change);
        }
    }

    class TypeFilterSlot
    extends Widget {
        private final ForgeDirection orientation;
        private final PipeLogicPropolis logic;

        public TypeFilterSlot(int x, int y, ForgeDirection orientation, PipeLogicPropolis logic) {
            super(GuiPropolisPipe.this.widgetManager, x, y);
            this.orientation = orientation;
            this.logic = logic;
        }

        public EnumFilterType getType() {
            return this.logic.getTypeFilter(this.orientation);
        }

        @Override
        public void draw(int startX, int startY) {
            EnumFilterType type = this.logic.getTypeFilter(this.orientation);
            IIcon icon = null;
            if (type != null) {
                icon = type.getIcon();
            }
            if (icon == null) {
                return;
            }
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            Proxies.common.bindTexture(SpriteSheet.ITEMS);
            GuiPropolisPipe.this.func_94065_a(startX + this.xPos, startY + this.yPos, icon, 16, 16);
        }

        @Override
        protected String getLegacyTooltip(EntityPlayer player) {
            EnumFilterType type = this.logic.getTypeFilter(this.orientation);
            return StringUtil.localize("gui.pipe.filter." + type.toString().toLowerCase(Locale.ENGLISH));
        }

        @Override
        public void handleMouseClick(int mouseX, int mouseY, int mouseButton) {
            EnumFilterType change = mouseButton == 1 ? EnumFilterType.CLOSED : (this.getType().ordinal() < EnumFilterType.values().length - 1 ? EnumFilterType.values()[this.getType().ordinal() + 1] : EnumFilterType.CLOSED);
            GuiPropolisPipe.this.pipeLogic.setTypeFilter(this.orientation, change);
        }
    }
}

