/*
 * Decompiled with CFR 0.152.
 */
package forestry.mail.gui;

import forestry.api.mail.EnumAddressee;
import forestry.api.mail.TradeStationInfo;
import forestry.core.config.SessionVars;
import forestry.core.gadgets.TileForestry;
import forestry.core.gui.GuiForestry;
import forestry.core.gui.widgets.Widget;
import forestry.core.utils.StringUtil;
import forestry.mail.gui.ContainerCatalogue;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.ResourceLocation;
import org.lwjgl.input.Keyboard;

public class GuiCatalogue
extends GuiForestry<TileForestry> {
    private static final String boldUnderline = EnumChatFormatting.BOLD.toString() + EnumChatFormatting.UNDERLINE;
    private GuiButton buttonFilter;
    private GuiButton buttonCopy;
    private final List<GuiForestry.ItemStackWidget> tradeInfoWidgets = new ArrayList<GuiForestry.ItemStackWidget>();
    private final ContainerCatalogue container;

    public GuiCatalogue(EntityPlayer player) {
        super(new ResourceLocation("textures/gui/book.png"), (Container)new ContainerCatalogue(player));
        this.field_146999_f = 192;
        this.field_147000_g = 192;
        this.container = (ContainerCatalogue)this.field_147002_h;
    }

    public void func_73866_w_() {
        super.func_73866_w_();
        this.field_146292_n.clear();
        Keyboard.enableRepeatEvents((boolean)true);
        this.field_146292_n.add(new GuiButton(2, this.field_146294_l / 2 + 44, this.field_147009_r + 150, 12, 20, ">"));
        this.field_146292_n.add(new GuiButton(3, this.field_146294_l / 2 - 58, this.field_147009_r + 150, 12, 20, "<"));
        this.buttonFilter = new GuiButton(4, this.field_146294_l / 2 - 44, this.field_147009_r + 150, 42, 20, StringUtil.localize("gui.mail.filter.all"));
        this.field_146292_n.add(this.buttonFilter);
        this.buttonCopy = new GuiButton(5, this.field_146294_l / 2, this.field_147009_r + 150, 42, 20, StringUtil.localize("gui.mail.address.copy"));
        this.field_146292_n.add(this.buttonCopy);
    }

    public void func_146281_b() {
        Keyboard.enableRepeatEvents((boolean)false);
        super.func_146281_b();
    }

    @Override
    protected void func_146976_a(float var1, int mouseX, int mouseY) {
        super.func_146976_a(var1, mouseX, mouseY);
        this.field_146289_q.func_78276_b(String.format("%s / %s", this.container.getCurrentPos(), this.container.getMaxCount()), this.field_147003_i + this.field_146999_f - 72, this.field_147009_r + 12, this.fontColor.get("gui.book"));
        this.clearTradeInfoWidgets();
        if (this.container.getTradeInfo() != null) {
            this.drawTradePreview(this.field_147003_i + 38, this.field_147009_r + 30);
        } else {
            this.drawNoTrade(this.field_147003_i + 38, this.field_147009_r + 30);
        }
        this.buttonFilter.field_146126_j = StringUtil.localize("gui.mail.filter." + this.container.getFilterIdent());
        this.buttonCopy.field_146124_l = this.container.getTradeInfo() != null && this.container.getTradeInfo().state.isOk();
    }

    private void drawNoTrade(int x, int y) {
        this.field_146289_q.func_78279_b(StringUtil.localize("gui.mail.notrades"), x, y + 18, 119, this.fontColor.get("gui.book"));
    }

    private void drawTradePreview(int x, int y) {
        this.field_146289_q.func_78276_b(boldUnderline + this.container.getTradeInfo().address.getName(), x, y, this.fontColor.get("gui.book"));
        TradeStationInfo info = this.container.getTradeInfo();
        this.field_146289_q.func_78276_b(String.format(StringUtil.localize("gui.mail.willtrade"), info.owner.getName()), x, y + 18, this.fontColor.get("gui.book"));
        this.addTradeInfoWidget(new GuiForestry.ItemStackWidget(x - this.field_147003_i, y - this.field_147009_r + 28, info.tradegood));
        this.field_146289_q.func_78276_b(StringUtil.localize("gui.mail.tradefor"), x, y + 46, this.fontColor.get("gui.book"));
        for (int i = 0; i < this.container.getTradeInfo().required.length; ++i) {
            this.addTradeInfoWidget(new GuiForestry.ItemStackWidget(x - this.field_147003_i + i * 18, y - this.field_147009_r + 56, info.required[i]));
        }
        if (info.state.isOk()) {
            this.field_146289_q.func_78279_b(EnumChatFormatting.DARK_GREEN + StringUtil.localize("chat.mail." + info.state.getIdentifier()), x, y + 82, 119, this.fontColor.get("gui.book"));
        } else {
            this.field_146289_q.func_78279_b(EnumChatFormatting.DARK_RED + StringUtil.localize("chat.mail." + info.state.getIdentifier()), x, y + 82, 119, this.fontColor.get("gui.book"));
        }
    }

    private void addTradeInfoWidget(GuiForestry.ItemStackWidget widget) {
        this.tradeInfoWidgets.add(widget);
        this.widgetManager.add(widget);
    }

    private void clearTradeInfoWidgets() {
        for (Widget widget : this.tradeInfoWidgets) {
            this.widgetManager.remove(widget);
        }
        this.tradeInfoWidgets.clear();
    }

    protected void func_146284_a(GuiButton button) {
        switch (button.field_146127_k) {
            case 0: {
                this.field_146297_k.field_71439_g.func_71053_j();
                break;
            }
            case 2: {
                this.container.advanceIteration();
                break;
            }
            case 3: {
                this.container.regressIteration();
                break;
            }
            case 4: {
                this.container.cycleFilter();
                break;
            }
            case 5: {
                TradeStationInfo info = this.container.getTradeInfo();
                if (info != null) {
                    SessionVars.setStringVar("mail.letter.recipient", info.address.getName());
                    SessionVars.setStringVar("mail.letter.addressee", EnumAddressee.TRADER.toString());
                }
                this.field_146297_k.field_71439_g.func_71053_j();
            }
        }
    }
}

