/*
 * Decompiled with CFR 0.152.
 */
package forestry.mail.gui;

import com.mojang.authlib.GameProfile;
import forestry.api.mail.EnumAddressee;
import forestry.api.mail.ILetter;
import forestry.api.mail.IMailAddress;
import forestry.api.mail.IPostalCarrier;
import forestry.api.mail.ITradeStation;
import forestry.api.mail.PostManager;
import forestry.api.mail.TradeStationInfo;
import forestry.core.gui.ContainerItemInventory;
import forestry.core.gui.slots.SlotFiltered;
import forestry.core.network.PacketPayload;
import forestry.core.network.PacketUpdate;
import forestry.core.proxy.Proxies;
import forestry.mail.items.ItemLetter;
import forestry.mail.network.PacketLetterInfo;
import java.util.Iterator;
import java.util.UUID;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.World;
import org.apache.commons.lang3.StringUtils;

public class ContainerLetter
extends ContainerItemInventory {
    private final ItemLetter.LetterInventory letterInventory;
    private EnumAddressee carrierType = EnumAddressee.PLAYER;
    private TradeStationInfo tradeInfo = null;

    public ContainerLetter(EntityPlayer player, ItemLetter.LetterInventory inventory) {
        super(inventory, player);
        int j;
        int i;
        this.letterInventory = inventory;
        if (Proxies.common.isSimulating(player.field_70170_p) && this.letterInventory.getLetter().isProcessed() && inventory.parent != null && ItemLetter.getState(inventory.parent.func_77960_j()) < 2) {
            inventory.parent.func_77964_b(ItemLetter.encodeMeta(2, ItemLetter.getSize(inventory.parent.func_77960_j())));
        }
        for (i = 0; i < 4; ++i) {
            this.func_75146_a(new SlotFiltered(inventory, 18 + i, 150, 14 + i * 19).setStackLimit(1));
        }
        for (i = 0; i < 2; ++i) {
            for (j = 0; j < 9; ++j) {
                this.func_75146_a(new SlotFiltered(inventory, 0 + j + i * 9, 17 + j * 18, 98 + i * 18));
            }
        }
        for (i = 0; i < 3; ++i) {
            for (j = 0; j < 9; ++j) {
                this.addSecuredSlot((IInventory)player.field_71071_by, j + i * 9 + 9, 17 + j * 18, 145 + i * 18);
            }
        }
        for (i = 0; i < 9; ++i) {
            this.addSecuredSlot((IInventory)player.field_71071_by, i, 17 + i * 18, 203);
        }
        if (this.letterInventory.getLetter() != null && this.letterInventory.getLetter().getRecipients() != null && this.letterInventory.getLetter().getRecipients().length > 0) {
            this.carrierType = this.letterInventory.getLetter().getRecipients()[0].getType();
        }
    }

    @Override
    public void func_75134_a(EntityPlayer entityplayer) {
        ILetter letter;
        if (Proxies.common.isSimulating(entityplayer.field_70170_p) && !(letter = this.letterInventory.getLetter()).isProcessed()) {
            IMailAddress sender = PostManager.postRegistry.getMailAddress(entityplayer.func_146103_bH());
            letter.setSender(sender);
        }
        super.func_75134_a(entityplayer);
    }

    public ILetter getLetter() {
        return this.letterInventory.getLetter();
    }

    public void setCarrierType(EnumAddressee type) {
        this.carrierType = type;
    }

    public EnumAddressee getCarrierType() {
        return this.carrierType;
    }

    public void advanceCarrierType() {
        Iterator<IPostalCarrier> it = PostManager.postRegistry.getRegisteredCarriers().values().iterator();
        while (it.hasNext() && !it.next().getType().equals((Object)this.carrierType)) {
        }
        IPostalCarrier postal = it.hasNext() ? it.next() : PostManager.postRegistry.getRegisteredCarriers().values().iterator().next();
        this.setCarrierType(postal.getType());
    }

    public void setRecipient(String recipientName, EnumAddressee type) {
        if (StringUtils.isBlank((CharSequence)recipientName) || type == null) {
            return;
        }
        PacketPayload payload = new PacketPayload(0, 0, 2);
        payload.stringPayload[0] = recipientName;
        payload.stringPayload[1] = type.toString();
        PacketUpdate packet = new PacketUpdate(80, payload);
        Proxies.net.sendToServer(packet);
    }

    public void handleSetRecipient(EntityPlayer player, PacketUpdate packet) {
        IMailAddress recipient;
        String recipientName = packet.payload.stringPayload[0];
        String typeName = packet.payload.stringPayload[1];
        EnumAddressee type = EnumAddressee.fromString(typeName);
        if (type == EnumAddressee.PLAYER) {
            GameProfile gameProfile = MinecraftServer.func_71276_C().func_152358_ax().func_152655_a(recipientName);
            if (gameProfile == null) {
                gameProfile = new GameProfile(new UUID(0L, 0L), recipientName);
            }
            recipient = PostManager.postRegistry.getMailAddress(gameProfile);
        } else if (type == EnumAddressee.TRADER) {
            recipient = PostManager.postRegistry.getMailAddress(recipientName);
        } else {
            return;
        }
        this.getLetter().setRecipient(recipient);
        if (recipient == null || recipient.isTrader()) {
            this.updateTradeInfo(player.field_70170_p, recipient);
        }
        Proxies.net.sendToPlayer(new PacketLetterInfo(83, type, this.tradeInfo, recipient), player);
    }

    public IMailAddress getRecipient() {
        if (this.getLetter().getRecipients().length > 0) {
            return this.getLetter().getRecipients()[0];
        }
        return null;
    }

    public String getText() {
        return this.getLetter().getText();
    }

    public void setText(String text) {
        this.getLetter().setText(text);
        PacketPayload payload = new PacketPayload(0, 0, 1);
        payload.stringPayload[0] = text;
        PacketUpdate packet = new PacketUpdate(81, payload);
        Proxies.net.sendToServer(packet);
    }

    public void handleSetText(PacketUpdate packet) {
        this.getLetter().setText(packet.payload.stringPayload[0]);
    }

    public void updateTradeInfo(World world, IMailAddress address) {
        if (!Proxies.common.isSimulating(world)) {
            return;
        }
        if (address == null) {
            this.setTradeInfo(null);
            return;
        }
        ITradeStation station = PostManager.postRegistry.getTradeStation(world, address);
        if (station == null) {
            this.setTradeInfo(null);
            return;
        }
        this.setTradeInfo(station.getTradeInfo());
    }

    public void handleLetterInfoUpdate(PacketLetterInfo packet) {
        this.carrierType = packet.type;
        if (packet.type == EnumAddressee.PLAYER) {
            this.getLetter().setRecipient(packet.address);
        } else if (packet.type == EnumAddressee.TRADER) {
            this.setTradeInfo(packet.tradeInfo);
        }
    }

    public TradeStationInfo getTradeInfo() {
        return this.tradeInfo;
    }

    private void setTradeInfo(TradeStationInfo info) {
        this.tradeInfo = info;
        if (this.tradeInfo == null) {
            this.getLetter().setRecipient(null);
        } else {
            this.getLetter().setRecipient(this.tradeInfo.address);
        }
    }
}

