/*
 * Decompiled with CFR 0.152.
 */
package forestry.mail.gadgets;

import buildcraft.api.statements.ITriggerExternal;
import cpw.mods.fml.common.Optional;
import forestry.api.core.ForestryAPI;
import forestry.api.mail.IMailAddress;
import forestry.api.mail.IStamps;
import forestry.api.mail.PostManager;
import forestry.core.EnumErrorCode;
import forestry.core.gadgets.TileBase;
import forestry.core.inventory.IInventoryAdapter;
import forestry.core.network.GuiId;
import forestry.core.network.PacketPayload;
import forestry.core.proxy.Proxies;
import forestry.core.utils.StackUtils;
import forestry.mail.MailAddress;
import forestry.mail.TradeStation;
import forestry.mail.triggers.MailTriggers;
import java.util.Collection;
import java.util.LinkedList;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.util.ForgeDirection;

public class MachineTrader
extends TileBase {
    private IMailAddress address = new MailAddress();

    public MachineTrader() {
        this.setInternalInventory(new TradeStation.TradeStationInventory(40, "INV"));
    }

    @Override
    public void openGui(EntityPlayer player, TileBase tile) {
        if (this.isLinked()) {
            player.openGui(ForestryAPI.instance, GuiId.TraderGUI.ordinal(), this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e);
        } else {
            player.openGui(ForestryAPI.instance, GuiId.TraderNameGUI.ordinal(), this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e);
        }
    }

    @Override
    public void onRemoval() {
        if (this.isLinked()) {
            PostManager.postRegistry.deleteTradeStation(this.field_145850_b, this.address);
        }
    }

    @Override
    public void func_145841_b(NBTTagCompound nbttagcompound) {
        super.func_145841_b(nbttagcompound);
        if (this.address != null) {
            NBTTagCompound nbt = new NBTTagCompound();
            this.address.writeToNBT(nbt);
            nbttagcompound.func_74782_a("address", (NBTBase)nbt);
        }
    }

    @Override
    public void func_145839_a(NBTTagCompound nbttagcompound) {
        super.func_145839_a(nbttagcompound);
        if (nbttagcompound.func_74764_b("address")) {
            this.address = MailAddress.loadFromNBT(nbttagcompound.func_74775_l("address"));
        }
    }

    @Override
    public PacketPayload getPacketPayload() {
        if (this.address == null || this.address.getName() == null) {
            return null;
        }
        PacketPayload payload = new PacketPayload(0, 0, 1);
        payload.stringPayload[0] = this.address.getName();
        return payload;
    }

    @Override
    public void fromPacketPayload(PacketPayload payload) {
        if (payload.isEmpty()) {
            this.address = null;
            return;
        }
        String addressName = payload.stringPayload[0];
        this.address = PostManager.postRegistry.getMailAddress(addressName);
    }

    @Override
    public void updateServerSide() {
        if (!this.isLinked() || this.field_145850_b.func_82737_E() % 4L != 0L) {
            return;
        }
        EnumErrorCode errorCode = EnumErrorCode.OK;
        if (!this.hasPostageMin(3)) {
            errorCode = EnumErrorCode.NOSTAMPS;
        }
        if (!this.hasPaperMin(2)) {
            errorCode = errorCode == EnumErrorCode.NOSTAMPS ? EnumErrorCode.NOSTAMPSNOPAPER : EnumErrorCode.NOPAPER;
        }
        if (errorCode != EnumErrorCode.OK) {
            this.setErrorState(errorCode);
            return;
        }
        IInventoryAdapter inventory = this.getInternalInventory();
        ItemStack tradeGood = inventory.func_70301_a(0);
        if (tradeGood == null) {
            this.setErrorState(EnumErrorCode.NOTRADE);
            return;
        }
        boolean hasRequest = this.hasItemCount(1, 4, null, 1);
        if (!hasRequest) {
            this.setErrorState(EnumErrorCode.NOTRADE);
            return;
        }
        boolean hasSupplies = this.hasItemCount(30, 10, tradeGood, tradeGood.field_77994_a);
        if (!hasSupplies) {
            this.setErrorState(EnumErrorCode.NOSUPPLIES);
            return;
        }
        if (inventory instanceof TradeStation && !((TradeStation)inventory).canReceivePayment()) {
            this.setErrorState(EnumErrorCode.NOSPACE);
            return;
        }
        this.setErrorState(EnumErrorCode.OK);
    }

    public boolean isLinked() {
        return this.address.isValid() && this.getErrorState() != EnumErrorCode.NOTALPHANUMERIC && this.getErrorState() != EnumErrorCode.NOTUNIQUE;
    }

    private boolean hasItemCount(int startSlot, int countSlots, ItemStack item, int itemCount) {
        int count = 0;
        IInventoryAdapter tradeInventory = this.getInternalInventory();
        for (int i = startSlot; i < startSlot + countSlots; ++i) {
            ItemStack itemInSlot = tradeInventory.func_70301_a(i);
            if (itemInSlot == null) continue;
            if (item == null || StackUtils.isIdenticalItem(itemInSlot, item)) {
                count += itemInSlot.field_77994_a;
            }
            if (count < itemCount) continue;
            return true;
        }
        return false;
    }

    private float percentOccupied(int startSlot, int countSlots, ItemStack item) {
        int count = 0;
        int total = 0;
        IInventoryAdapter tradeInventory = this.getInternalInventory();
        for (int i = startSlot; i < startSlot + countSlots; ++i) {
            ItemStack itemInSlot = tradeInventory.func_70301_a(i);
            if (itemInSlot == null) {
                total += 64;
                continue;
            }
            total += itemInSlot.func_77976_d();
            if (item != null && !StackUtils.isIdenticalItem(itemInSlot, item)) continue;
            count += itemInSlot.field_77994_a;
        }
        return (float)count / (float)total;
    }

    public boolean hasPaperMin(int count) {
        return this.hasItemCount(5, 6, new ItemStack(Items.field_151121_aF), count);
    }

    public boolean hasInputBufMin(float percentage) {
        IInventoryAdapter inventory = this.getInternalInventory();
        ItemStack tradeGood = inventory.func_70301_a(0);
        if (tradeGood == null) {
            return true;
        }
        return this.percentOccupied(30, 10, tradeGood) > percentage;
    }

    public boolean hasOutputBufMin(float percentage) {
        return this.percentOccupied(15, 15, null) > percentage;
    }

    public boolean hasPostageMin(int postage) {
        int posted = 0;
        IInventoryAdapter tradeInventory = this.getInternalInventory();
        for (int i = 11; i < 15; ++i) {
            ItemStack stamp = tradeInventory.func_70301_a(i);
            if (stamp == null || !(stamp.func_77973_b() instanceof IStamps) || (posted += ((IStamps)stamp.func_77973_b()).getPostage(stamp).getValue() * stamp.field_77994_a) < postage) continue;
            return true;
        }
        return false;
    }

    public IMailAddress getAddress() {
        return this.address;
    }

    public void setAddress(IMailAddress address) {
        if (address == null) {
            throw new NullPointerException("address must not be null");
        }
        if (this.address.isValid() && this.address.equals(address)) {
            return;
        }
        if (Proxies.common.isSimulating(this.field_145850_b)) {
            if (!PostManager.postRegistry.isValidTradeAddress(this.field_145850_b, address)) {
                this.setErrorState(EnumErrorCode.NOTALPHANUMERIC);
                return;
            }
            if (!PostManager.postRegistry.isAvailableTradeAddress(this.field_145850_b, address)) {
                this.setErrorState(EnumErrorCode.NOTUNIQUE);
                return;
            }
            this.address = address;
            PostManager.postRegistry.getOrCreateTradeStation(this.field_145850_b, this.getOwnerProfile(), address);
            this.setErrorState(EnumErrorCode.OK);
        }
    }

    @Override
    public IInventoryAdapter getInternalInventory() {
        if (!Proxies.common.isSimulating(this.field_145850_b) || !this.address.isValid()) {
            return super.getInternalInventory();
        }
        return (TradeStation)PostManager.postRegistry.getOrCreateTradeStation(this.field_145850_b, this.getOwnerProfile(), this.address);
    }

    @Override
    @Optional.Method(modid="BuildCraftAPI|statements")
    public Collection<ITriggerExternal> getExternalTriggers(ForgeDirection side, TileEntity tile) {
        LinkedList<ITriggerExternal> res = new LinkedList<ITriggerExternal>();
        res.add(MailTriggers.lowPaper64);
        res.add(MailTriggers.lowPaper32);
        res.add(MailTriggers.lowInput25);
        res.add(MailTriggers.lowInput10);
        res.add(MailTriggers.lowPostage40);
        res.add(MailTriggers.lowPostage20);
        res.add(MailTriggers.highBuffer90);
        res.add(MailTriggers.highBuffer75);
        return res;
    }
}

