/*
 * Decompiled with CFR 0.152.
 */
package forestry.mail.gadgets;

import buildcraft.api.statements.ITriggerExternal;
import com.mojang.authlib.GameProfile;
import cpw.mods.fml.common.Optional;
import forestry.api.core.ForestryAPI;
import forestry.api.mail.ILetter;
import forestry.api.mail.IMailAddress;
import forestry.api.mail.IPostalState;
import forestry.api.mail.PostManager;
import forestry.core.config.Config;
import forestry.core.gadgets.TileBase;
import forestry.core.inventory.InventoryAdapter;
import forestry.core.network.GuiId;
import forestry.core.proxy.Proxies;
import forestry.mail.EnumDeliveryState;
import forestry.mail.IMailContainer;
import forestry.mail.PostRegistry;
import forestry.mail.triggers.MailTriggers;
import java.util.Collection;
import java.util.LinkedList;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ChatComponentTranslation;
import net.minecraft.util.IChatComponent;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class MachineMailbox
extends TileBase
implements IMailContainer {
    private boolean isLinked = false;

    public MachineMailbox() {
        this.setHints(Config.hints.get("mailbox"));
        this.setInternalInventory(new InventoryAdapter(84, "Letters").disableAutomation());
    }

    @Override
    public void openGui(EntityPlayer player, TileBase tile) {
        if (!Proxies.common.isSimulating(this.field_145850_b)) {
            return;
        }
        ItemStack held = player.func_71045_bC();
        if (PostManager.postRegistry.isLetter(held)) {
            IPostalState result = this.tryDispatchLetter(held, true);
            if (!result.isOk()) {
                player.func_145747_a((IChatComponent)new ChatComponentTranslation("for.chat.mail." + result.getIdentifier(), new Object[0]));
            } else {
                --held.field_77994_a;
            }
        } else {
            player.openGui(ForestryAPI.instance, GuiId.MailboxGUI.ordinal(), player.field_70170_p, this.field_145851_c, this.field_145848_d, this.field_145849_e);
        }
    }

    @Override
    public void updateServerSide() {
        if (!this.isLinked) {
            this.getOrCreateMailInventory(this.field_145850_b, this.getOwnerProfile());
            this.isLinked = true;
        }
    }

    public IInventory getOrCreateMailInventory(World world, GameProfile playerProfile) {
        if (!Proxies.common.isSimulating(world)) {
            return this.getInternalInventory();
        }
        IMailAddress address = PostManager.postRegistry.getMailAddress(playerProfile);
        return PostRegistry.getOrCreatePOBox(this.field_145850_b, address);
    }

    private IPostalState tryDispatchLetter(ItemStack letterstack, boolean dispatchLetter) {
        ILetter letter = PostManager.postRegistry.getLetter(letterstack);
        IPostalState result = letter != null ? PostManager.postRegistry.getPostOffice(this.field_145850_b).lodgeLetter(this.field_145850_b, letterstack, dispatchLetter) : EnumDeliveryState.NOT_MAILABLE;
        return result;
    }

    @Override
    public boolean hasMail() {
        IInventory mailInventory = this.getOrCreateMailInventory(this.field_145850_b, this.getOwnerProfile());
        for (int i = 0; i < mailInventory.func_70302_i_(); ++i) {
            if (mailInventory.func_70301_a(i) == null) continue;
            return true;
        }
        return false;
    }

    @Override
    @Optional.Method(modid="BuildCraftAPI|statements")
    public Collection<ITriggerExternal> getExternalTriggers(ForgeDirection side, TileEntity tile) {
        LinkedList<ITriggerExternal> res = new LinkedList<ITriggerExternal>();
        res.add(MailTriggers.triggerHasMail);
        return res;
    }
}

