/*
 * Decompiled with CFR 0.152.
 */
package forestry.mail;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import forestry.api.mail.EnumAddressee;
import forestry.api.mail.IMailAddress;
import forestry.api.mail.IPostOffice;
import forestry.api.mail.IPostalCarrier;
import forestry.api.mail.IPostalState;
import forestry.api.mail.ITradeStation;
import forestry.api.mail.PostManager;
import forestry.core.render.TextureManager;
import forestry.core.utils.StringUtil;
import forestry.mail.EnumDeliveryState;
import forestry.mail.POBox;
import forestry.mail.PostRegistry;
import forestry.plugins.PluginMail;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IIcon;
import net.minecraft.world.World;

public class PostalCarrier
implements IPostalCarrier {
    private final String iconID;
    private final EnumAddressee type;

    public PostalCarrier(EnumAddressee type) {
        this.iconID = "mail/carrier." + (Object)((Object)type);
        this.type = type;
    }

    @Override
    public EnumAddressee getType() {
        return this.type;
    }

    @Override
    public String getName() {
        return StringUtil.localize("gui.addressee." + (Object)((Object)this.type));
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public IIcon getIcon() {
        return TextureManager.getInstance().getDefault(this.iconID);
    }

    @Override
    public IPostalState deliverLetter(World world, IPostOffice office, IMailAddress recipient, ItemStack letterstack, boolean doDeliver) {
        if (this.type == EnumAddressee.TRADER) {
            return this.handleTradeLetter(world, office, recipient, letterstack, doDeliver);
        }
        return this.storeInPOBox(world, office, recipient, letterstack, doDeliver);
    }

    private IPostalState handleTradeLetter(World world, IPostOffice office, IMailAddress recipient, ItemStack letterstack, boolean doLodge) {
        ITradeStation trade = PostManager.postRegistry.getTradeStation(world, recipient);
        if (trade == null) {
            return EnumDeliveryState.NO_MAILBOX;
        }
        return trade.handleLetter(world, recipient, letterstack, doLodge);
    }

    private EnumDeliveryState storeInPOBox(World world, IPostOffice office, IMailAddress recipient, ItemStack letterstack, boolean doLodge) {
        POBox pobox = PostRegistry.getPOBox(world, recipient);
        if (pobox == null) {
            return EnumDeliveryState.NO_MAILBOX;
        }
        if (!pobox.storeLetter(letterstack.func_77946_l())) {
            return EnumDeliveryState.MAILBOX_FULL;
        }
        PluginMail.proxy.setPOBoxInfo(world, recipient, pobox.getPOBoxInfo());
        return EnumDeliveryState.OK;
    }
}

