/*
 * Decompiled with CFR 0.152.
 */
package forestry.mail;

import forestry.core.interfaces.IPacketHandler;
import forestry.core.network.PacketUpdate;
import forestry.core.proxy.Proxies;
import forestry.mail.MailAddress;
import forestry.mail.POBox;
import forestry.mail.PostRegistry;
import forestry.mail.gui.ContainerCatalogue;
import forestry.mail.gui.ContainerLetter;
import forestry.mail.gui.ContainerTradeName;
import forestry.mail.network.PacketLetterInfo;
import forestry.mail.network.PacketPOBoxInfo;
import forestry.plugins.PluginMail;
import java.io.DataInputStream;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;

public class PacketHandlerMail
implements IPacketHandler {
    @Override
    public void onPacketData(int packetID, DataInputStream data, EntityPlayer player) {
        try {
            switch (packetID) {
                case 83: {
                    PacketLetterInfo packetT = new PacketLetterInfo();
                    packetT.readData(data);
                    this.onLetterInfo(packetT);
                    break;
                }
                case 85: {
                    PacketPOBoxInfo packetP = new PacketPOBoxInfo();
                    packetP.readData(data);
                    this.onPOBoxInfo(packetP);
                    break;
                }
                case 80: {
                    PacketUpdate packet = new PacketUpdate();
                    packet.readData(data);
                    this.onLetterRecipient(player, packet);
                    break;
                }
                case 81: {
                    PacketUpdate packet = new PacketUpdate();
                    packet.readData(data);
                    this.onLetterText(player, packet);
                    break;
                }
                case 82: {
                    PacketUpdate packet = new PacketUpdate();
                    packet.readData(data);
                    this.onAddressSet(player, packet);
                    break;
                }
                case 86: {
                    this.onPOBoxInfoRequest(player);
                }
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private void onLetterInfo(PacketLetterInfo packet) {
        Container container = Proxies.common.getClientInstance().field_71439_g.field_71070_bA;
        if (container instanceof ContainerLetter) {
            ((ContainerLetter)container).handleLetterInfoUpdate(packet);
        } else if (container instanceof ContainerCatalogue) {
            ((ContainerCatalogue)container).handleTradeInfoUpdate(packet);
        }
    }

    private void onPOBoxInfo(PacketPOBoxInfo packet) {
        MailAddress address = new MailAddress(Proxies.common.getClientInstance().field_71439_g.func_146103_bH());
        PluginMail.proxy.setPOBoxInfo(Proxies.common.getRenderWorld(), address, packet.poboxInfo);
    }

    private void onAddressSet(EntityPlayer player, PacketUpdate packet) {
        if (!(player.field_71070_bA instanceof ContainerTradeName)) {
            return;
        }
        ((ContainerTradeName)player.field_71070_bA).handleSetAddress(packet);
    }

    private void onLetterText(EntityPlayer player, PacketUpdate packet) {
        if (!(player.field_71070_bA instanceof ContainerLetter)) {
            return;
        }
        ((ContainerLetter)player.field_71070_bA).handleSetText(packet);
    }

    private void onLetterRecipient(EntityPlayer player, PacketUpdate packet) {
        if (!(player.field_71070_bA instanceof ContainerLetter)) {
            return;
        }
        ((ContainerLetter)player.field_71070_bA).handleSetRecipient(player, packet);
    }

    private void onPOBoxInfoRequest(EntityPlayer player) {
        MailAddress address = new MailAddress(player.func_146103_bH());
        POBox pobox = PostRegistry.getPOBox(player.field_70170_p, address);
        if (pobox == null) {
            return;
        }
        Proxies.net.sendToPlayer(new PacketPOBoxInfo(85, pobox.getPOBoxInfo()), player);
    }
}

