/*
 * Decompiled with CFR 0.152.
 */
package forestry.mail;

import com.mojang.authlib.GameProfile;
import forestry.api.core.INBTTagable;
import forestry.api.mail.EnumAddressee;
import forestry.api.mail.IMailAddress;
import forestry.core.utils.PlayerUtil;
import java.util.Locale;
import java.util.UUID;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTUtil;

public class MailAddress
implements INBTTagable,
IMailAddress {
    private static final GameProfile invalidGameProfile = new GameProfile(new UUID(0L, 0L), "");
    private EnumAddressee type;
    private GameProfile gameProfile;

    public MailAddress() {
        this.type = EnumAddressee.PLAYER;
        this.gameProfile = invalidGameProfile;
    }

    public MailAddress(GameProfile gameProfile) {
        if (gameProfile == null) {
            throw new IllegalArgumentException("gameProfile must not be null");
        }
        this.type = EnumAddressee.PLAYER;
        this.gameProfile = gameProfile;
    }

    public MailAddress(String name) {
        if (name == null) {
            throw new IllegalArgumentException("name must not be null");
        }
        this.type = EnumAddressee.TRADER;
        this.gameProfile = new GameProfile(null, name);
    }

    public MailAddress(IMailAddress address) {
        this.type = address.getType();
        if (this.type == EnumAddressee.TRADER) {
            String name = address.getName();
            this.gameProfile = new GameProfile(null, name);
        } else if (this.type == EnumAddressee.PLAYER) {
            this.gameProfile = address.getPlayerProfile();
        }
    }

    public static MailAddress loadFromNBT(NBTTagCompound nbttagcompound) {
        MailAddress address = new MailAddress();
        address.readFromNBT(nbttagcompound);
        return address;
    }

    @Override
    public EnumAddressee getType() {
        return this.type;
    }

    @Override
    public String getName() {
        return this.gameProfile.getName();
    }

    @Override
    public boolean isValid() {
        return this.gameProfile.getName() != null && !PlayerUtil.isSameGameProfile(this.gameProfile, invalidGameProfile);
    }

    @Override
    public boolean isPlayer() {
        return this.type == EnumAddressee.PLAYER;
    }

    @Override
    public boolean isTrader() {
        return this.type == EnumAddressee.TRADER;
    }

    @Override
    public GameProfile getPlayerProfile() {
        if (!this.isPlayer()) {
            return null;
        }
        return this.gameProfile;
    }

    public int hashCode() {
        return this.gameProfile.getName().hashCode();
    }

    public boolean equals(Object o) {
        if (!(o instanceof MailAddress)) {
            return false;
        }
        MailAddress address = (MailAddress)o;
        return PlayerUtil.isSameGameProfile(address.gameProfile, this.gameProfile);
    }

    public String toString() {
        String name = this.getName().toLowerCase(Locale.ENGLISH);
        if (this.isPlayer()) {
            return (Object)((Object)this.type) + "-" + name + "-" + this.gameProfile.getId();
        }
        return (Object)((Object)this.type) + "-" + name;
    }

    @Override
    public void readFromNBT(NBTTagCompound nbttagcompound) {
        this.type = null;
        if (nbttagcompound.func_74764_b("TP")) {
            String typeName = nbttagcompound.func_74779_i("TP");
            this.type = EnumAddressee.fromString(typeName);
        }
        if (this.type == null) {
            this.type = EnumAddressee.PLAYER;
            this.gameProfile = invalidGameProfile;
        } else if (nbttagcompound.func_74764_b("profile")) {
            NBTTagCompound profileTag = nbttagcompound.func_74775_l("profile");
            this.gameProfile = NBTUtil.func_152459_a((NBTTagCompound)profileTag);
        }
    }

    @Override
    public void writeToNBT(NBTTagCompound nbttagcompound) {
        nbttagcompound.func_74778_a("TP", this.type.toString());
        if (this.gameProfile != null) {
            NBTTagCompound profileNbt = new NBTTagCompound();
            NBTUtil.func_152460_a((NBTTagCompound)profileNbt, (GameProfile)this.gameProfile);
            nbttagcompound.func_74782_a("profile", (NBTBase)profileNbt);
        }
    }
}

