/*
 * Decompiled with CFR 0.152.
 */
package forestry.food.items;

import forestry.api.core.ForestryAPI;
import forestry.api.food.BeverageManager;
import forestry.api.food.IBeverageEffect;
import forestry.api.food.IInfuserManager;
import forestry.api.food.IIngredientManager;
import forestry.core.CreativeTabForestry;
import forestry.core.config.ForestryItem;
import forestry.core.inventory.ItemInventory;
import forestry.core.items.ItemForestry;
import forestry.core.network.GuiId;
import forestry.core.proxy.Proxies;
import forestry.food.BeverageEffect;
import forestry.food.items.ItemBeverage;
import forestry.plugins.PluginManager;
import java.util.ArrayList;
import java.util.Arrays;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;

public class ItemInfuser
extends ItemForestry {
    public ItemInfuser() {
        this.func_77625_d(1);
        this.func_77637_a(CreativeTabForestry.tabForestry);
    }

    public ItemStack func_77659_a(ItemStack itemstack, World world, EntityPlayer entityplayer) {
        if (Proxies.common.isSimulating(world)) {
            entityplayer.openGui(ForestryAPI.instance, GuiId.InfuserGUI.ordinal(), world, (int)entityplayer.field_70165_t, (int)entityplayer.field_70163_u, (int)entityplayer.field_70161_v);
        }
        return itemstack;
    }

    public static void initialize() {
        if (PluginManager.Module.APICULTURE.isEnabled()) {
            BeverageManager.ingredientManager.addIngredient(ForestryItem.pollenCluster.getItemStack(1, 0), "Strong Curative");
            BeverageManager.ingredientManager.addIngredient(ForestryItem.pollenCluster.getItemStack(1, 1), "Weak Curative");
            BeverageManager.infuserManager.addMixture(1, ForestryItem.pollenCluster.getItemStack(1, 0), BeverageEffect.strongAntidote);
            BeverageManager.infuserManager.addMixture(1, ForestryItem.pollenCluster.getItemStack(1, 1), BeverageEffect.weakAntidote);
        }
    }

    public static class InfuserInventory
    extends ItemInventory {
        private final short inputSlot = 0;
        private final short outputSlot = 1;
        private final short ingredientSlot1 = (short)2;
        private final short ingredientSlotCount = (short)4;
        private final EntityPlayer player;

        public InfuserInventory(EntityPlayer player, ItemStack itemStack) {
            super(ItemInfuser.class, 6, itemStack);
            this.player = player;
        }

        private void trySeasoning() {
            ItemStack[] toRemove;
            if (this.inventoryStacks[0] == null) {
                return;
            }
            if (this.inventoryStacks[1] != null) {
                return;
            }
            if (!this.inventoryStacks[0].func_77969_a(ForestryItem.beverage.getItemStack())) {
                return;
            }
            ItemStack[] ingredients = new ItemStack[4];
            System.arraycopy(this.inventoryStacks, 2, ingredients, 0, 4);
            if (!BeverageManager.infuserManager.hasMixtures(ingredients)) {
                return;
            }
            ItemStack seasoned = BeverageManager.infuserManager.getSeasoned(this.inventoryStacks[0], ingredients);
            if (seasoned == null) {
                return;
            }
            block0: for (ItemStack templ : toRemove = BeverageManager.infuserManager.getRequired(ingredients)) {
                ItemStack ghost = templ.func_77946_l();
                for (int i = 2; i < this.func_70302_i_(); ++i) {
                    if (this.inventoryStacks[i] == null) continue;
                    if (ghost.field_77994_a <= 0) continue block0;
                    if ((ghost.func_77960_j() < 0 || !this.inventoryStacks[i].func_77969_a(ghost)) && (ghost.func_77960_j() >= 0 || ghost.func_77973_b() != this.inventoryStacks[i].func_77973_b())) continue;
                    ItemStack removed = this.func_70298_a(i, 1);
                    ghost.field_77994_a -= removed.field_77994_a;
                }
            }
            this.func_70298_a(0, 1);
            this.inventoryStacks[1] = seasoned;
        }

        @Override
        public void func_70296_d() {
            if (!Proxies.common.isSimulating(this.player.field_70170_p)) {
                return;
            }
            this.trySeasoning();
        }

        @Override
        public String func_145825_b() {
            return "Infuser";
        }

        @Override
        public boolean canSlotAccept(int slotIndex, ItemStack itemStack) {
            if (slotIndex == 0) {
                ForestryItem.beverage.isItemEqual(itemStack);
            } else if (slotIndex >= 2 && slotIndex < 6) {
                BeverageManager.infuserManager.isIngredient(itemStack);
            }
            return false;
        }
    }

    public static class IngredientManager
    implements IIngredientManager {
        private final ArrayList<Ingredient> ingredients = new ArrayList();

        @Override
        public void addIngredient(ItemStack ingredient, String description) {
            this.ingredients.add(new Ingredient(ingredient, description));
        }

        @Override
        public String getDescription(ItemStack itemstack) {
            if (itemstack == null) {
                return null;
            }
            for (Ingredient ingredient : this.ingredients) {
                if (ingredient.ingredient.func_77960_j() < 0 && ingredient.ingredient.func_77973_b() == itemstack.func_77973_b()) {
                    return ingredient.description;
                }
                if (ingredient.ingredient.func_77960_j() < 0 || !ingredient.ingredient.func_77969_a(itemstack)) continue;
                return ingredient.description;
            }
            return null;
        }
    }

    public static class Ingredient {
        public final ItemStack ingredient;
        public final String description;

        public Ingredient(ItemStack ingredient, String description) {
            this.ingredient = ingredient;
            this.description = description;
        }
    }

    public static class MixtureManager
    implements IInfuserManager {
        private final ArrayList<Mixture> mixtures = new ArrayList();

        @Override
        public void addMixture(int meta, ItemStack ingredient, IBeverageEffect effect) {
            this.mixtures.add(new Mixture(meta, ingredient, effect));
        }

        @Override
        public void addMixture(int meta, ItemStack[] ingredients, IBeverageEffect effect) {
            this.mixtures.add(new Mixture(meta, ingredients, effect));
        }

        @Override
        public boolean isIngredient(ItemStack itemstack) {
            for (Mixture ingredient : this.mixtures) {
                if (!ingredient.isIngredient(itemstack)) continue;
                return true;
            }
            return false;
        }

        private Mixture[] getMatchingMixtures(ItemStack[] ingredients) {
            ArrayList<Mixture> matches = new ArrayList<Mixture>();
            for (Mixture mixture : this.mixtures) {
                if (!mixture.matches(ingredients)) continue;
                matches.add(mixture);
            }
            return matches.toArray(new Mixture[matches.size()]);
        }

        @Override
        public boolean hasMixtures(ItemStack[] ingredients) {
            return this.getMatchingMixtures(ingredients).length > 0;
        }

        @Override
        public ItemStack[] getRequired(ItemStack[] ingredients) {
            Mixture[] mixtures = this.getMatchingMixtures(ingredients);
            ArrayList<ItemStack> required = new ArrayList<ItemStack>();
            for (Mixture mixture : mixtures) {
                required.addAll(Arrays.asList(mixture.getIngredients()));
            }
            return required.toArray(new ItemStack[required.size()]);
        }

        @Override
        public ItemStack getSeasoned(ItemStack base, ItemStack[] ingredients) {
            Mixture[] mixtures = this.getMatchingMixtures(ingredients);
            ArrayList<IBeverageEffect> effects = new ArrayList<IBeverageEffect>();
            effects.addAll(Arrays.asList(((ItemBeverage)base.func_77973_b()).beverages[base.func_77960_j()].loadEffects(base)));
            int weight = 0;
            int meta = 0;
            for (Mixture mixture : mixtures) {
                effects.add(mixture.getEffect());
                if (mixture.getWeight() <= weight) continue;
                weight = mixture.getWeight();
                meta = mixture.getMeta();
            }
            ItemStack seasoned = base.func_77946_l();
            seasoned.func_77964_b(meta);
            ((ItemBeverage)base.func_77973_b()).beverages[meta].saveEffects(seasoned, effects.toArray(new IBeverageEffect[effects.size()]));
            return seasoned;
        }
    }

    public static class Mixture {
        private final int meta;
        private final ItemStack[] ingredients;
        private final IBeverageEffect effect;

        public Mixture(int meta, ItemStack ingredient, IBeverageEffect effect) {
            this(meta, new ItemStack[]{ingredient}, effect);
        }

        public Mixture(int meta, ItemStack[] ingredients, IBeverageEffect effect) {
            this.meta = meta;
            this.ingredients = ingredients;
            this.effect = effect;
        }

        public ItemStack[] getIngredients() {
            return this.ingredients;
        }

        public boolean isIngredient(ItemStack itemstack) {
            for (ItemStack ingredient : this.ingredients) {
                if (ingredient.func_77960_j() < 0 && ingredient.func_77973_b() == itemstack.func_77973_b()) {
                    return true;
                }
                if (ingredient.func_77960_j() < 0 || !ingredient.func_77969_a(itemstack)) continue;
                return true;
            }
            return false;
        }

        public boolean matches(ItemStack[] res) {
            if (res == null || res.length <= 0) {
                return false;
            }
            boolean matchedAll = true;
            for (ItemStack stack : this.ingredients) {
                boolean matched = false;
                for (ItemStack matchStack : res) {
                    if (matchStack == null) continue;
                    if (stack.func_77960_j() < 0 && stack.func_77973_b() == matchStack.func_77973_b()) {
                        if (stack.field_77994_a > matchStack.field_77994_a) continue;
                        matched = true;
                        break;
                    }
                    if (stack.func_77960_j() < 0 || !stack.func_77969_a(matchStack) || stack.field_77994_a > matchStack.field_77994_a) continue;
                    matched = true;
                    break;
                }
                if (matched) continue;
                matchedAll = false;
            }
            return matchedAll;
        }

        public IBeverageEffect getEffect() {
            return this.effect;
        }

        public int getMeta() {
            return this.meta;
        }

        public int getWeight() {
            return this.ingredients.length;
        }
    }
}

