/*
 * Decompiled with CFR 0.152.
 */
package forestry.farming.logic;

import forestry.api.farming.IFarmHousing;
import forestry.api.farming.IFarmable;
import forestry.core.utils.BlockUtil;
import forestry.core.utils.StackUtils;
import forestry.core.vect.Vect;
import forestry.farming.logic.FarmLogic;
import java.util.ArrayList;
import net.minecraft.item.ItemStack;
import net.minecraftforge.common.util.ForgeDirection;

public abstract class FarmLogicHomogeneous
extends FarmLogic {
    protected final ItemStack[] resource;
    protected final ItemStack groundBlock;
    protected final IFarmable[] germlings;
    ArrayList<ItemStack> produce = new ArrayList();

    public FarmLogicHomogeneous(IFarmHousing housing, ItemStack[] resource, ItemStack groundBlock, IFarmable[] germlings) {
        super(housing);
        this.resource = resource;
        this.groundBlock = groundBlock;
        this.germlings = germlings;
    }

    public boolean isAcceptedGround(ItemStack itemStack) {
        return StackUtils.isIdenticalItem(this.groundBlock, itemStack);
    }

    @Override
    public boolean isAcceptedResource(ItemStack itemstack) {
        return this.resource[0].func_77969_a(itemstack);
    }

    @Override
    public boolean isAcceptedGermling(ItemStack itemstack) {
        for (IFarmable germling : this.germlings) {
            if (!germling.isGermling(itemstack)) continue;
            return true;
        }
        return false;
    }

    public boolean isWindfall(ItemStack itemstack) {
        for (IFarmable germling : this.germlings) {
            if (!germling.isWindfall(itemstack)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean cultivate(int x, int y, int z, ForgeDirection direction, int extent) {
        if (this.maintainSoil(x, y, z, direction, extent)) {
            return true;
        }
        return this.maintainGermlings(x, y + 1, z, direction, extent);
    }

    private boolean maintainSoil(int x, int yGround, int z, ForgeDirection direction, int extent) {
        if (!this.housing.hasResources(this.resource)) {
            return false;
        }
        for (int i = 0; i < extent; ++i) {
            Vect position = this.translateWithOffset(x, yGround, z, direction, i);
            ItemStack stack = this.getAsItemStack(position);
            if (this.isAcceptedGround(stack) || !this.canBreakGround(this.getBlock(position))) continue;
            this.produce.addAll(BlockUtil.getBlockItemStack(this.getWorld(), position));
            this.setBlock(position, StackUtils.getBlock(this.groundBlock), this.groundBlock.func_77960_j());
            this.housing.removeResources(this.resource);
            return true;
        }
        return false;
    }

    protected abstract boolean maintainGermlings(int var1, int var2, int var3, ForgeDirection var4, int var5);
}

