/*
 * Decompiled with CFR 0.152.
 */
package forestry.farming.logic;

import forestry.api.farming.IFarmHousing;
import forestry.api.farming.IFarmLogic;
import forestry.core.config.ForestryBlock;
import forestry.core.render.SpriteSheet;
import forestry.core.vect.IVect;
import forestry.core.vect.Vect;
import java.util.HashSet;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public abstract class FarmLogic
implements IFarmLogic {
    protected final IFarmHousing housing;
    protected boolean isManual;
    private static final HashSet<Block> breakable = new HashSet();

    public FarmLogic(IFarmHousing housing) {
        this.housing = housing;
    }

    @Override
    public FarmLogic setManual(boolean flag) {
        this.isManual = flag;
        return this;
    }

    public boolean canBreakGround(Block block) {
        if (breakable.isEmpty()) {
            breakable.add(Blocks.field_150350_a);
            breakable.add(Blocks.field_150346_d);
            breakable.add((Block)Blocks.field_150349_c);
            breakable.add((Block)Blocks.field_150354_m);
            breakable.add(Blocks.field_150458_ak);
            breakable.add((Block)Blocks.field_150391_bh);
            breakable.add(Blocks.field_150425_aM);
            breakable.add(Blocks.field_150355_j);
            breakable.add((Block)Blocks.field_150358_i);
            breakable.add(ForestryBlock.soil.block());
        }
        return breakable.contains(block);
    }

    protected World getWorld() {
        return this.housing.getWorld();
    }

    @Override
    public ResourceLocation getSpriteSheet() {
        return SpriteSheet.ITEMS.getLocation();
    }

    protected final boolean isAirBlock(IVect position) {
        return this.getWorld().func_147437_c(position.getX(), position.getY(), position.getZ());
    }

    protected final boolean isAirBlock(Block block) {
        return block.func_149688_o() == Material.field_151579_a;
    }

    protected final boolean isWaterSourceBlock(World world, Vect position) {
        return world.func_147439_a(position.x, position.y, position.z) == Blocks.field_150355_j && world.func_72805_g(position.x, position.y, position.z) == 0;
    }

    protected final boolean isWoodBlock(IVect position) {
        Block block = this.getBlock(position);
        return block.isWood((IBlockAccess)this.getWorld(), position.getX(), position.getY(), position.getZ());
    }

    protected final Block getBlock(IVect position) {
        return this.getWorld().func_147439_a(position.getX(), position.getY(), position.getZ());
    }

    protected final int getBlockMeta(IVect position) {
        return this.getWorld().func_72805_g(position.getX(), position.getY(), position.getZ());
    }

    protected final ItemStack getAsItemStack(IVect position) {
        return new ItemStack(this.getBlock(position), 1, this.getBlockMeta(position));
    }

    protected final Vect translateWithOffset(int x, int y, int z, ForgeDirection direction, int step) {
        return new Vect(x + direction.offsetX * step, y + direction.offsetY * step, z + direction.offsetZ * step);
    }

    protected final void setBlock(Vect position, Block block, int meta) {
        this.getWorld().func_147465_d(position.x, position.y, position.z, block, meta, 3);
    }
}

