/*
 * Decompiled with CFR 0.152.
 */
package forestry.farming.gadgets;

import buildcraft.api.statements.ITriggerExternal;
import cpw.mods.fml.common.Optional;
import forestry.api.core.ITileStructure;
import forestry.core.inventory.AdjacentInventoryCache;
import forestry.core.inventory.IInventoryAdapter;
import forestry.core.inventory.ITileFilter;
import forestry.core.inventory.InvTools;
import forestry.core.inventory.wrappers.InventoryMapper;
import forestry.farming.gadgets.TileFarm;
import forestry.farming.gadgets.TileFarmPlain;
import forestry.farming.triggers.FarmingTriggers;
import java.util.Collection;
import java.util.LinkedList;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.util.ForgeDirection;

public class TileHatch
extends TileFarm
implements ISidedInventory {
    private static final ForgeDirection[] dumpDirections = new ForgeDirection[]{ForgeDirection.DOWN};
    private final AdjacentInventoryCache inventoryCache = new AdjacentInventoryCache(this, this.getTileCache(), new ITileFilter(){

        @Override
        public boolean matches(TileEntity tile) {
            return !(tile instanceof TileFarm) && tile.field_145848_d < TileHatch.this.field_145848_d;
        }
    }, null);

    public TileHatch() {
        this.fixedType = 5;
    }

    @Override
    public boolean hasFunction() {
        return true;
    }

    @Override
    protected void updateServerSide() {
        if (this.field_145850_b.func_82737_E() % 40L == 0L) {
            this.dumpStash();
        }
    }

    private IInventory getProductInventory() {
        IInventoryAdapter inventory = this.getStructureInventory();
        return new InventoryMapper((IInventory)inventory, 12, 8);
    }

    protected void dumpStash() {
        IInventory productInventory = this.getProductInventory();
        if (productInventory == null) {
            return;
        }
        if (!InvTools.moveOneItemToPipe(productInventory, this.tileCache, dumpDirections)) {
            InvTools.moveItemStack(productInventory, this.inventoryCache.getAdjacentInventories());
        }
    }

    @Override
    public IInventoryAdapter getInternalInventory() {
        ITileStructure central = this.getCentralTE();
        if (central instanceof TileFarmPlain) {
            return ((TileFarmPlain)central).getInternalInventory();
        }
        return super.getInternalInventory();
    }

    @Override
    @Optional.Method(modid="BuildCraftAPI|statements")
    public Collection<ITriggerExternal> getExternalTriggers(ForgeDirection side, TileEntity tile) {
        if (!this.hasMaster()) {
            return null;
        }
        LinkedList<ITriggerExternal> list = new LinkedList<ITriggerExternal>();
        list.add(FarmingTriggers.lowResourceLiquid50);
        list.add(FarmingTriggers.lowResourceLiquid25);
        list.add(FarmingTriggers.lowSoil128);
        list.add(FarmingTriggers.lowSoil64);
        list.add(FarmingTriggers.lowSoil32);
        list.add(FarmingTriggers.lowFertilizer50);
        list.add(FarmingTriggers.lowFertilizer25);
        list.add(FarmingTriggers.lowGermlings25);
        list.add(FarmingTriggers.lowGermlings10);
        return list;
    }
}

