/*
 * Decompiled with CFR 0.152.
 */
package forestry.farming.gadgets;

import forestry.api.circuits.ChipsetManager;
import forestry.api.circuits.ICircuitBoard;
import forestry.api.core.BiomeHelper;
import forestry.api.core.EnumHumidity;
import forestry.api.core.EnumTemperature;
import forestry.api.farming.ICrop;
import forestry.api.farming.IFarmComponent;
import forestry.api.farming.IFarmHousing;
import forestry.api.farming.IFarmListener;
import forestry.api.farming.IFarmLogic;
import forestry.api.farming.IFarmable;
import forestry.core.EnumErrorCode;
import forestry.core.GameMode;
import forestry.core.config.Config;
import forestry.core.fluids.FluidHelper;
import forestry.core.fluids.Fluids;
import forestry.core.fluids.TankManager;
import forestry.core.fluids.tanks.FilteredTank;
import forestry.core.interfaces.IClimatised;
import forestry.core.interfaces.IHintSource;
import forestry.core.interfaces.ISocketable;
import forestry.core.inventory.IInventoryAdapter;
import forestry.core.inventory.InvTools;
import forestry.core.inventory.InventoryAdapter;
import forestry.core.inventory.TileInventoryAdapter;
import forestry.core.proxy.Proxies;
import forestry.core.utils.DelayTimer;
import forestry.core.utils.GuiUtil;
import forestry.core.utils.StackUtils;
import forestry.core.utils.Utils;
import forestry.core.vect.Vect;
import forestry.farming.FarmTarget;
import forestry.farming.gadgets.StructureLogicFarm;
import forestry.farming.gadgets.TileFarm;
import forestry.farming.logic.FarmLogicArboreal;
import forestry.plugins.PluginFarming;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import java.util.TreeMap;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.ICrafting;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;

public class TileFarmPlain
extends TileFarm
implements IFarmHousing,
ISocketable,
IClimatised,
IHintSource {
    public static final int SLOT_RESOURCES_1 = 0;
    public static final int SLOT_RESOURCES_COUNT = 6;
    public static final int SLOT_GERMLINGS_1 = 6;
    public static final int SLOT_GERMLINGS_COUNT = 6;
    public static final int SLOT_PRODUCTION_1 = 12;
    public static final int SLOT_PRODUCTION_COUNT = 8;
    public static final int SLOT_FERTILIZER = 20;
    public static final int SLOT_FERTILIZER_COUNT = 1;
    public static final int SLOT_CAN = 21;
    public static final int SLOT_CAN_COUNT = 1;
    public static final int SLOT_COUNT = 22;
    private static final int DELAY_HYDRATION = 100;
    private static final float RAINFALL_MODIFIER_CAP = 15.0f;
    private static final int BUFFER_FERTILIZER = 200;
    private IFarmLogic[] farmLogics = new IFarmLogic[4];
    private TreeMap<ForgeDirection, FarmTarget[]> targets;
    private int allowedExtent = 0;
    private final DelayTimer checkTimer = new DelayTimer();
    private final InventoryAdapter sockets = new InventoryAdapter(1, "sockets");
    private TankManager tankManager;
    private IFarmLogic harvestProvider;
    private final Stack<ICrop> pendingCrops = new Stack();
    private final Stack<ItemStack> pendingProduce = new Stack();
    private int storedFertilizer;
    private int fertilizerValue = 2000;
    private boolean stage = false;
    private BiomeGenBase biome;
    private int hydrationDelay = 0;
    private int ticksSinceRainfall = 0;
    private final Set<IFarmListener> eventHandlers = new LinkedHashSet<IFarmListener>();
    private int[] coords;
    private int[] offset;
    private int[] area;

    public TileFarmPlain() {
        this.fertilizerValue = GameMode.getGameMode().getIntegerSetting("farms.fertilizer.value");
    }

    @Override
    public void func_145829_t() {
        super.func_145829_t();
        this.setBiomeInformation();
    }

    @Override
    public void func_145839_a(NBTTagCompound nbttagcompound) {
        super.func_145839_a(nbttagcompound);
        this.storedFertilizer = nbttagcompound.func_74762_e("StoredFertilizer");
        this.hydrationDelay = nbttagcompound.func_74762_e("HydrationDelay");
        this.ticksSinceRainfall = nbttagcompound.func_74762_e("TicksSinceRainfall");
        this.sockets.readFromNBT(nbttagcompound);
        this.refreshFarmLogics();
        if (this.tankManager != null) {
            this.tankManager.readTanksFromNBT(nbttagcompound);
        }
    }

    @Override
    public void func_145841_b(NBTTagCompound nbttagcompound) {
        super.func_145841_b(nbttagcompound);
        this.sockets.writeToNBT(nbttagcompound);
        nbttagcompound.func_74768_a("StoredFertilizer", this.storedFertilizer);
        nbttagcompound.func_74768_a("HydrationDelay", this.hydrationDelay);
        nbttagcompound.func_74768_a("TicksSinceRainfall", this.ticksSinceRainfall);
        if (this.tankManager != null) {
            this.tankManager.writeTanksToNBT(nbttagcompound);
        }
    }

    @Override
    protected void updateServerSide() {
        super.updateServerSide();
        if (!this.isMaster()) {
            return;
        }
        if (this.field_145850_b.func_72896_J()) {
            if (this.hydrationDelay > 0) {
                --this.hydrationDelay;
            } else {
                this.ticksSinceRainfall = 0;
            }
        } else {
            this.hydrationDelay = 100;
            if (this.ticksSinceRainfall < Integer.MAX_VALUE) {
                ++this.ticksSinceRainfall;
            }
        }
        if (this.field_145850_b.func_82737_E() % 20L * 10L != 0L) {
            return;
        }
        if (this.getInternalInventory().func_70301_a(21) != null) {
            FluidHelper.drainContainers(this.tankManager, (IInventory)this.getInternalInventory(), 21);
        }
    }

    private void setBiomeInformation() {
        this.biome = Utils.getBiomeAt(this.field_145850_b, this.field_145851_c, this.field_145849_e);
        this.setErrorState(EnumErrorCode.OK);
    }

    private void createTargets() {
        this.targets = new TreeMap();
        int groundY = this.field_145848_d - 1;
        this.allowedExtent = 0;
        for (ForgeDirection direction : ForgeDirection.VALID_DIRECTIONS) {
            TileEntity tile;
            TileEntity tile2;
            if (direction == ForgeDirection.UP || direction == ForgeDirection.DOWN) continue;
            ArrayList<FarmTarget> potential = new ArrayList<FarmTarget>();
            int xDistance = 0;
            int zDistance = 0;
            Vect candidate = new Vect(this.field_145851_c, groundY, this.field_145849_e);
            while ((tile2 = this.field_145850_b.func_147438_o(this.field_145851_c + (xDistance += direction.offsetX), groundY, this.field_145849_e + (zDistance += direction.offsetZ))) != null && tile2 instanceof IFarmComponent) {
                candidate = new Vect(this.field_145851_c + xDistance, groundY, this.field_145849_e + zDistance);
            }
            ForgeDirection search = direction.offsetX != 0 ? ForgeDirection.SOUTH : ForgeDirection.EAST;
            int xOffset = 0;
            int zOffset = 0;
            Vect start = candidate;
            while ((tile = this.field_145850_b.func_147438_o(candidate.x + (xOffset += search.offsetX), candidate.y, candidate.z + (zOffset += search.offsetZ))) != null && tile instanceof IFarmComponent) {
                start = new Vect(candidate.x + xOffset, candidate.y, candidate.z + zOffset);
            }
            ForgeDirection reverse = search.getOpposite();
            ForgeDirection tocenter = direction.getOpposite();
            Vect last = new Vect(start.x + direction.offsetX, start.y, start.z + direction.offsetZ);
            potential.add(new FarmTarget(last));
            while (true) {
                last = new Vect(last.x + reverse.offsetX, last.y, last.z + reverse.offsetZ);
                TileEntity tile3 = this.field_145850_b.func_147438_o(last.x + tocenter.offsetX, last.y, last.z + tocenter.offsetZ);
                if (tile3 == null || !(tile3 instanceof IFarmComponent)) break;
                potential.add(new FarmTarget(last));
            }
            int size = potential.size() * 3;
            if (size > this.allowedExtent) {
                this.allowedExtent = size;
            }
            this.targets.put(direction, potential.toArray(new FarmTarget[potential.size()]));
        }
        TreeMap<ForgeDirection, FarmTarget[]> cache = new TreeMap<ForgeDirection, FarmTarget[]>();
        for (Map.Entry<ForgeDirection, FarmTarget[]> entry : this.targets.entrySet()) {
            int i;
            ForgeDirection direction;
            direction = entry.getKey();
            if (direction == ForgeDirection.SOUTH || direction == ForgeDirection.NORTH) {
                cache.put(entry.getKey(), entry.getValue());
                continue;
            }
            ArrayList<Object> targ = new ArrayList<Object>(Arrays.asList((Object[])entry.getValue()));
            int sidecount = targ.size();
            FarmTarget start = entry.getValue()[0];
            ForgeDirection search = ForgeDirection.SOUTH;
            int cornerShift = 0;
            if (!Config.squareFarms) {
                cornerShift = 1;
            }
            for (i = cornerShift; i < this.allowedExtent + 1; ++i) {
                FarmTarget corner = new FarmTarget(new Vect(start.getStart().x + search.offsetX * i, start.getStart().y, start.getStart().z + search.offsetZ * i));
                if (!Config.squareFarms) {
                    corner.setLimit(this.allowedExtent - i);
                    if (corner.getLimit() <= 0) continue;
                    targ.add(0, corner);
                    continue;
                }
                targ.add(0, corner);
            }
            search = search.getOpposite();
            for (i = sidecount; i < sidecount + this.allowedExtent - cornerShift; ++i) {
                FarmTarget corner = new FarmTarget(new Vect(start.getStart().x + search.offsetX * i, start.getStart().y, start.getStart().z + search.offsetZ * i));
                if (!Config.squareFarms) {
                    corner.setLimit(sidecount + this.allowedExtent - 1 - i);
                }
                targ.add(corner);
            }
            cache.put(entry.getKey(), targ.toArray(new FarmTarget[targ.size()]));
        }
        this.targets = cache;
    }

    private void setExtents() {
        for (Map.Entry<ForgeDirection, FarmTarget[]> entry : this.targets.entrySet()) {
            ForgeDirection direction = entry.getKey();
            for (FarmTarget target : entry.getValue()) {
                int extent;
                int yOffset;
                for (yOffset = 2; yOffset > -3; --yOffset) {
                    Vect position = new Vect(target.getStart().x, target.getStart().y + yOffset, target.getStart().z);
                    if (StructureLogicFarm.bricks.contains(this.field_145850_b.func_147439_a(position.x, position.y, position.z))) break;
                }
                target.setYOffset(yOffset + 1);
                int limit = this.allowedExtent;
                if (target.getLimit() > 0) {
                    limit = target.getLimit();
                }
                for (extent = 0; extent < limit; ++extent) {
                    Vect position = new Vect(target.getStart().x + direction.offsetX * extent, target.getStart().y + yOffset, target.getStart().z + direction.offsetZ * extent);
                    if (!StructureLogicFarm.bricks.contains(this.field_145850_b.func_147439_a(position.x, position.y, position.z))) break;
                }
                target.setExtent(extent);
            }
        }
    }

    protected void createInventory() {
        this.setInternalInventory(new TileInventoryAdapter(this, 22, "Items"){

            @Override
            public boolean canSlotAccept(int slotIndex, ItemStack itemStack) {
                if (GuiUtil.isIndexInRange(slotIndex, 20, 1)) {
                    return TileFarmPlain.this.acceptsAsFertilizer(itemStack);
                }
                if (GuiUtil.isIndexInRange(slotIndex, 6, 6)) {
                    return TileFarmPlain.this.acceptsAsGermling(itemStack);
                }
                if (GuiUtil.isIndexInRange(slotIndex, 0, 6)) {
                    return TileFarmPlain.this.acceptsAsResource(itemStack);
                }
                if (GuiUtil.isIndexInRange(slotIndex, 21, 1)) {
                    Fluid fluid = FluidHelper.getFluidInContainer(itemStack);
                    return TileFarmPlain.this.tankManager.accepts(fluid);
                }
                return false;
            }

            @Override
            public boolean func_102008_b(int slotIndex, ItemStack stack, int side) {
                return GuiUtil.isIndexInRange(slotIndex, 12, 8);
            }
        });
        FilteredTank liquidTank = new FilteredTank(10000, FluidRegistry.WATER);
        this.tankManager = new TankManager(liquidTank);
    }

    @Override
    public boolean doWork() {
        if (this.targets == null) {
            this.createTargets();
            this.setExtents();
        } else if (this.checkTimer.delayPassed(this.field_145850_b, 400L)) {
            this.setExtents();
        }
        if (this.tryAddPending()) {
            return true;
        }
        if (!this.pendingProduce.isEmpty()) {
            this.setErrorState(EnumErrorCode.NOSPACE);
            return false;
        }
        if (this.storedFertilizer <= 200) {
            this.replenishFertilizer();
            if (this.storedFertilizer <= 0) {
                this.setErrorState(EnumErrorCode.NOFERTILIZER);
                return false;
            }
        }
        if (!this.pendingCrops.isEmpty()) {
            if (this.cullCrop(this.pendingCrops.peek(), this.harvestProvider)) {
                this.pendingCrops.pop();
                return true;
            }
            return false;
        }
        boolean consumedEnergy = false;
        boolean hasFarmland = false;
        boolean hasFertilizer = false;
        boolean hasLiquid = false;
        block0: for (Map.Entry<ForgeDirection, FarmTarget[]> entry : this.targets.entrySet()) {
            if (this.farmLogics.length <= entry.getKey().ordinal() - 2 || this.farmLogics[entry.getKey().ordinal() - 2] == null) continue;
            boolean didWork = false;
            IFarmLogic logic = this.farmLogics[entry.getKey().ordinal() - 2];
            for (IFarmListener listener : this.eventHandlers) {
                if (!listener.cancelTask(logic, entry.getKey())) continue;
                continue block0;
            }
            if (this.doCollection(logic)) {
                didWork = true;
            } else {
                for (int i = 0; i < entry.getValue().length; ++i) {
                    FarmTarget target = entry.getValue()[i];
                    if (target.getExtent() <= 0) continue;
                    hasFarmland = true;
                    if (!this.stage) {
                        if (!this.hasFertilizer(logic.getFertilizerConsumption())) continue;
                        hasFertilizer = true;
                        FluidStack liquid = Fluids.WATER.getFluid(logic.getWaterConsumption(this.getHydrationModifier()));
                        if (liquid.amount > 0 && !this.hasLiquid(liquid)) continue;
                        hasLiquid = true;
                        if (this.doCultivationPhase(logic, target, entry.getKey())) {
                            this.removeFertilizer(logic.getFertilizerConsumption());
                            this.removeLiquid(liquid);
                            didWork = true;
                        }
                    } else {
                        hasFertilizer = true;
                        hasLiquid = true;
                        didWork = this.doHarvestPhase(logic, target, entry.getKey());
                    }
                    if (didWork) break;
                }
            }
            if (!didWork) continue;
            consumedEnergy = true;
            break;
        }
        if (consumedEnergy) {
            this.setErrorState(EnumErrorCode.OK);
        } else if (!hasFarmland) {
            this.setErrorState(EnumErrorCode.NOFARMLAND);
        } else if (!hasFertilizer) {
            this.setErrorState(EnumErrorCode.NOFERTILIZER);
        } else if (!hasLiquid) {
            this.setErrorState(EnumErrorCode.NOLIQUID);
        } else {
            this.setErrorState(EnumErrorCode.OK);
        }
        this.stage = !this.stage;
        return consumedEnergy;
    }

    private boolean doCultivationPhase(IFarmLogic logic, FarmTarget target, ForgeDirection direction) {
        if (logic.cultivate(target.getStart().x, target.getStart().y + target.getYOffset(), target.getStart().z, direction, target.getExtent())) {
            for (IFarmListener listener : this.eventHandlers) {
                listener.hasCultivated(logic, target.getStart().x, target.getStart().y, target.getStart().z, direction, target.getExtent());
            }
            return true;
        }
        return false;
    }

    private boolean doHarvestPhase(IFarmLogic logic, FarmTarget target, ForgeDirection direction) {
        Collection<ICrop> next = logic.harvest(target.getStart().x, target.getStart().y + target.getYOffset(), target.getStart().z, direction, target.getExtent());
        if (next == null || next.size() <= 0) {
            return false;
        }
        for (IFarmListener listener : this.eventHandlers) {
            listener.hasScheduledHarvest(next, logic, target.getStart().x, target.getStart().y + target.getYOffset(), target.getStart().z, direction, target.getExtent());
        }
        this.pendingCrops.addAll(next);
        this.harvestProvider = logic;
        return true;
    }

    private boolean doCollection(IFarmLogic logic) {
        Collection<ItemStack> collected = logic.collect();
        if (collected == null || collected.size() <= 0) {
            return false;
        }
        for (IFarmListener listener : this.eventHandlers) {
            listener.hasCollected(collected, logic);
        }
        for (ItemStack produce : collected) {
            this.addProduceToInventory(produce);
            this.pendingProduce.push(produce);
        }
        return true;
    }

    private void addProduceToInventory(ItemStack produce) {
        IInventoryAdapter inventory = this.getInternalInventory();
        for (IFarmLogic logic : this.getFarmLogics()) {
            if (logic.isAcceptedGermling(produce)) {
                produce.field_77994_a -= InvTools.addStack((IInventory)inventory, produce, 6, 6, false, true);
            }
            if (produce.field_77994_a <= 0) {
                return;
            }
            if (logic.isAcceptedResource(produce)) {
                produce.field_77994_a -= InvTools.addStack((IInventory)inventory, produce, 0, 6, false, true);
            }
            if (produce.field_77994_a > 0) continue;
            return;
        }
        produce.field_77994_a -= InvTools.addStack((IInventory)inventory, produce, 12, 8, false, true);
    }

    private boolean cullCrop(ICrop crop, IFarmLogic provider) {
        for (IFarmListener listener : this.eventHandlers) {
            if (!listener.beforeCropHarvest(crop)) continue;
            return true;
        }
        if (!this.hasFertilizer(provider.getFertilizerConsumption())) {
            this.setErrorState(EnumErrorCode.NOFERTILIZER);
            return false;
        }
        FluidStack liquid = Fluids.WATER.getFluid(provider.getWaterConsumption(this.getHydrationModifier()));
        if (liquid.amount > 0 && !this.hasLiquid(liquid)) {
            this.setErrorState(EnumErrorCode.NOLIQUID);
            return false;
        }
        Collection<ItemStack> harvested = crop.harvest();
        if (harvested == null) {
            Proxies.log.fine("Failed to harvest crop: " + crop.toString());
            return true;
        }
        this.removeFertilizer(provider.getFertilizerConsumption());
        this.removeLiquid(liquid);
        for (IFarmListener listener : this.eventHandlers) {
            listener.afterCropHarvest(harvested, crop);
        }
        IInventoryAdapter inventory = this.getInternalInventory();
        for (ItemStack harvest : harvested) {
            for (IFarmLogic logic : this.farmLogics) {
                if (!logic.isAcceptedGermling(harvest)) continue;
                harvest.field_77994_a -= InvTools.addStack((IInventory)inventory, harvest, 6, 6, false, true);
                break;
            }
            if (harvest.field_77994_a <= 0) continue;
            harvest.field_77994_a -= InvTools.addStack((IInventory)inventory, harvest, 12, 8, false, true);
            if (harvest.field_77994_a <= 0) continue;
            this.pendingProduce.push(harvest);
        }
        return true;
    }

    private boolean tryAddPending() {
        if (this.pendingProduce.isEmpty()) {
            return false;
        }
        ItemStack next = this.pendingProduce.peek();
        if (InvTools.tryAddStack((IInventory)this.getInternalInventory(), next, 12, 8, true, true)) {
            this.pendingProduce.pop();
            return true;
        }
        this.setErrorState(EnumErrorCode.NOSPACE);
        return false;
    }

    private void replenishFertilizer() {
        if (this.fertilizerValue < 0) {
            this.storedFertilizer += 2000;
            return;
        }
        IInventoryAdapter inventory = this.getInternalInventory();
        ItemStack fertilizer = inventory.func_70301_a(20);
        if (fertilizer == null || fertilizer.field_77994_a <= 0) {
            return;
        }
        if (!this.acceptsAsFertilizer(fertilizer)) {
            return;
        }
        inventory.func_70298_a(20, 1);
        this.storedFertilizer += this.fertilizerValue;
    }

    private boolean hasFertilizer(int amount) {
        if (this.fertilizerValue < 0) {
            return true;
        }
        return this.storedFertilizer >= amount;
    }

    private void removeFertilizer(int amount) {
        if (this.fertilizerValue < 0) {
            return;
        }
        this.storedFertilizer -= amount;
        if (this.storedFertilizer < 0) {
            this.storedFertilizer = 0;
        }
    }

    public int getStoredFertilizerScaled(int scale) {
        if (this.storedFertilizer == 0) {
            return 0;
        }
        return this.storedFertilizer * scale / (this.fertilizerValue + 200);
    }

    @Override
    public void makeMaster() {
        super.makeMaster();
        this.refreshFarmLogics();
        this.createInventory();
    }

    public TankManager getTankManager() {
        return this.tankManager;
    }

    @Override
    public void setFarmLogic(ForgeDirection direction, IFarmLogic logic) {
        this.farmLogics[direction.ordinal() - 2] = logic;
    }

    @Override
    public void resetFarmLogic(ForgeDirection direction) {
        this.farmLogics[direction.ordinal() - 2] = new FarmLogicArboreal(this);
    }

    public IFarmLogic[] getFarmLogics() {
        return this.farmLogics;
    }

    private void refreshFarmLogics() {
        ICircuitBoard chipset;
        this.farmLogics = new IFarmLogic[]{new FarmLogicArboreal(this), new FarmLogicArboreal(this), new FarmLogicArboreal(this), new FarmLogicArboreal(this)};
        ItemStack chip = this.sockets.func_70301_a(0);
        if (chip != null && (chipset = ChipsetManager.circuitRegistry.getCircuitboard(chip)) != null) {
            chipset.onLoad(this);
        }
    }

    @Override
    public int getSocketCount() {
        return this.sockets.func_70302_i_();
    }

    @Override
    public ItemStack getSocket(int slot) {
        return this.sockets.func_70301_a(slot);
    }

    @Override
    public void setSocket(int slot, ItemStack stack) {
        ICircuitBoard chipset;
        if (stack != null && !ChipsetManager.circuitRegistry.isChipset(stack)) {
            return;
        }
        if (this.sockets.func_70301_a(slot) != null && ChipsetManager.circuitRegistry.isChipset(this.sockets.func_70301_a(slot)) && (chipset = ChipsetManager.circuitRegistry.getCircuitboard(this.sockets.func_70301_a(slot))) != null) {
            chipset.onRemoval(this);
        }
        this.sockets.func_70299_a(slot, stack);
        this.refreshFarmLogics();
        if (stack == null) {
            return;
        }
        chipset = ChipsetManager.circuitRegistry.getCircuitboard(stack);
        if (chipset != null) {
            chipset.onInsertion(this);
        }
    }

    @Override
    public World getWorld() {
        return this.field_145850_b;
    }

    @Override
    public boolean hasResources(ItemStack[] resources) {
        return InvTools.contains((IInventory)this.getInternalInventory(), resources, 0, 6);
    }

    public boolean hasResourcesAmount(int amount) {
        return InvTools.containsAmount((IInventory)this.getInternalInventory(), amount, 0, 6);
    }

    public boolean hasGermlingsPercent(float percent) {
        return InvTools.containsPercent((IInventory)this.getInternalInventory(), percent, 6, 6);
    }

    public boolean hasFertilizerPercent(float percent) {
        return InvTools.containsPercent((IInventory)this.getInternalInventory(), percent, 20, 1);
    }

    @Override
    public void removeResources(ItemStack[] resources) {
        EntityPlayer player = Proxies.common.getPlayer(this.field_145850_b, this.getOwnerProfile());
        InvTools.removeSets((IInventory)this.getInternalInventory(), 1, resources, 0, 6, player, false, true, true);
    }

    @Override
    public boolean hasLiquid(FluidStack liquid) {
        return this.tankManager.get(0).getFluidAmount() >= liquid.amount;
    }

    @Override
    public void removeLiquid(FluidStack liquid) {
        this.tankManager.drain(liquid, true);
    }

    public boolean hasGermlings(ItemStack[] germlings) {
        return InvTools.contains((IInventory)this.getInternalInventory(), germlings, 6, 6);
    }

    @Override
    public boolean plantGermling(IFarmable germling, World world, int x, int y, int z) {
        IInventoryAdapter inventory = this.getInternalInventory();
        for (int i = 6; i < 12; ++i) {
            EntityPlayer player;
            if (inventory.func_70301_a(i) == null || !germling.isGermling(inventory.func_70301_a(i)) || !germling.plantSaplingAt(player = Proxies.common.getPlayer(world, this.getOwnerProfile()), inventory.func_70301_a(i), world, x, y, z)) continue;
            inventory.func_70298_a(i, 1);
            return true;
        }
        return false;
    }

    @Override
    public boolean hasFunction() {
        return false;
    }

    @Override
    public void registerListener(IFarmListener listener) {
        this.eventHandlers.add(listener);
    }

    @Override
    public void removeListener(IFarmListener listener) {
        this.eventHandlers.remove(listener);
    }

    @Override
    public boolean acceptsAsGermling(ItemStack itemstack) {
        if (itemstack == null) {
            return false;
        }
        if (this.farmLogics == null) {
            return false;
        }
        for (IFarmLogic logic : this.farmLogics) {
            if (!logic.isAcceptedGermling(itemstack)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean acceptsAsResource(ItemStack itemstack) {
        if (itemstack == null) {
            return false;
        }
        if (this.farmLogics == null) {
            return false;
        }
        for (IFarmLogic logic : this.farmLogics) {
            if (!logic.isAcceptedResource(itemstack)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean acceptsAsFertilizer(ItemStack itemstack) {
        if (itemstack == null) {
            return false;
        }
        return StackUtils.isIdenticalItem(PluginFarming.farmFertilizer, itemstack);
    }

    @Override
    public int[] getCoords() {
        if (this.coords == null) {
            this.coords = new int[]{this.field_145851_c, this.field_145848_d, this.field_145849_e};
        }
        return this.coords;
    }

    @Override
    public int[] getOffset() {
        if (this.offset == null) {
            this.offset = new int[]{-this.getArea()[0] / 2, -2, -this.getArea()[2] / 2};
        }
        return this.offset;
    }

    @Override
    public int[] getArea() {
        if (this.area == null) {
            this.area = new int[]{7 + this.allowedExtent * 2, 13, 7 + this.allowedExtent * 2};
        }
        return this.area;
    }

    public void getGUINetworkData(int i, int j) {
        if (this.tankManager != null) {
            i -= this.tankManager.maxMessageId() + 1;
        }
        switch (i) {
            case 0: {
                this.storedFertilizer = j;
                break;
            }
            case 5: {
                this.ticksSinceRainfall = j;
            }
        }
    }

    public void sendGUINetworkData(Container container, ICrafting iCrafting) {
        int i = this.tankManager.maxMessageId() + 1;
        iCrafting.func_71112_a(container, i, this.storedFertilizer);
        iCrafting.func_71112_a(container, i + 5, this.ticksSinceRainfall);
    }

    public float getHydrationModifier() {
        return this.getHydrationTempModifier() * this.getHydrationHumidModifier() * this.getHydrationRainfallModifier();
    }

    public float getHydrationTempModifier() {
        float temperature = this.getExactTemperature();
        return temperature > 0.8f ? temperature : 0.8f;
    }

    public float getHydrationHumidModifier() {
        float mod = 1.0f / this.getExactHumidity();
        return mod < 2.0f ? mod : 2.0f;
    }

    public float getHydrationRainfallModifier() {
        float mod = (float)this.ticksSinceRainfall / 24000.0f;
        return mod > 0.5f ? (mod < 15.0f ? mod : 15.0f) : 0.5f;
    }

    public double getDrought() {
        return (double)Math.round((double)this.ticksSinceRainfall / 24000.0 * 10.0) / 10.0;
    }

    @Override
    public boolean isClimatized() {
        return true;
    }

    @Override
    public EnumTemperature getTemperature() {
        if (BiomeHelper.isBiomeHellish(this.biome)) {
            return EnumTemperature.HELLISH;
        }
        return EnumTemperature.getFromValue(this.getExactTemperature());
    }

    @Override
    public EnumHumidity getHumidity() {
        return EnumHumidity.getFromValue(this.getExactHumidity());
    }

    @Override
    public float getExactTemperature() {
        return this.biome.field_76750_F;
    }

    @Override
    public float getExactHumidity() {
        return this.biome.field_76751_G;
    }

    @Override
    public boolean hasHints() {
        return Config.hints.get("farm").length > 0;
    }

    @Override
    public String[] getHints() {
        return Config.hints.get("farm");
    }

    @Override
    public boolean isOwnable() {
        return true;
    }
}

