/*
 * Decompiled with CFR 0.152.
 */
package forestry.farming.gadgets;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import forestry.api.core.ForestryAPI;
import forestry.api.core.IStructureLogic;
import forestry.api.core.ITileStructure;
import forestry.api.farming.Farmables;
import forestry.api.farming.IFarmComponent;
import forestry.api.farming.IFarmListener;
import forestry.core.gadgets.TileForestry;
import forestry.core.inventory.IInventoryAdapter;
import forestry.core.network.GuiId;
import forestry.core.network.PacketPayload;
import forestry.core.proxy.Proxies;
import forestry.farming.gadgets.EnumFarmBlock;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IIcon;

public abstract class TileFarm
extends TileForestry
implements IFarmComponent {
    public static final int TYPE_PLAIN = 0;
    public static final int TYPE_REVERSE = 1;
    public static final int TYPE_TOP = 2;
    public static final int TYPE_BAND = 3;
    public static final int TYPE_GEARS = 4;
    public static final int TYPE_HATCH = 5;
    public static final int TYPE_VALVE = 6;
    public static final int TYPE_CONTROL = 7;
    EnumFarmBlock farmBlock = EnumFarmBlock.BRICK_STONE;
    protected int fixedType = -1;
    private final IStructureLogic structureLogic = Farmables.farmInterface.createFarmStructureLogic(this);
    private boolean isMaster;
    private int masterX;
    private int masterZ;
    private int masterY = -99;

    @Override
    public void openGui(EntityPlayer player) {
        if (this.isMaster()) {
            player.openGui(ForestryAPI.instance, GuiId.MultiFarmGUI.ordinal(), this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e);
        } else if (this.hasMaster()) {
            player.openGui(ForestryAPI.instance, GuiId.MultiFarmGUI.ordinal(), this.field_145850_b, this.masterX, this.masterY, this.masterZ);
        }
    }

    @Override
    public void func_145839_a(NBTTagCompound nbttagcompound) {
        this.isMaster = nbttagcompound.func_74767_n("IsMaster");
        this.masterX = nbttagcompound.func_74762_e("MasterX");
        this.masterY = nbttagcompound.func_74762_e("MasterY");
        this.masterZ = nbttagcompound.func_74762_e("MasterZ");
        this.farmBlock = EnumFarmBlock.getFromCompound(nbttagcompound);
        if (this.isMaster) {
            this.makeMaster();
        }
        this.structureLogic.readFromNBT(nbttagcompound);
        super.func_145839_a(nbttagcompound);
    }

    @Override
    public void func_145841_b(NBTTagCompound nbttagcompound) {
        super.func_145841_b(nbttagcompound);
        nbttagcompound.func_74757_a("IsMaster", this.isMaster);
        nbttagcompound.func_74768_a("MasterX", this.masterX);
        nbttagcompound.func_74768_a("MasterY", this.masterY);
        nbttagcompound.func_74768_a("MasterZ", this.masterZ);
        this.farmBlock.saveToCompound(nbttagcompound);
        this.structureLogic.writeToNBT(nbttagcompound);
    }

    @Override
    public void initialize() {
    }

    @Override
    public void func_145845_h() {
        if (!Proxies.common.isSimulating(this.field_145850_b)) {
            this.updateClientSide();
        } else {
            if (!this.isInited) {
                this.initialize();
                this.isInited = true;
            }
            if (this.field_145850_b.func_82737_E() % 200L == 0L && (!this.isIntegratedIntoStructure() || this.isMaster())) {
                this.validateStructure();
            }
            this.updateServerSide();
        }
    }

    protected void updateServerSide() {
    }

    protected void updateClientSide() {
    }

    public void setFarmBlock(EnumFarmBlock block) {
        this.farmBlock = block;
        this.sendNetworkUpdate();
    }

    public EnumFarmBlock getFarmBlock() {
        return this.farmBlock;
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon getIcon(int side, int meta) {
        return null;
    }

    @Override
    public PacketPayload getPacketPayload() {
        PacketPayload payload = new PacketPayload(0, 3);
        payload.shortPayload[0] = (short)this.farmBlock.ordinal();
        payload.shortPayload[1] = (short)(this.isMaster() ? 1 : 0);
        payload.shortPayload[2] = (short)this.masterY;
        return payload;
    }

    @Override
    public void fromPacketPayload(PacketPayload payload) {
        EnumFarmBlock farmType = EnumFarmBlock.values()[payload.shortPayload[0]];
        if (payload.shortPayload[1] > 0) {
            this.makeMaster();
        }
        this.masterY = payload.shortPayload[2];
        if (this.farmBlock != farmType) {
            this.farmBlock = farmType;
            this.field_145850_b.func_147479_m(this.field_145851_c, this.field_145848_d, this.field_145849_e);
        }
    }

    @Override
    public String getTypeUID() {
        return this.structureLogic.getTypeUID();
    }

    @Override
    public void validateStructure() {
        this.structureLogic.validateStructure();
    }

    @Override
    public void makeMaster() {
        this.setCentralTE(null);
        this.isMaster = true;
        if (this.field_145850_b != null && !this.field_145850_b.field_72995_K) {
            this.sendNetworkUpdate();
        }
    }

    @Override
    public void onStructureReset() {
        this.setCentralTE(null);
        if (this.field_145850_b.func_72805_g(this.field_145851_c, this.field_145848_d, this.field_145849_e) == 1) {
            this.field_145850_b.func_72921_c(this.field_145851_c, this.field_145848_d, this.field_145849_e, 0, 0);
        }
        this.isMaster = false;
        this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
    }

    @Override
    public ITileStructure getCentralTE() {
        ITileStructure master;
        if (!this.isIntegratedIntoStructure()) {
            return null;
        }
        if (this.isMaster) {
            return this;
        }
        TileEntity tile = this.field_145850_b.func_147438_o(this.masterX, this.masterY, this.masterZ);
        if (tile instanceof ITileStructure && (master = (ITileStructure)tile).isMaster()) {
            return master;
        }
        return null;
    }

    private boolean isSameTile(TileEntity tile) {
        return tile.field_145851_c == this.field_145851_c && tile.field_145848_d == this.field_145848_d && tile.field_145849_e == this.field_145849_e;
    }

    @Override
    public void setCentralTE(TileEntity tile) {
        if (tile == null || tile == this || this.isSameTile(tile)) {
            this.masterZ = 0;
            this.masterX = 0;
            this.masterY = -99;
            return;
        }
        this.isMaster = false;
        this.masterX = tile.field_145851_c;
        this.masterY = tile.field_145848_d;
        this.masterZ = tile.field_145849_e;
        this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
    }

    @Override
    public boolean isMaster() {
        return this.isMaster;
    }

    protected boolean hasMaster() {
        return this.masterY >= 0;
    }

    @Override
    public final IInventory getInventory() {
        return this.getStructureInventory();
    }

    @Override
    public IInventoryAdapter getStructureInventory() {
        return this.getInternalInventory();
    }

    @Override
    public boolean isIntegratedIntoStructure() {
        return this.isMaster || this.masterY >= 0;
    }

    @Override
    public void registerListener(IFarmListener listener) {
    }

    @Override
    public void removeListener(IFarmListener listener) {
    }
}

