/*
 * Decompiled with CFR 0.152.
 */
package forestry.farming.circuits;

import forestry.api.farming.IFarmHousing;
import forestry.api.farming.IFarmLogic;
import forestry.core.circuits.Circuit;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.util.ForgeDirection;

public class CircuitFarmLogic
extends Circuit {
    private final Class<? extends IFarmLogic> logicClass;
    private boolean isManual = false;

    public CircuitFarmLogic(String uid, Class<? extends IFarmLogic> logicClass) {
        super(uid, false);
        this.logicClass = logicClass;
        this.setLimit(4);
    }

    public CircuitFarmLogic setManual() {
        this.isManual = true;
        return this;
    }

    @Override
    public boolean isCircuitable(TileEntity tile) {
        return tile instanceof IFarmHousing;
    }

    IFarmHousing getCircuitable(TileEntity tile) {
        if (!this.isCircuitable(tile)) {
            return null;
        }
        return (IFarmHousing)tile;
    }

    @Override
    public void onInsertion(int slot, TileEntity tile) {
        IFarmLogic logic;
        IFarmHousing housing = this.getCircuitable(tile);
        if (housing == null) {
            return;
        }
        try {
            logic = this.logicClass.getConstructor(IFarmHousing.class).newInstance(housing);
        }
        catch (Exception ex) {
            throw new RuntimeException("Failed to instantiate logic of class " + this.logicClass.getName() + ": " + ex.getMessage());
        }
        try {
            logic.setManual(this.isManual);
        }
        catch (Throwable e) {
            // empty catch block
        }
        housing.setFarmLogic(ForgeDirection.values()[slot + 2], logic);
    }

    @Override
    public void onLoad(int slot, TileEntity tile) {
        this.onInsertion(slot, tile);
    }

    @Override
    public void onRemoval(int slot, TileEntity tile) {
        if (!this.isCircuitable(tile)) {
            return;
        }
        ((IFarmHousing)tile).resetFarmLogic(ForgeDirection.values()[slot + 2]);
    }

    @Override
    public void onTick(int slot, TileEntity tile) {
    }
}

