/*
 * Decompiled with CFR 0.152.
 */
package forestry.factory.recipes;

import forestry.api.core.INBTTagable;
import forestry.core.gui.ContainerDummy;
import forestry.core.inventory.InventoryAdapter;
import forestry.core.utils.PlainInventory;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.Item;
import net.minecraft.item.ItemMap;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.CraftingManager;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.world.World;

public class RecipeMemory
implements INBTTagable {
    private static final Container DUMMY_CONTAINER = new ContainerDummy();
    private static final List<Class<? extends Item>> memoryBlacklist = new ArrayList<Class<? extends Item>>();
    private LinkedList<Recipe> recipes = new LinkedList();
    private long lastUpdate;
    public final int capacity = 9;

    private static boolean isValid(World world, Recipe recipe) {
        if (recipe == null) {
            return false;
        }
        ItemStack recipeOutput = recipe.getRecipeOutput(world);
        if (recipeOutput == null) {
            return false;
        }
        Item item = recipeOutput.func_77973_b();
        return item != null && !memoryBlacklist.contains(item.getClass());
    }

    public void validate(World world) {
        LinkedList<Recipe> validRecipes = new LinkedList<Recipe>();
        for (Recipe recipe : this.recipes) {
            if (!RecipeMemory.isValid(world, recipe)) continue;
            validRecipes.add(recipe);
        }
        this.recipes = validRecipes;
    }

    public long getLastUpdate() {
        return this.lastUpdate;
    }

    public void memorizeRecipe(World world, Recipe recipe, InventoryCrafting crafting) {
        if (!RecipeMemory.isValid(world, recipe)) {
            return;
        }
        this.lastUpdate = world.func_82737_E();
        recipe.updateLastUse(this.lastUpdate);
        Recipe memory = this.getMemorized(crafting, world);
        if (memory != null) {
            if (memory.isLocked() != recipe.isLocked()) {
                recipe.toggleLock();
            }
            int index = this.recipes.indexOf(memory);
            this.recipes.set(index, recipe);
            return;
        }
        if (this.recipes.size() < 9) {
            this.recipes.add(recipe);
            return;
        }
        Recipe oldest = null;
        for (Recipe existing : this.recipes) {
            if (oldest != null && oldest.getLastUsed() < existing.getLastUsed() || existing.isLocked()) continue;
            oldest = existing;
        }
        if (oldest != null) {
            this.recipes.remove(oldest);
            this.recipes.add(recipe);
        }
    }

    public Recipe getRecipe(int recipeIndex) {
        if (this.recipes.size() > recipeIndex) {
            return this.recipes.get(recipeIndex);
        }
        return null;
    }

    public IInventory getRecipeMatrix(int recipeIndex) {
        Recipe recipe = this.getRecipe(recipeIndex);
        recipe.sanitizeMatrix();
        return recipe.getMatrix();
    }

    public ItemStack getRecipeOutput(World world, int recipeIndex) {
        if (this.recipes.size() > recipeIndex) {
            return this.recipes.get(recipeIndex).getRecipeOutput(world);
        }
        return null;
    }

    public boolean isLocked(int recipeIndex) {
        if (this.recipes.size() > recipeIndex) {
            return this.recipes.get(recipeIndex).isLocked();
        }
        return false;
    }

    public void toggleLock(World world, int recipeIndex) {
        this.lastUpdate = world.func_82737_E();
        if (this.recipes.size() > recipeIndex) {
            this.recipes.get(recipeIndex).toggleLock();
        }
    }

    private Recipe getMemorized(InventoryCrafting crafting, World world) {
        for (Recipe recipe : this.recipes) {
            if (!recipe.hasSameOutput(crafting, world)) continue;
            return recipe;
        }
        return null;
    }

    @Override
    public void readFromNBT(NBTTagCompound nbttagcompound) {
        this.recipes = new LinkedList();
        if (!nbttagcompound.func_74764_b("RecipeMemory")) {
            return;
        }
        NBTTagList nbttaglist = nbttagcompound.func_150295_c("RecipeMemory", 10);
        for (int j = 0; j < nbttaglist.func_74745_c(); ++j) {
            NBTTagCompound nbttagcompound2 = nbttaglist.func_150305_b(j);
            this.recipes.add(new Recipe(nbttagcompound2));
        }
    }

    @Override
    public void writeToNBT(NBTTagCompound nbttagcompound) {
        NBTTagList nbttaglist = new NBTTagList();
        for (Recipe recipe : this.recipes) {
            if (recipe == null) continue;
            NBTTagCompound nbttagcompound2 = new NBTTagCompound();
            recipe.writeToNBT(nbttagcompound2);
            nbttaglist.func_74742_a((NBTBase)nbttagcompound2);
        }
        nbttagcompound.func_74782_a("RecipeMemory", (NBTBase)nbttaglist);
    }

    static {
        memoryBlacklist.add(ItemMap.class);
    }

    public static final class Recipe
    implements INBTTagable {
        private InventoryAdapter matrix;
        private long lastUsed;
        private boolean locked;
        private ItemStack cachedRecipeOutput;

        public Recipe(InventoryCrafting crafting) {
            this.matrix = new InventoryAdapter(new PlainInventory((IInventory)crafting));
        }

        public Recipe(NBTTagCompound nbttagcompound) {
            this.readFromNBT(nbttagcompound);
        }

        public void updateLastUse(long lastUsed) {
            this.lastUsed = lastUsed;
        }

        public void toggleLock() {
            this.locked = !this.locked;
        }

        public InventoryAdapter getMatrix() {
            return this.matrix;
        }

        public ItemStack getRecipeOutput(World world) {
            if (this.cachedRecipeOutput == null) {
                InventoryCrafting crafting = new InventoryCrafting(DUMMY_CONTAINER, 3, 3);
                for (int i = 0; i < crafting.func_70302_i_(); ++i) {
                    crafting.func_70299_a(i, this.matrix.func_70301_a(i));
                }
                this.cachedRecipeOutput = CraftingManager.func_77594_a().func_82787_a(crafting, world);
            }
            return this.cachedRecipeOutput;
        }

        public long getLastUsed() {
            return this.lastUsed;
        }

        public boolean isLocked() {
            return this.locked;
        }

        public boolean hasSameOutput(InventoryCrafting crafting, World world) {
            ItemStack recipeOutput = this.getRecipeOutput(world);
            if (recipeOutput == null) {
                return false;
            }
            ItemStack matchingRecipeOutput = CraftingManager.func_77594_a().func_82787_a(crafting, world);
            return ItemStack.func_77989_b((ItemStack)recipeOutput, (ItemStack)matchingRecipeOutput);
        }

        @Override
        public final void readFromNBT(NBTTagCompound nbttagcompound) {
            this.matrix = new InventoryAdapter((IInventory)new InventoryCrafting(DUMMY_CONTAINER, 3, 3));
            this.matrix.readFromNBT(nbttagcompound);
            this.sanitizeMatrix();
            this.lastUsed = nbttagcompound.func_74763_f("LastUsed");
            this.locked = nbttagcompound.func_74767_n("Locked");
        }

        @Override
        public void writeToNBT(NBTTagCompound nbttagcompound) {
            this.sanitizeMatrix();
            this.matrix.writeToNBT(nbttagcompound);
            nbttagcompound.func_74772_a("LastUsed", this.lastUsed);
            nbttagcompound.func_74757_a("Locked", this.locked);
        }

        private void sanitizeMatrix() {
            for (int slot = 0; slot < this.matrix.func_70302_i_(); ++slot) {
                ItemStack stack = this.matrix.func_70301_a(slot);
                if (stack == null) continue;
                stack.field_77994_a = 1;
            }
        }
    }
}

