/*
 * Decompiled with CFR 0.152.
 */
package forestry.factory.gadgets;

import forestry.api.core.ForestryAPI;
import forestry.api.recipes.IStillManager;
import forestry.core.EnumErrorCode;
import forestry.core.config.Config;
import forestry.core.fluids.FluidHelper;
import forestry.core.fluids.TankManager;
import forestry.core.fluids.tanks.FilteredTank;
import forestry.core.fluids.tanks.StandardTank;
import forestry.core.gadgets.TileBase;
import forestry.core.gadgets.TilePowered;
import forestry.core.interfaces.ILiquidTankContainer;
import forestry.core.inventory.IInventoryAdapter;
import forestry.core.inventory.TileInventoryAdapter;
import forestry.core.network.GuiId;
import forestry.core.utils.EnumTankLevel;
import forestry.core.utils.Utils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.ICrafting;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTankInfo;

public class MachineStill
extends TilePowered
implements ISidedInventory,
ILiquidTankContainer {
    public static final short SLOT_PRODUCT = 0;
    public static final short SLOT_RESOURCE = 1;
    public static final short SLOT_CAN = 2;
    public final FilteredTank resourceTank;
    public final FilteredTank productTank;
    private final TankManager tankManager;
    private Recipe currentRecipe;
    private FluidStack bufferedLiquid;
    public int distillationTime = 0;
    public int distillationTotalTime = 0;

    public MachineStill() {
        super(1100, 50, 8000);
        this.setInternalInventory(new TileInventoryAdapter(this, 3, "Items"){

            @Override
            public boolean canSlotAccept(int slotIndex, ItemStack itemStack) {
                if (slotIndex == 1) {
                    return FluidHelper.isEmptyContainer(itemStack);
                }
                if (slotIndex == 2) {
                    Fluid fluid = FluidHelper.getFluidInContainer(itemStack);
                    return MachineStill.this.resourceTank.accepts(fluid);
                }
                return false;
            }

            @Override
            public boolean func_102008_b(int slotIndex, ItemStack itemstack, int side) {
                return slotIndex == 0;
            }
        });
        this.setHints(Config.hints.get("still"));
        this.resourceTank = new FilteredTank(10000, RecipeManager.recipeFluidInputs);
        this.resourceTank.tankMode = StandardTank.TankMode.INPUT;
        this.productTank = new FilteredTank(10000, RecipeManager.recipeFluidOutputs);
        this.productTank.tankMode = StandardTank.TankMode.OUTPUT;
        this.tankManager = new TankManager(this.resourceTank, this.productTank);
    }

    @Override
    public void openGui(EntityPlayer player, TileBase tile) {
        player.openGui(ForestryAPI.instance, GuiId.StillGUI.ordinal(), player.field_70170_p, this.field_145851_c, this.field_145848_d, this.field_145849_e);
    }

    @Override
    public void func_145841_b(NBTTagCompound nbttagcompound) {
        super.func_145841_b(nbttagcompound);
        nbttagcompound.func_74768_a("DistillationTime", this.distillationTime);
        nbttagcompound.func_74768_a("DistillationTotalTime", this.distillationTotalTime);
        this.tankManager.writeTanksToNBT(nbttagcompound);
    }

    @Override
    public void func_145839_a(NBTTagCompound nbttagcompound) {
        super.func_145839_a(nbttagcompound);
        this.distillationTime = nbttagcompound.func_74762_e("DistillationTime");
        this.distillationTotalTime = nbttagcompound.func_74762_e("DistillationTotalTime");
        this.tankManager.readTanksFromNBT(nbttagcompound);
        this.checkRecipe();
    }

    @Override
    public void updateServerSide() {
        FluidStack fluidStack;
        if (this.field_145850_b.func_82737_E() % 20L * 10L != 0L) {
            return;
        }
        IInventoryAdapter inventory = this.getInternalInventory();
        if (inventory.func_70301_a(2) != null) {
            FluidHelper.drainContainers(this.tankManager, (IInventory)inventory, 2);
        }
        if (inventory.func_70301_a(1) != null && (fluidStack = this.productTank.getFluid()) != null) {
            FluidHelper.fillContainers(this.tankManager, (IInventory)inventory, 1, 0, fluidStack.getFluid());
        }
        this.checkRecipe();
        if (this.getErrorState() == EnumErrorCode.NORECIPE && this.currentRecipe != null) {
            this.setErrorState(EnumErrorCode.OK);
        }
        if (this.energyManager.getTotalEnergyStored() == 0) {
            this.setErrorState(EnumErrorCode.NOPOWER);
        }
    }

    @Override
    public boolean workCycle() {
        this.checkRecipe();
        if (this.distillationTime > 0 && this.currentRecipe != null) {
            this.distillationTime -= this.currentRecipe.input.amount;
            this.addProduct(this.currentRecipe.output.fluidID, this.currentRecipe.output.amount);
            this.setErrorState(EnumErrorCode.OK);
            return true;
        }
        if (this.currentRecipe != null && this.productTank.getFluidAmount() + this.currentRecipe.output.amount <= 10000) {
            int resReq = this.currentRecipe.timePerUnit * this.currentRecipe.input.amount;
            if (this.resourceTank.getFluidAmount() >= resReq) {
                this.distillationTime = this.distillationTotalTime = resReq;
                this.resourceTank.drain(resReq, true);
                this.bufferedLiquid = new FluidStack(this.currentRecipe.input.fluidID, resReq);
                this.setErrorState(EnumErrorCode.OK);
                return true;
            }
            this.setErrorState(EnumErrorCode.NORESOURCE);
        }
        this.bufferedLiquid = null;
        return false;
    }

    private void addProduct(int id, int amount) {
        this.productTank.fill(new FluidStack(id, amount), true);
    }

    public void checkRecipe() {
        Recipe sameRec = RecipeManager.findMatchingRecipe(this.resourceTank.getFluid());
        if (sameRec == null && this.bufferedLiquid != null && this.distillationTime > 0) {
            sameRec = RecipeManager.findMatchingRecipe(new FluidStack(this.bufferedLiquid.fluidID, this.distillationTime));
        }
        if (sameRec == null) {
            this.setErrorState(EnumErrorCode.NORECIPE);
        }
        if (this.currentRecipe != sameRec) {
            this.currentRecipe = sameRec;
            this.resetRecipe();
        }
    }

    private void resetRecipe() {
    }

    @Override
    public boolean isWorking() {
        return this.distillationTime > 0 || this.currentRecipe != null && this.productTank.getFluidAmount() + this.currentRecipe.output.amount <= 10000;
    }

    @Override
    public boolean hasWork() {
        if (this.currentRecipe == null) {
            return false;
        }
        return (this.distillationTime > 0 || this.resourceTank.getFluidAmount() >= this.currentRecipe.timePerUnit * this.currentRecipe.input.amount) && this.productTank.getFluidAmount() <= this.productTank.getCapacity() - this.currentRecipe.output.amount;
    }

    public int getDistillationProgressScaled(int i) {
        if (this.distillationTotalTime == 0) {
            return i;
        }
        return this.distillationTime * i / this.distillationTotalTime;
    }

    public int getResourceScaled(int i) {
        return this.resourceTank.getFluidAmount() * i / 10000;
    }

    public int getProductScaled(int i) {
        return this.productTank.getFluidAmount() * i / 10000;
    }

    @Override
    public EnumTankLevel getPrimaryLevel() {
        return Utils.rateTankLevel(this.getResourceScaled(100));
    }

    @Override
    public EnumTankLevel getSecondaryLevel() {
        return Utils.rateTankLevel(this.getProductScaled(100));
    }

    @Override
    public void getGUINetworkData(int i, int j) {
        switch (i -= this.tankManager.maxMessageId() + 1) {
            case 0: {
                this.distillationTime = j;
                break;
            }
            case 1: {
                this.distillationTotalTime = j;
            }
        }
    }

    @Override
    public void sendGUINetworkData(Container container, ICrafting iCrafting) {
        int i = this.tankManager.maxMessageId() + 1;
        iCrafting.func_71112_a(container, i, this.distillationTime);
        iCrafting.func_71112_a(container, i + 1, this.distillationTotalTime);
    }

    public int fill(ForgeDirection from, FluidStack resource, boolean doFill) {
        return this.tankManager.fill(from, resource, doFill);
    }

    public FluidStack drain(ForgeDirection from, FluidStack resource, boolean doDrain) {
        return this.tankManager.drain(from, resource, doDrain);
    }

    public FluidStack drain(ForgeDirection from, int quantityMax, boolean doEmpty) {
        return this.tankManager.drain(from, quantityMax, doEmpty);
    }

    public boolean canFill(ForgeDirection from, Fluid fluid) {
        return this.tankManager.canFill(from, fluid);
    }

    public boolean canDrain(ForgeDirection from, Fluid fluid) {
        return this.tankManager.canDrain(from, fluid);
    }

    @Override
    public TankManager getTankManager() {
        return this.tankManager;
    }

    public FluidTankInfo[] getTankInfo(ForgeDirection from) {
        return this.tankManager.getTankInfo(from);
    }

    public static class RecipeManager
    implements IStillManager {
        public static final ArrayList<Recipe> recipes = new ArrayList();
        public static final HashSet<Fluid> recipeFluidInputs = new HashSet();
        public static final HashSet<Fluid> recipeFluidOutputs = new HashSet();

        @Override
        public void addRecipe(int timePerUnit, FluidStack input, FluidStack output) {
            recipes.add(new Recipe(timePerUnit, input, output));
            if (input != null) {
                recipeFluidInputs.add(input.getFluid());
            }
            if (output != null) {
                recipeFluidOutputs.add(output.getFluid());
            }
        }

        public static Recipe findMatchingRecipe(FluidStack item) {
            for (Recipe recipe : recipes) {
                if (!recipe.matches(item)) continue;
                return recipe;
            }
            return null;
        }

        public static boolean isInput(FluidStack res) {
            return recipeFluidInputs.contains(res.getFluid());
        }

        @Override
        public Map<Object[], Object[]> getRecipes() {
            HashMap<Object[], Object[]> recipeList = new HashMap<Object[], Object[]>();
            for (Recipe recipe : recipes) {
                recipeList.put(new Object[]{recipe.input}, new Object[]{recipe.output});
            }
            return recipeList;
        }
    }

    public static class Recipe {
        public final int timePerUnit;
        public final FluidStack input;
        public final FluidStack output;

        public Recipe(int timePerUnit, FluidStack input, FluidStack output) {
            this.timePerUnit = timePerUnit;
            if (input == null) {
                throw new IllegalArgumentException("Still recipes need an input. Input was null.");
            }
            if (output == null) {
                throw new IllegalArgumentException("Still recipes need an output. Output was null.");
            }
            this.input = input;
            this.output = output;
        }

        public boolean matches(FluidStack res) {
            if (res == null) {
                return false;
            }
            return this.input.isFluidEqual(res);
        }
    }
}

