/*
 * Decompiled with CFR 0.152.
 */
package forestry.factory.gadgets;

import forestry.api.core.BiomeHelper;
import forestry.api.core.ForestryAPI;
import forestry.core.EnumErrorCode;
import forestry.core.config.Config;
import forestry.core.fluids.FluidHelper;
import forestry.core.fluids.Fluids;
import forestry.core.fluids.TankManager;
import forestry.core.fluids.tanks.FilteredTank;
import forestry.core.gadgets.TileBase;
import forestry.core.interfaces.ILiquidTankContainer;
import forestry.core.inventory.IInventoryAdapter;
import forestry.core.inventory.TileInventoryAdapter;
import forestry.core.network.GuiId;
import forestry.core.utils.StackUtils;
import forestry.core.utils.Utils;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.ICrafting;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTankInfo;

public class MachineRaintank
extends TileBase
implements ISidedInventory,
ILiquidTankContainer {
    public static final short SLOT_RESOURCE = 0;
    public static final short SLOT_PRODUCT = 1;
    private static final FluidStack STACK_WATER = Fluids.WATER.getFluid(10);
    private final FilteredTank resourceTank;
    private final TankManager tankManager;
    private boolean isValidBiome = true;
    private int fillingTime;
    private ItemStack usedEmpty;

    public MachineRaintank() {
        this.setInternalInventory(new TileInventoryAdapter(this, 3, "Items"){

            @Override
            public boolean canSlotAccept(int slotIndex, ItemStack itemStack) {
                if (slotIndex == 0) {
                    return FluidHelper.isFillableContainer(itemStack, Fluids.WATER.getFluid(1000));
                }
                return false;
            }

            @Override
            public boolean func_102008_b(int slotIndex, ItemStack itemstack, int side) {
                return slotIndex == 1;
            }
        });
        this.setHints(Config.hints.get("raintank"));
        this.resourceTank = new FilteredTank(30000, FluidRegistry.WATER);
        this.tankManager = new TankManager(this.resourceTank);
    }

    @Override
    public void func_145829_t() {
        BiomeGenBase biome;
        if (this.field_145850_b != null && !BiomeHelper.canRainOrSnow(biome = Utils.getBiomeAt(this.field_145850_b, this.field_145851_c, this.field_145849_e))) {
            this.setErrorState(EnumErrorCode.INVALIDBIOME);
            this.isValidBiome = false;
        }
        super.func_145829_t();
    }

    @Override
    public void openGui(EntityPlayer player, TileBase tile) {
        player.openGui(ForestryAPI.instance, GuiId.RaintankGUI.ordinal(), player.field_70170_p, this.field_145851_c, this.field_145848_d, this.field_145849_e);
    }

    @Override
    public void func_145841_b(NBTTagCompound nbttagcompound) {
        super.func_145841_b(nbttagcompound);
        nbttagcompound.func_74757_a("IsValidBiome", this.isValidBiome);
        this.tankManager.writeTanksToNBT(nbttagcompound);
    }

    @Override
    public void func_145839_a(NBTTagCompound nbttagcompound) {
        super.func_145839_a(nbttagcompound);
        this.isValidBiome = nbttagcompound.func_74767_n("IsValidBiome");
        this.tankManager.readTanksFromNBT(nbttagcompound);
    }

    @Override
    public void updateServerSide() {
        if (!this.isValidBiome) {
            this.setErrorState(EnumErrorCode.INVALIDBIOME);
        } else if (!this.field_145850_b.func_72937_j(this.field_145851_c, this.field_145848_d + 1, this.field_145849_e)) {
            this.setErrorState(EnumErrorCode.NOSKY);
        } else if (!this.field_145850_b.func_72896_J()) {
            this.setErrorState(EnumErrorCode.NOTRAINING);
        } else {
            this.resourceTank.fill(STACK_WATER, true);
            this.setErrorState(EnumErrorCode.OK);
        }
        if (this.field_145850_b.func_82737_E() % 16L != 0L) {
            return;
        }
        IInventoryAdapter inventory = this.getInternalInventory();
        if (!StackUtils.isIdenticalItem(this.usedEmpty, inventory.func_70301_a(0))) {
            this.fillingTime = 0;
            this.usedEmpty = null;
        }
        if (this.usedEmpty == null) {
            this.usedEmpty = inventory.func_70301_a(0);
        }
        if (!this.isFilling()) {
            this.tryToStartFillling();
        } else {
            --this.fillingTime;
            if (this.fillingTime <= 0 && FluidHelper.fillContainers(this.tankManager, (IInventory)inventory, 0, 1, Fluids.WATER.getFluid())) {
                this.fillingTime = 0;
            }
        }
    }

    public boolean isFilling() {
        return this.fillingTime > 0;
    }

    private void tryToStartFillling() {
        if (!FluidHelper.fillContainers(this.tankManager, (IInventory)this.getInternalInventory(), 0, 1, Fluids.WATER.getFluid(), false)) {
            return;
        }
        this.fillingTime = 12;
    }

    public int getFillProgressScaled(int i) {
        return this.fillingTime * i / 12;
    }

    @Override
    public void getGUINetworkData(int i, int j) {
        switch (i -= this.tankManager.maxMessageId() + 1) {
            case 0: {
                this.fillingTime = j;
            }
        }
    }

    @Override
    public void sendGUINetworkData(Container container, ICrafting iCrafting) {
        int i = this.tankManager.maxMessageId() + 1;
        iCrafting.func_71112_a(container, i, this.fillingTime);
    }

    public int fill(ForgeDirection from, FluidStack resource, boolean doFill) {
        return this.tankManager.fill(from, resource, doFill);
    }

    public FluidStack drain(ForgeDirection from, FluidStack resource, boolean doDrain) {
        return this.tankManager.drain(from, resource, doDrain);
    }

    public FluidStack drain(ForgeDirection from, int maxDrain, boolean doDrain) {
        return this.tankManager.drain(from, maxDrain, doDrain);
    }

    public boolean canFill(ForgeDirection from, Fluid fluid) {
        return this.tankManager.canFill(from, fluid);
    }

    public boolean canDrain(ForgeDirection from, Fluid fluid) {
        return this.tankManager.canDrain(from, fluid);
    }

    @Override
    public TankManager getTankManager() {
        return this.tankManager;
    }

    public FluidTankInfo[] getTankInfo(ForgeDirection from) {
        return this.tankManager.getTankInfo(from);
    }
}

