/*
 * Decompiled with CFR 0.152.
 */
package forestry.factory.gadgets;

import forestry.api.core.ForestryAPI;
import forestry.api.fuels.FuelManager;
import forestry.api.fuels.MoistenerFuel;
import forestry.api.recipes.IMoistenerManager;
import forestry.core.EnumErrorCode;
import forestry.core.config.Config;
import forestry.core.fluids.FluidHelper;
import forestry.core.fluids.TankManager;
import forestry.core.fluids.tanks.FilteredTank;
import forestry.core.gadgets.TileBase;
import forestry.core.interfaces.ILiquidTankContainer;
import forestry.core.interfaces.IRenderableMachine;
import forestry.core.inventory.IInventoryAdapter;
import forestry.core.inventory.InvTools;
import forestry.core.inventory.TileInventoryAdapter;
import forestry.core.network.GuiId;
import forestry.core.utils.EnumTankLevel;
import forestry.core.utils.GuiUtil;
import forestry.core.utils.StackUtils;
import forestry.core.utils.Utils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.ICrafting;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTankInfo;

public class MachineMoistener
extends TileBase
implements ISidedInventory,
ILiquidTankContainer,
IRenderableMachine {
    private static final short SLOT_STASH_1 = 0;
    private static final short SLOT_STASH_COUNT = 6;
    private static final short SLOT_RESERVOIR_1 = 6;
    private static final short SLOT_RESERVOIR_COUNT = 3;
    private static final short SLOT_WORKING = 9;
    private static final short SLOT_PRODUCT = 10;
    private static final short SLOT_RESOURCE = 11;
    public final FilteredTank resourceTank;
    private final TankManager tankManager;
    public Recipe currentRecipe;
    public int burnTime = 0;
    public int totalTime = 0;
    public int productionTime = 0;
    private int timePerItem = 0;
    private ItemStack currentProduct;
    private ItemStack pendingProduct;

    public MachineMoistener() {
        this.setInternalInventory(new TileInventoryAdapter(this, 12, "Items"){

            @Override
            public boolean canSlotAccept(int slotIndex, ItemStack itemStack) {
                if (slotIndex == 11) {
                    return RecipeManager.isResource(itemStack);
                }
                if (GuiUtil.isIndexInRange(slotIndex, 0, 6)) {
                    return FuelManager.moistenerResource.containsKey(itemStack);
                }
                if (slotIndex == 10) {
                    Fluid fluid = FluidHelper.getFluidInContainer(itemStack);
                    return MachineMoistener.this.resourceTank.accepts(fluid);
                }
                return false;
            }

            @Override
            public boolean func_102008_b(int slotIndex, ItemStack itemstack, int side) {
                if (slotIndex == 10) {
                    return true;
                }
                if (GuiUtil.isIndexInRange(slotIndex, 0, 6)) {
                    return !FuelManager.moistenerResource.containsKey(itemstack);
                }
                return false;
            }
        });
        this.setHints(Config.hints.get("moistener"));
        this.resourceTank = new FilteredTank(10000, FluidRegistry.WATER);
        this.tankManager = new TankManager(this.resourceTank);
    }

    @Override
    public void openGui(EntityPlayer player, TileBase tile) {
        player.openGui(ForestryAPI.instance, GuiId.MoistenerGUI.ordinal(), player.field_70170_p, this.field_145851_c, this.field_145848_d, this.field_145849_e);
    }

    @Override
    public void func_145841_b(NBTTagCompound nbttagcompound) {
        NBTTagCompound nbttagcompoundP;
        super.func_145841_b(nbttagcompound);
        nbttagcompound.func_74768_a("BurnTime", this.burnTime);
        nbttagcompound.func_74768_a("TotalTime", this.totalTime);
        nbttagcompound.func_74768_a("ProductionTime", this.productionTime);
        this.tankManager.writeTanksToNBT(nbttagcompound);
        if (this.pendingProduct != null) {
            nbttagcompoundP = new NBTTagCompound();
            this.pendingProduct.func_77955_b(nbttagcompoundP);
            nbttagcompound.func_74782_a("PendingProduct", (NBTBase)nbttagcompoundP);
        }
        if (this.currentProduct != null) {
            nbttagcompoundP = new NBTTagCompound();
            this.currentProduct.func_77955_b(nbttagcompoundP);
            nbttagcompound.func_74782_a("CurrentProduct", (NBTBase)nbttagcompoundP);
        }
    }

    @Override
    public void func_145839_a(NBTTagCompound nbttagcompound) {
        NBTTagCompound nbttagcompoundP;
        super.func_145839_a(nbttagcompound);
        this.burnTime = nbttagcompound.func_74762_e("BurnTime");
        this.totalTime = nbttagcompound.func_74762_e("TotalTime");
        this.productionTime = nbttagcompound.func_74762_e("ProductionTime");
        this.tankManager.readTanksFromNBT(nbttagcompound);
        if (nbttagcompound.func_74764_b("PendingProduct")) {
            nbttagcompoundP = nbttagcompound.func_74775_l("PendingProduct");
            this.pendingProduct = ItemStack.func_77949_a((NBTTagCompound)nbttagcompoundP);
        }
        if (nbttagcompound.func_74764_b("CurrentProduct")) {
            nbttagcompoundP = nbttagcompound.func_74775_l("CurrentProduct");
            this.currentProduct = ItemStack.func_77949_a((NBTTagCompound)nbttagcompoundP);
        }
        this.checkRecipe();
    }

    @Override
    public void updateServerSide() {
        int lightvalue;
        IInventoryAdapter inventory = this.getInternalInventory();
        if (inventory.func_70301_a(10) != null) {
            FluidHelper.drainContainers(this.tankManager, (IInventory)inventory, 10);
        }
        if ((lightvalue = this.field_145850_b.func_72957_l(this.field_145851_c, this.field_145848_d + 1, this.field_145849_e)) > 11) {
            this.setErrorState(EnumErrorCode.NOTGLOOMY);
            return;
        }
        int speed = lightvalue >= 9 ? 1 : (lightvalue >= 7 ? 2 : (lightvalue >= 5 ? 3 : 4));
        if (this.burnTime > 0 && this.pendingProduct == null) {
            if (this.resourceTank.getFluidAmount() <= 0) {
                return;
            }
            this.checkRecipe();
            if (this.currentRecipe == null) {
                return;
            }
            this.resourceTank.drain(1, true);
            this.burnTime -= speed;
            this.productionTime -= speed;
            if (this.productionTime <= 0) {
                this.pendingProduct = this.currentProduct;
                this.func_70298_a(11, 1);
                this.resetRecipe();
                this.tryAddPending();
            }
        } else if (this.pendingProduct != null) {
            this.tryAddPending();
        } else if (this.rotateWorkingSlot()) {
            this.checkRecipe();
            if (inventory.func_70301_a(9) == null) {
                return;
            }
            if (FuelManager.moistenerResource.containsKey(inventory.func_70301_a(9))) {
                MoistenerFuel res = FuelManager.moistenerResource.get(inventory.func_70301_a(9));
                this.burnTime = this.totalTime = res.moistenerValue;
            }
        } else {
            this.rotateReservoir();
        }
        if (this.currentRecipe != null) {
            this.setErrorState(EnumErrorCode.OK);
        } else {
            this.setErrorState(EnumErrorCode.NORECIPE);
        }
    }

    private boolean tryAddPending() {
        if (this.pendingProduct == null) {
            return false;
        }
        IInventoryAdapter inventory = this.getInternalInventory();
        if (InvTools.tryAddStack((IInventory)inventory, this.pendingProduct, 10, 1, true)) {
            this.pendingProduct = null;
            return true;
        }
        return false;
    }

    public void checkRecipe() {
        Recipe sameRec = RecipeManager.findMatchingRecipe(this.getInternalInventory().func_70301_a(11));
        if (this.currentRecipe != sameRec) {
            this.currentRecipe = sameRec;
            this.resetRecipe();
        }
    }

    private void resetRecipe() {
        if (this.currentRecipe == null) {
            this.currentProduct = null;
            this.productionTime = 0;
            this.timePerItem = 0;
            this.setErrorState(EnumErrorCode.NORECIPE);
            return;
        }
        this.currentProduct = this.currentRecipe.product;
        this.productionTime = this.currentRecipe.timePerItem;
        this.timePerItem = this.currentRecipe.timePerItem;
    }

    private int getFreeSlot(ItemStack deposit, int startSlot, int endSlot, boolean emptyOnly) {
        int slot = -1;
        IInventoryAdapter inventory = this.getInternalInventory();
        for (int i = startSlot; i < endSlot; ++i) {
            ItemStack slotStack = inventory.func_70301_a(i);
            if (slotStack == null) {
                if (slot >= 0) continue;
                slot = i;
                continue;
            }
            if (emptyOnly || !slotStack.func_77969_a(deposit) || slotStack.field_77994_a >= slotStack.func_77976_d()) continue;
            slot = i;
        }
        return slot;
    }

    private int getFreeStashSlot(ItemStack deposit, boolean emptyOnly) {
        return this.getFreeSlot(deposit, 0, 6, emptyOnly);
    }

    private int getFreeReservoirSlot(ItemStack deposit) {
        return this.getFreeSlot(deposit, 6, 9, false);
    }

    private int getNextResourceSlot(int startSlot, int endSlot) {
        int stage = -1;
        int resourceSlot = -1;
        IInventoryAdapter inventory = this.getInternalInventory();
        for (int i = startSlot; i < endSlot; ++i) {
            ItemStack slotStack = inventory.func_70301_a(i);
            if (slotStack == null || !FuelManager.moistenerResource.containsKey(slotStack)) continue;
            MoistenerFuel res = FuelManager.moistenerResource.get(slotStack);
            if (stage >= 0 && res.stage >= stage) continue;
            stage = res.stage;
            resourceSlot = i;
        }
        return resourceSlot;
    }

    private boolean rotateWorkingSlot() {
        IInventoryAdapter inventory = this.getInternalInventory();
        if (inventory.func_70301_a(9) != null) {
            ItemStack deposit;
            if (FuelManager.moistenerResource.containsKey(inventory.func_70301_a(9))) {
                MoistenerFuel res = FuelManager.moistenerResource.get(inventory.func_70301_a(9));
                deposit = res.product.func_77946_l();
            } else {
                deposit = inventory.func_70301_a(9).func_77946_l();
            }
            int targetSlot = this.getFreeReservoirSlot(deposit);
            if (targetSlot < 0) {
                return false;
            }
            if (inventory.func_70301_a(targetSlot) == null) {
                inventory.func_70299_a(targetSlot, deposit);
            } else {
                ++inventory.func_70301_a((int)targetSlot).field_77994_a;
            }
            this.func_70298_a(9, 1);
        }
        if (inventory.func_70301_a(9) != null) {
            return true;
        }
        int resourceSlot = this.getNextResourceSlot(6, 9);
        if (resourceSlot < 0) {
            return false;
        }
        inventory.func_70299_a(9, inventory.func_70298_a(resourceSlot, 1));
        return true;
    }

    private void rotateReservoir() {
        int targetSlot;
        int resourceSlot;
        ArrayList<Integer> slotsToShift = new ArrayList<Integer>();
        IInventoryAdapter inventory = this.getInternalInventory();
        for (int i = 6; i < 9; ++i) {
            if (inventory.func_70301_a(i) == null || FuelManager.moistenerResource.containsKey(inventory.func_70301_a(i))) continue;
            slotsToShift.add(i);
        }
        int shiftedSlots = 0;
        Iterator i$ = slotsToShift.iterator();
        while (i$.hasNext()) {
            int slot = (Integer)i$.next();
            ItemStack slotStack = inventory.func_70301_a(slot);
            int targetSlot2 = this.getFreeStashSlot(slotStack, true);
            if (targetSlot2 < 0) continue;
            inventory.func_70299_a(targetSlot2, slotStack);
            inventory.func_70299_a(slot, null);
            ++shiftedSlots;
        }
        for (int i = 0; i < (slotsToShift.size() > 0 ? shiftedSlots : 2) && (resourceSlot = this.getNextResourceSlot(0, 6)) >= 0 && (targetSlot = this.getFreeReservoirSlot(inventory.func_70301_a(resourceSlot))) >= 0; ++i) {
            if (inventory.func_70301_a(targetSlot) == null) {
                inventory.func_70299_a(targetSlot, inventory.func_70301_a(resourceSlot));
                inventory.func_70299_a(resourceSlot, null);
                continue;
            }
            StackUtils.mergeStacks(inventory.func_70301_a(resourceSlot), inventory.func_70301_a(targetSlot));
            if (inventory.func_70301_a(resourceSlot) == null || inventory.func_70301_a((int)resourceSlot).field_77994_a > 0) continue;
            inventory.func_70299_a(resourceSlot, null);
        }
    }

    public boolean isWorking() {
        return this.burnTime > 0 && this.resourceTank.getFluidAmount() > 0;
    }

    public boolean hasFuelMin(float percentage) {
        int max = 0;
        int avail = 0;
        IInventoryAdapter inventory = this.getInternalInventory();
        for (int i = 0; i < 6; ++i) {
            if (inventory.func_70301_a(i) == null) {
                max += 64;
                continue;
            }
            if (!FuelManager.moistenerResource.containsKey(inventory.func_70301_a(i))) continue;
            MoistenerFuel res = FuelManager.moistenerResource.get(inventory.func_70301_a(i));
            if (!res.item.func_77969_a(inventory.func_70301_a(i))) continue;
            max += 64;
            avail += inventory.func_70301_a((int)i).field_77994_a;
        }
        return (float)avail / (float)max > percentage;
    }

    public boolean hasResourcesMin(float percentage) {
        IInventoryAdapter inventory = this.getInternalInventory();
        if (inventory.func_70301_a(11) == null) {
            return false;
        }
        return (float)inventory.func_70301_a((int)11).field_77994_a / (float)inventory.func_70301_a(11).func_77976_d() > percentage;
    }

    public boolean isProducing() {
        return this.productionTime > 0;
    }

    public int getProductionProgressScaled(int i) {
        if (this.timePerItem == 0) {
            return 0;
        }
        return this.productionTime * i / this.timePerItem;
    }

    public int getConsumptionProgressScaled(int i) {
        if (this.totalTime == 0) {
            return 0;
        }
        return this.burnTime * i / this.totalTime;
    }

    public int getResourceScaled(int i) {
        return this.resourceTank.getFluidAmount() * i / 10000;
    }

    @Override
    public EnumTankLevel getPrimaryLevel() {
        return Utils.rateTankLevel(this.getResourceScaled(100));
    }

    @Override
    public EnumTankLevel getSecondaryLevel() {
        return EnumTankLevel.EMPTY;
    }

    public int fill(ForgeDirection from, FluidStack resource, boolean doFill) {
        return this.tankManager.fill(from, resource, doFill);
    }

    @Override
    public TankManager getTankManager() {
        return this.tankManager;
    }

    public FluidStack drain(ForgeDirection from, FluidStack resource, boolean doDrain) {
        return this.tankManager.drain(from, resource, doDrain);
    }

    public FluidStack drain(ForgeDirection from, int maxDrain, boolean doDrain) {
        return this.tankManager.drain(from, maxDrain, doDrain);
    }

    public boolean canFill(ForgeDirection from, Fluid fluid) {
        return this.tankManager.canFill(from, fluid);
    }

    public boolean canDrain(ForgeDirection from, Fluid fluid) {
        return this.tankManager.canDrain(from, fluid);
    }

    public FluidTankInfo[] getTankInfo(ForgeDirection from) {
        return this.tankManager.getTankInfo(from);
    }

    @Override
    public void getGUINetworkData(int i, int j) {
        switch (i -= this.tankManager.maxMessageId() + 1) {
            case 0: {
                this.burnTime = j;
                break;
            }
            case 1: {
                this.totalTime = j;
                break;
            }
            case 2: {
                this.productionTime = j;
                break;
            }
            case 3: {
                this.timePerItem = j;
            }
        }
    }

    @Override
    public void sendGUINetworkData(Container container, ICrafting iCrafting) {
        int i = this.tankManager.maxMessageId() + 1;
        iCrafting.func_71112_a(container, i, this.burnTime);
        iCrafting.func_71112_a(container, i + 1, this.totalTime);
        iCrafting.func_71112_a(container, i + 2, this.productionTime);
        iCrafting.func_71112_a(container, i + 3, this.timePerItem);
    }

    public static class RecipeManager
    implements IMoistenerManager {
        public static final ArrayList<Recipe> recipes = new ArrayList();

        @Override
        public void addRecipe(ItemStack resource, ItemStack product, int timePerItem) {
            recipes.add(new Recipe(resource, product, timePerItem));
        }

        public static boolean isResource(ItemStack resource) {
            if (resource == null) {
                return false;
            }
            for (Recipe rec : recipes) {
                if (!StackUtils.isIdenticalItem(resource, rec.resource)) continue;
                return true;
            }
            return false;
        }

        public static Recipe findMatchingRecipe(ItemStack item) {
            for (Recipe recipe : recipes) {
                if (!recipe.matches(item)) continue;
                return recipe;
            }
            return null;
        }

        @Override
        public Map<Object[], Object[]> getRecipes() {
            HashMap<Object[], Object[]> recipeList = new HashMap<Object[], Object[]>();
            for (Recipe recipe : recipes) {
                recipeList.put(new ItemStack[]{recipe.resource}, new ItemStack[]{recipe.product});
            }
            return recipeList;
        }
    }

    public static class Recipe {
        public final int timePerItem;
        public final ItemStack resource;
        public final ItemStack product;

        public Recipe(ItemStack resource, ItemStack product, int timePerItem) {
            this.timePerItem = timePerItem;
            this.resource = resource;
            this.product = product;
        }

        public boolean matches(ItemStack res) {
            if (res == null && this.resource == null) {
                return true;
            }
            if (res == null || this.resource == null) {
                return false;
            }
            return this.resource.func_77969_a(res);
        }
    }
}

