/*
 * Decompiled with CFR 0.152.
 */
package forestry.factory.gadgets;

import buildcraft.api.statements.ITriggerExternal;
import cpw.mods.fml.common.Optional;
import forestry.api.core.ForestryAPI;
import forestry.api.recipes.ICentrifugeManager;
import forestry.core.EnumErrorCode;
import forestry.core.config.Config;
import forestry.core.gadgets.TileBase;
import forestry.core.gadgets.TilePowered;
import forestry.core.inventory.IInventoryAdapter;
import forestry.core.inventory.InvTools;
import forestry.core.inventory.TileInventoryAdapter;
import forestry.core.network.GuiId;
import forestry.core.utils.GuiUtil;
import forestry.factory.triggers.FactoryTriggers;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.ICrafting;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.util.ForgeDirection;

public class MachineCentrifuge
extends TilePowered
implements ISidedInventory {
    public static final int SLOT_RESOURCE = 0;
    public static final int SLOT_PRODUCT_1 = 1;
    public static final int SLOT_PRODUCT_COUNT = 9;
    public Recipe currentRecipe;
    private final Stack<ItemStack> pendingProducts = new Stack();
    private int productionTime;
    private int timePerItem;

    public MachineCentrifuge() {
        super(800, 40, 5000);
        this.setInternalInventory(new TileInventoryAdapter(this, 10, "Items"){

            @Override
            public boolean canSlotAccept(int slotIndex, ItemStack itemStack) {
                return slotIndex == 0 && RecipeManager.findMatchingRecipe(itemStack) != null;
            }

            @Override
            public boolean func_102008_b(int slotIndex, ItemStack itemstack, int side) {
                return GuiUtil.isIndexInRange(slotIndex, 1, 9);
            }
        });
        this.setHints(Config.hints.get("centrifuge"));
    }

    @Override
    public void openGui(EntityPlayer player, TileBase tile) {
        player.openGui(ForestryAPI.instance, GuiId.CentrifugeGUI.ordinal(), player.field_70170_p, this.field_145851_c, this.field_145848_d, this.field_145849_e);
    }

    @Override
    public void func_145841_b(NBTTagCompound nbttagcompound) {
        super.func_145841_b(nbttagcompound);
        nbttagcompound.func_74768_a("ProductionTime", this.productionTime);
        nbttagcompound.func_74768_a("TimePerItem", this.timePerItem);
        NBTTagList nbttaglist = new NBTTagList();
        ItemStack[] offspring = this.pendingProducts.toArray(new ItemStack[this.pendingProducts.size()]);
        for (int i = 0; i < offspring.length; ++i) {
            if (offspring[i] == null) continue;
            NBTTagCompound nbttagcompound1 = new NBTTagCompound();
            nbttagcompound1.func_74774_a("Slot", (byte)i);
            offspring[i].func_77955_b(nbttagcompound1);
            nbttaglist.func_74742_a((NBTBase)nbttagcompound1);
        }
        nbttagcompound.func_74782_a("PendingProducts", (NBTBase)nbttaglist);
    }

    @Override
    public void func_145839_a(NBTTagCompound nbttagcompound) {
        super.func_145839_a(nbttagcompound);
        this.productionTime = nbttagcompound.func_74762_e("ProductionTime");
        this.timePerItem = nbttagcompound.func_74762_e("TimePerItem");
        NBTTagList nbttaglist = nbttagcompound.func_150295_c("PendingProducts", 10);
        for (int i = 0; i < nbttaglist.func_74745_c(); ++i) {
            NBTTagCompound nbttagcompound1 = nbttaglist.func_150305_b(i);
            this.pendingProducts.add(ItemStack.func_77949_a((NBTTagCompound)nbttagcompound1));
        }
        this.checkRecipe();
    }

    @Override
    public void updateServerSide() {
        if (this.field_145850_b.func_82737_E() % 20L * 10L != 0L) {
            return;
        }
        this.checkRecipe();
        if (this.getErrorState() == EnumErrorCode.NORECIPE && this.currentRecipe != null) {
            this.setErrorState(EnumErrorCode.OK);
        }
        if (this.energyManager.getTotalEnergyStored() == 0) {
            this.setErrorState(EnumErrorCode.NOPOWER);
        }
    }

    @Override
    public boolean workCycle() {
        this.checkRecipe();
        if (this.tryAddPending()) {
            return false;
        }
        if (!this.pendingProducts.isEmpty()) {
            return false;
        }
        if (this.productionTime <= 0) {
            return false;
        }
        if (this.currentRecipe == null) {
            return false;
        }
        --this.productionTime;
        if (this.productionTime > 0) {
            this.setErrorState(EnumErrorCode.OK);
            return true;
        }
        for (Map.Entry<ItemStack, Integer> entry : this.currentRecipe.products.entrySet()) {
            if (entry.getValue() >= 100) {
                this.pendingProducts.push(entry.getKey().func_77946_l());
                continue;
            }
            if (this.field_145850_b.field_73012_v.nextInt(100) >= entry.getValue()) continue;
            this.pendingProducts.push(entry.getKey().func_77946_l());
        }
        this.getInternalInventory().func_70298_a(0, 1);
        this.checkRecipe();
        this.resetRecipe();
        this.tryAddPending();
        return true;
    }

    public void checkRecipe() {
        Recipe sameRec = RecipeManager.findMatchingRecipe(this.getInternalInventory().func_70301_a(0));
        if (sameRec == null) {
            this.setErrorState(EnumErrorCode.NORECIPE);
        }
        if (this.currentRecipe != sameRec) {
            this.currentRecipe = sameRec;
            this.resetRecipe();
        }
    }

    private void resetRecipe() {
        if (this.currentRecipe == null) {
            this.productionTime = 0;
            this.timePerItem = 0;
            return;
        }
        this.productionTime = this.currentRecipe.timePerItem;
        this.timePerItem = this.currentRecipe.timePerItem;
    }

    private boolean tryAddPending() {
        if (this.pendingProducts.isEmpty()) {
            return false;
        }
        ItemStack next = this.pendingProducts.peek();
        if (this.addProduct(next, true)) {
            this.pendingProducts.pop();
            return true;
        }
        this.setErrorState(EnumErrorCode.NOSPACE);
        return false;
    }

    private boolean addProduct(ItemStack product, boolean all) {
        return InvTools.tryAddStack((IInventory)this.getInternalInventory(), product, 1, this.func_70302_i_() - 1, all);
    }

    @Override
    public boolean isWorking() {
        return this.currentRecipe != null;
    }

    @Override
    public boolean hasResourcesMin(float percentage) {
        IInventoryAdapter inventory = this.getInternalInventory();
        if (inventory.func_70301_a(0) == null) {
            return false;
        }
        return (float)inventory.func_70301_a((int)0).field_77994_a / (float)inventory.func_70301_a(0).func_77976_d() > percentage;
    }

    @Override
    public boolean hasWork() {
        return this.currentRecipe != null;
    }

    public int getProgressScaled(int i) {
        if (this.timePerItem == 0) {
            return i;
        }
        return this.productionTime * i / this.timePerItem;
    }

    public void getGUINetworkData(int i, int j) {
        switch (i) {
            case 0: {
                this.productionTime = j;
                break;
            }
            case 1: {
                this.timePerItem = j;
            }
        }
    }

    public void sendGUINetworkData(Container container, ICrafting iCrafting) {
        iCrafting.func_71112_a(container, 0, this.productionTime);
        iCrafting.func_71112_a(container, 1, this.timePerItem);
    }

    @Override
    @Optional.Method(modid="BuildCraftAPI|statements")
    public Collection<ITriggerExternal> getExternalTriggers(ForgeDirection side, TileEntity tile) {
        LinkedList<ITriggerExternal> res = new LinkedList<ITriggerExternal>();
        res.add(FactoryTriggers.lowResource25);
        res.add(FactoryTriggers.lowResource10);
        return res;
    }

    public static class RecipeManager
    implements ICentrifugeManager {
        public static final ArrayList<Recipe> recipes = new ArrayList();

        @Override
        public void addRecipe(int timePerItem, ItemStack resource, HashMap<ItemStack, Integer> products) {
            recipes.add(new Recipe(timePerItem, resource, products));
        }

        @Override
        public void addRecipe(int timePerItem, ItemStack resource, ItemStack[] produce, int[] chances) {
            HashMap<ItemStack, Integer> products = new HashMap<ItemStack, Integer>();
            int i = 0;
            for (ItemStack prod : produce) {
                products.put(prod, chances[i]);
                ++i;
            }
            this.addRecipe(timePerItem, resource, products);
        }

        @Override
        public void addRecipe(int timePerItem, ItemStack resource, ItemStack primary, ItemStack secondary, int chance) {
            HashMap<ItemStack, Integer> products = new HashMap<ItemStack, Integer>();
            products.put(primary, 100);
            if (secondary != null) {
                products.put(secondary, chance);
            }
            this.addRecipe(timePerItem, resource, products);
        }

        @Override
        public void addRecipe(int timePerItem, ItemStack resource, ItemStack primary) {
            HashMap<ItemStack, Integer> products = new HashMap<ItemStack, Integer>();
            products.put(primary, 100);
            this.addRecipe(timePerItem, resource, products);
        }

        public static Recipe findMatchingRecipe(ItemStack item) {
            for (Recipe recipe : recipes) {
                if (!recipe.matches(item)) continue;
                return recipe;
            }
            return null;
        }

        @Override
        public Map<Object[], Object[]> getRecipes() {
            HashMap<Object[], Object[]> recipeList = new HashMap<Object[], Object[]>();
            for (Recipe recipe : recipes) {
                Set<ItemStack> productsKeys = recipe.products.keySet();
                recipeList.put(new Object[]{recipe.resource}, productsKeys.toArray(new ItemStack[productsKeys.size()]));
            }
            return recipeList;
        }
    }

    public static class Recipe {
        public final int timePerItem;
        public final ItemStack resource;
        public final HashMap<ItemStack, Integer> products;

        public Recipe(int timePerItem, ItemStack resource, HashMap<ItemStack, Integer> products) {
            this.timePerItem = timePerItem;
            this.resource = resource;
            this.products = products;
            for (ItemStack item : products.keySet()) {
                if (item != null) continue;
                throw new IllegalArgumentException("Tried to register a null product of " + resource);
            }
        }

        public boolean matches(ItemStack res) {
            if (res == null && this.resource == null) {
                return true;
            }
            if (res == null || this.resource == null) {
                return false;
            }
            return this.resource.func_77969_a(res);
        }
    }
}

