/*
 * Decompiled with CFR 0.152.
 */
package forestry.factory.gadgets;

import buildcraft.api.statements.ITriggerExternal;
import cpw.mods.fml.common.Optional;
import forestry.api.core.ForestryAPI;
import forestry.api.recipes.ICraftingProvider;
import forestry.core.EnumErrorCode;
import forestry.core.config.Config;
import forestry.core.fluids.FluidHelper;
import forestry.core.fluids.TankManager;
import forestry.core.fluids.tanks.StandardTank;
import forestry.core.gadgets.TileBase;
import forestry.core.gadgets.TilePowered;
import forestry.core.interfaces.ILiquidTankContainer;
import forestry.core.inventory.IInventoryAdapter;
import forestry.core.inventory.InvTools;
import forestry.core.inventory.TileInventoryAdapter;
import forestry.core.network.GuiId;
import forestry.core.utils.EnumTankLevel;
import forestry.core.utils.Utils;
import forestry.factory.triggers.FactoryTriggers;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.Stack;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.ICrafting;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidContainerRegistry;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTankInfo;

public class MachineBottler
extends TilePowered
implements ISidedInventory,
ILiquidTankContainer {
    public static final short SLOT_RESOURCE = 0;
    public static final short SLOT_PRODUCT = 1;
    public static final short SLOT_CAN = 2;
    public static final short CYCLES_FILLING_DEFAULT = 5;
    public final StandardTank resourceTank;
    private final TankManager tankManager;
    private boolean productPending = false;
    private Recipe currentRecipe;
    private final Stack<ItemStack> pendingProducts = new Stack();
    private int fillingTime;
    private int fillingTotalTime;

    public MachineBottler() {
        super(1100, 50, 4000);
        this.setInternalInventory(new TileInventoryAdapter(this, 3, "Items"){

            @Override
            public boolean canSlotAccept(int slotIndex, ItemStack itemStack) {
                if (slotIndex == 0) {
                    return FluidContainerRegistry.isEmptyContainer((ItemStack)itemStack);
                }
                if (slotIndex == 2) {
                    FluidStack fluidStack = FluidHelper.getFluidStackInContainer(itemStack);
                    return RecipeManager.isInput(fluidStack);
                }
                return false;
            }

            @Override
            public boolean func_102008_b(int slotIndex, ItemStack itemstack, int side) {
                return slotIndex == 1;
            }
        });
        this.setHints(Config.hints.get("bottler"));
        this.resourceTank = new StandardTank(10000);
        this.tankManager = new TankManager(this.resourceTank);
    }

    @Override
    public void openGui(EntityPlayer player, TileBase tile) {
        player.openGui(ForestryAPI.instance, GuiId.BottlerGUI.ordinal(), player.field_70170_p, this.field_145851_c, this.field_145848_d, this.field_145849_e);
    }

    @Override
    public void func_145841_b(NBTTagCompound nbttagcompound) {
        super.func_145841_b(nbttagcompound);
        nbttagcompound.func_74768_a("FillingTime", this.fillingTime);
        nbttagcompound.func_74768_a("FillingTotalTime", this.fillingTotalTime);
        nbttagcompound.func_74757_a("ProductPending", this.productPending);
        this.tankManager.writeTanksToNBT(nbttagcompound);
        NBTTagList nbttaglist = new NBTTagList();
        ItemStack[] offspring = this.pendingProducts.toArray(new ItemStack[this.pendingProducts.size()]);
        for (int i = 0; i < offspring.length; ++i) {
            if (offspring[i] == null) continue;
            NBTTagCompound nbttagcompound1 = new NBTTagCompound();
            nbttagcompound1.func_74774_a("Slot", (byte)i);
            offspring[i].func_77955_b(nbttagcompound1);
            nbttaglist.func_74742_a((NBTBase)nbttagcompound1);
        }
        nbttagcompound.func_74782_a("PendingProducts", (NBTBase)nbttaglist);
    }

    @Override
    public void func_145839_a(NBTTagCompound nbttagcompound) {
        super.func_145839_a(nbttagcompound);
        this.fillingTime = nbttagcompound.func_74762_e("FillingTime");
        this.fillingTotalTime = nbttagcompound.func_74762_e("FillingTotalTime");
        this.productPending = nbttagcompound.func_74767_n("ProductPending");
        this.tankManager.readTanksFromNBT(nbttagcompound);
        NBTTagList nbttaglist = nbttagcompound.func_150295_c("PendingProducts", 10);
        for (int i = 0; i < nbttaglist.func_74745_c(); ++i) {
            NBTTagCompound nbttagcompound1 = nbttaglist.func_150305_b(i);
            this.pendingProducts.add(ItemStack.func_77949_a((NBTTagCompound)nbttagcompound1));
        }
        this.checkRecipe();
    }

    @Override
    public void updateServerSide() {
        if (this.field_145850_b.func_82737_E() % 20L != 0L) {
            return;
        }
        IInventoryAdapter inventory = this.getInternalInventory();
        if (inventory.func_70301_a(2) != null) {
            FluidHelper.drainContainers(this.tankManager, (IInventory)inventory, 2);
        }
        this.checkRecipe();
        if (this.getErrorState() == EnumErrorCode.NORECIPE && this.currentRecipe != null) {
            this.setErrorState(EnumErrorCode.OK);
        }
        if (this.energyManager.getTotalEnergyStored() == 0) {
            this.setErrorState(EnumErrorCode.NOPOWER);
        }
    }

    @Override
    public boolean workCycle() {
        this.checkRecipe();
        if (this.tryAddPending()) {
            return false;
        }
        if (!this.pendingProducts.isEmpty()) {
            return false;
        }
        if (this.fillingTime <= 0) {
            return false;
        }
        if (this.currentRecipe == null) {
            this.setErrorState(EnumErrorCode.NORECIPE);
            return false;
        }
        --this.fillingTime;
        if (this.fillingTime > 0) {
            this.setErrorState(EnumErrorCode.OK);
            return true;
        }
        this.pendingProducts.push(this.currentRecipe.bottled.func_77946_l());
        IInventoryAdapter inventory = this.getInternalInventory();
        inventory.func_70298_a(0, 1);
        this.resourceTank.drain(this.currentRecipe.input.amount, true);
        this.checkRecipe();
        this.resetRecipe();
        while (this.tryAddPending()) {
        }
        return true;
    }

    public void checkRecipe() {
        IInventoryAdapter inventory = this.getInternalInventory();
        Recipe sameRec = RecipeManager.findMatchingRecipe(this.resourceTank.getFluid(), inventory.func_70301_a(0));
        if (sameRec == null) {
            this.setErrorState(EnumErrorCode.NORECIPE);
        }
        if (this.currentRecipe != sameRec) {
            this.currentRecipe = sameRec;
            this.resetRecipe();
        }
    }

    private void resetRecipe() {
        if (this.currentRecipe == null) {
            this.fillingTime = 0;
            this.fillingTotalTime = 0;
            return;
        }
        this.fillingTime = this.currentRecipe.cyclesPerUnit;
        this.fillingTotalTime = this.currentRecipe.cyclesPerUnit;
    }

    private boolean tryAddPending() {
        if (this.pendingProducts.isEmpty()) {
            return false;
        }
        ItemStack next = this.pendingProducts.peek();
        if (this.addProduct(next, true)) {
            this.pendingProducts.pop();
            return true;
        }
        this.setErrorState(EnumErrorCode.NOSPACE);
        return false;
    }

    private boolean addProduct(ItemStack product, boolean all) {
        return InvTools.tryAddStack((IInventory)this.getInternalInventory(), product, 1, 1, all);
    }

    @Override
    public boolean isWorking() {
        return this.fillingTime > 0;
    }

    @Override
    public boolean hasResourcesMin(float percentage) {
        IInventoryAdapter inventory = this.getInternalInventory();
        if (inventory.func_70301_a(0) == null) {
            return false;
        }
        return (float)inventory.func_70301_a((int)0).field_77994_a / (float)inventory.func_70301_a(0).func_77976_d() > percentage;
    }

    @Override
    public boolean hasWork() {
        return this.currentRecipe != null;
    }

    public int getFillProgressScaled(int i) {
        if (this.fillingTotalTime == 0) {
            return 0;
        }
        return this.fillingTime * i / this.fillingTotalTime;
    }

    public int getResourceScaled(int i) {
        return this.resourceTank.getFluidAmount() * i / 10000;
    }

    @Override
    public EnumTankLevel getPrimaryLevel() {
        return Utils.rateTankLevel(this.getResourceScaled(100));
    }

    @Override
    public void getGUINetworkData(int i, int j) {
        switch (i -= this.tankManager.maxMessageId() + 1) {
            case 0: {
                this.fillingTime = j;
                break;
            }
            case 1: {
                this.fillingTotalTime = j;
            }
        }
    }

    @Override
    public void sendGUINetworkData(Container container, ICrafting iCrafting) {
        int i = this.tankManager.maxMessageId() + 1;
        iCrafting.func_71112_a(container, i, this.fillingTime);
        iCrafting.func_71112_a(container, i + 1, this.fillingTotalTime);
    }

    @Override
    public TankManager getTankManager() {
        return this.tankManager;
    }

    public int fill(ForgeDirection from, FluidStack resource, boolean doFill) {
        return this.tankManager.fill(from, resource, doFill);
    }

    public FluidStack drain(ForgeDirection from, FluidStack resource, boolean doDrain) {
        return this.tankManager.drain(from, resource, doDrain);
    }

    public FluidStack drain(ForgeDirection from, int maxDrain, boolean doDrain) {
        return this.tankManager.drain(from, maxDrain, doDrain);
    }

    public boolean canFill(ForgeDirection from, Fluid fluid) {
        return this.tankManager.canFill(from, fluid);
    }

    public boolean canDrain(ForgeDirection from, Fluid fluid) {
        return this.tankManager.canDrain(from, fluid);
    }

    public FluidTankInfo[] getTankInfo(ForgeDirection from) {
        return this.tankManager.getTankInfo(from);
    }

    @Override
    @Optional.Method(modid="BuildCraftAPI|statements")
    public Collection<ITriggerExternal> getExternalTriggers(ForgeDirection side, TileEntity tile) {
        LinkedList<ITriggerExternal> res = new LinkedList<ITriggerExternal>();
        res.add(FactoryTriggers.lowResource25);
        res.add(FactoryTriggers.lowResource10);
        return res;
    }

    public static class RecipeManager
    implements ICraftingProvider {
        public static final ArrayList<Recipe> recipes = new ArrayList();

        public static Recipe findMatchingRecipe(FluidStack res, ItemStack empty) {
            ItemStack filled;
            if (res == null || empty == null) {
                return null;
            }
            for (Recipe recipe : recipes) {
                if (!recipe.matches(res, empty)) continue;
                return recipe;
            }
            if (FluidHelper.isEmptyContainer(empty) && (filled = FluidHelper.getFilledContainer(res, empty)) != null) {
                Recipe recipe;
                recipe = new Recipe(5, res, empty, filled);
                recipes.add(recipe);
                return recipe;
            }
            return null;
        }

        public static boolean isInput(FluidStack res) {
            if (res == null) {
                return false;
            }
            return FluidRegistry.isFluidRegistered((Fluid)res.getFluid());
        }

        @Override
        public Map<Object[], Object[]> getRecipes() {
            HashMap<Object[], Object[]> recipeList = new HashMap<Object[], Object[]>();
            for (Recipe recipe : recipes) {
                recipeList.put(new Object[]{recipe.input, recipe.can}, new Object[]{recipe.bottled});
            }
            return recipeList;
        }
    }

    public static class Recipe {
        public final int cyclesPerUnit;
        public final FluidStack input;
        public final ItemStack can;
        public final ItemStack bottled;

        public Recipe(int cyclesPerUnit, FluidStack input, ItemStack can, ItemStack bottled) {
            this.cyclesPerUnit = cyclesPerUnit;
            this.input = input;
            this.can = can;
            this.bottled = bottled;
        }

        public boolean matches(FluidStack res, ItemStack empty) {
            return this.input.isFluidEqual(res) && res.amount >= this.input.amount && this.can.func_77969_a(empty);
        }

        public boolean hasInput(FluidStack res) {
            return this.input.isFluidEqual(res);
        }
    }
}

