/*
 * Decompiled with CFR 0.152.
 */
package forestry.energy.gadgets;

import buildcraft.api.statements.ITriggerExternal;
import cpw.mods.fml.common.Optional;
import cpw.mods.fml.common.registry.GameData;
import forestry.api.core.ForestryAPI;
import forestry.api.fuels.FuelManager;
import forestry.core.EnumErrorCode;
import forestry.core.TemperatureState;
import forestry.core.config.Config;
import forestry.core.config.ForestryItem;
import forestry.core.gadgets.Engine;
import forestry.core.gadgets.TileBase;
import forestry.core.inventory.AdjacentInventoryCache;
import forestry.core.inventory.IInventoryAdapter;
import forestry.core.inventory.InvTools;
import forestry.core.inventory.TileInventoryAdapter;
import forestry.core.inventory.wrappers.InventoryMapper;
import forestry.core.network.GuiId;
import forestry.core.utils.GuiUtil;
import forestry.factory.triggers.FactoryTriggers;
import java.util.Collection;
import java.util.LinkedList;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.ICrafting;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.util.ForgeDirection;

public class EngineCopper
extends Engine
implements ISidedInventory {
    public static final short SLOT_FUEL = 0;
    public static final short SLOT_WASTE_1 = 1;
    public static final short SLOT_WASTE_COUNT = 4;
    private Item fuelItem;
    private int fuelItemMeta;
    private int burnTime;
    private int totalBurnTime;
    private int ashProduction;
    private final int ashForItem;
    private final AdjacentInventoryCache inventoryCache = new AdjacentInventoryCache(this, this.getTileCache());

    public EngineCopper() {
        super(10000, 200000, 4000);
        this.setHints(Config.hints.get("engine.copper"));
        this.ashForItem = 7500;
        this.setInternalInventory(new TileInventoryAdapter(this, 5, "Items"){

            @Override
            public boolean canSlotAccept(int slotIndex, ItemStack itemStack) {
                return slotIndex == 0 && FuelManager.copperEngineFuel.containsKey(itemStack);
            }

            @Override
            public boolean func_102008_b(int slotIndex, ItemStack itemstack, int side) {
                return GuiUtil.isIndexInRange(slotIndex, 1, 4);
            }
        });
    }

    @Override
    public void openGui(EntityPlayer player, TileBase tile) {
        player.openGui(ForestryAPI.instance, GuiId.EngineCopperGUI.ordinal(), player.field_70170_p, this.field_145851_c, this.field_145848_d, this.field_145849_e);
    }

    private int getFuelSlot() {
        IInventoryAdapter inventory = this.getInternalInventory();
        if (inventory.func_70301_a(0) == null) {
            return -1;
        }
        if (this.determineFuelValue(inventory.func_70301_a(0)) > 0) {
            return 0;
        }
        return -1;
    }

    private int getFreeWasteSlot() {
        IInventoryAdapter inventory = this.getInternalInventory();
        for (int i = 1; i <= 4; ++i) {
            if (inventory.func_70301_a(i) == null) {
                return i;
            }
            if (!ForestryItem.ash.isItemEqual(inventory.func_70301_a(i)) || inventory.func_70301_a((int)i).field_77994_a >= 64) continue;
            return i;
        }
        return -1;
    }

    @Override
    public void updateServerSide() {
        super.updateServerSide();
        if (this.field_145850_b.func_82737_E() % 40L != 0L) {
            return;
        }
        this.dumpStash();
        if (this.mayBurn() && this.burnTime > 0) {
            this.setErrorState(EnumErrorCode.OK);
            return;
        }
        if (this.forceCooldown) {
            this.setErrorState(EnumErrorCode.FORCEDCOOLDOWN);
            return;
        }
        int fuelSlot = this.getFuelSlot();
        if (fuelSlot >= 0 && this.determineBurnDuration(this.getInternalInventory().func_70301_a(fuelSlot)) > 0) {
            this.setErrorState(EnumErrorCode.OK);
        } else {
            this.setErrorState(EnumErrorCode.NOFUEL);
        }
    }

    @Override
    public void burn() {
        this.currentOutput = 0;
        if (this.burnTime > 0) {
            --this.burnTime;
            this.addAsh(1);
            if (this.isActivated()) {
                this.currentOutput = this.determineFuelValue(new ItemStack(this.fuelItem, 1, this.fuelItemMeta));
                this.energyManager.generateEnergy(this.currentOutput);
            }
        } else if (this.isActivated()) {
            int fuelslot = this.getFuelSlot();
            int wasteslot = this.getFreeWasteSlot();
            if (fuelslot >= 0 && wasteslot >= 0) {
                IInventoryAdapter inventory = this.getInternalInventory();
                this.burnTime = this.totalBurnTime = this.determineBurnDuration(inventory.func_70301_a(fuelslot));
                if (this.burnTime > 0) {
                    this.fuelItem = inventory.func_70301_a(fuelslot).func_77973_b();
                    this.func_70298_a(fuelslot, 1);
                }
            }
        }
    }

    @Override
    public int dissipateHeat() {
        TemperatureState tempState;
        if (this.heat <= 0) {
            return 0;
        }
        int loss = 0;
        if (!this.isBurning()) {
            ++loss;
        }
        if ((tempState = this.getTemperatureState()) == TemperatureState.OVERHEATING || tempState == TemperatureState.OPERATING_TEMPERATURE) {
            ++loss;
        }
        this.heat -= loss;
        return loss;
    }

    @Override
    public int generateHeat() {
        int heatToAdd = 0;
        if (this.isBurning()) {
            ++heatToAdd;
            if ((double)this.energyManager.getTotalEnergyStored() / (double)this.maxEnergy > 0.5) {
                ++heatToAdd;
            }
        }
        this.addHeat(heatToAdd);
        return heatToAdd;
    }

    private void addAsh(int amount) {
        this.ashProduction += amount;
        if (this.ashProduction < this.ashForItem) {
            return;
        }
        int wasteslot = this.getFreeWasteSlot();
        if (wasteslot >= 0) {
            IInventoryAdapter inventory = this.getInternalInventory();
            if (inventory.func_70301_a(wasteslot) == null) {
                inventory.func_70299_a(wasteslot, ForestryItem.ash.getItemStack());
            } else {
                ++inventory.func_70301_a((int)wasteslot).field_77994_a;
            }
        }
        this.ashProduction = 0;
        this.dumpStash();
    }

    private int determineFuelValue(ItemStack fuel) {
        if (FuelManager.copperEngineFuel.containsKey(fuel)) {
            return FuelManager.copperEngineFuel.get((Object)fuel).powerPerCycle;
        }
        return 0;
    }

    private int determineBurnDuration(ItemStack fuel) {
        if (FuelManager.copperEngineFuel.containsKey(fuel)) {
            return FuelManager.copperEngineFuel.get((Object)fuel).burnDuration;
        }
        return 0;
    }

    private IInventory getWasteInventory() {
        IInventoryAdapter inventory = this.getInternalInventory();
        if (inventory == null) {
            return null;
        }
        return new InventoryMapper((IInventory)inventory, 1, 4);
    }

    private void dumpStash() {
        IInventory wasteInventory = this.getWasteInventory();
        if (wasteInventory == null) {
            return;
        }
        if (!InvTools.moveOneItemToPipe(wasteInventory, this.tileCache)) {
            InvTools.moveItemStack(wasteInventory, this.inventoryCache.getAdjacentInventories());
        }
    }

    @Override
    public boolean isBurning() {
        return this.mayBurn() && this.burnTime > 0;
    }

    @Override
    public int getBurnTimeRemainingScaled(int i) {
        if (this.totalBurnTime == 0) {
            return 0;
        }
        return this.burnTime * i / this.totalBurnTime;
    }

    @Override
    public boolean hasFuelMin(float percentage) {
        int fuelSlot = this.getFuelSlot();
        if (fuelSlot < 0) {
            return false;
        }
        IInventoryAdapter inventory = this.getInternalInventory();
        return (float)inventory.func_70301_a((int)fuelSlot).field_77994_a / (float)inventory.func_70301_a(fuelSlot).func_77976_d() > percentage;
    }

    @Override
    public void func_145839_a(NBTTagCompound nbttagcompound) {
        super.func_145839_a(nbttagcompound);
        String fuelItemName = nbttagcompound.func_74779_i("EngineFuelItem");
        if (!fuelItemName.isEmpty()) {
            this.fuelItem = (Item)GameData.getItemRegistry().getRaw(fuelItemName);
        }
        this.fuelItemMeta = nbttagcompound.func_74762_e("EngineFuelMeta");
        this.burnTime = nbttagcompound.func_74762_e("EngineBurnTime");
        this.totalBurnTime = nbttagcompound.func_74762_e("EngineTotalTime");
        if (nbttagcompound.func_74764_b("AshProduction")) {
            this.ashProduction = nbttagcompound.func_74762_e("AshProduction");
        }
    }

    @Override
    public void func_145841_b(NBTTagCompound nbttagcompound) {
        super.func_145841_b(nbttagcompound);
        if (this.fuelItem != null) {
            nbttagcompound.func_74778_a("EngineFuelItem", GameData.getItemRegistry().func_148750_c((Object)this.fuelItem));
        }
        nbttagcompound.func_74768_a("EngineFuelMeta", this.fuelItemMeta);
        nbttagcompound.func_74768_a("EngineBurnTime", this.burnTime);
        nbttagcompound.func_74768_a("EngineTotalTime", this.totalBurnTime);
        nbttagcompound.func_74768_a("AshProduction", this.ashProduction);
    }

    @Override
    public void getGUINetworkData(int i, int j) {
        switch (i) {
            case 0: {
                this.burnTime = j;
                break;
            }
            case 1: {
                this.totalBurnTime = j;
                break;
            }
            case 2: {
                this.currentOutput = j;
                break;
            }
            case 3: {
                this.energyManager.fromPacketInt(j);
                break;
            }
            case 4: {
                this.heat = j;
            }
        }
    }

    @Override
    public void sendGUINetworkData(Container containerEngine, ICrafting iCrafting) {
        iCrafting.func_71112_a(containerEngine, 0, this.burnTime);
        iCrafting.func_71112_a(containerEngine, 1, this.totalBurnTime);
        iCrafting.func_71112_a(containerEngine, 2, this.currentOutput);
        iCrafting.func_71112_a(containerEngine, 3, this.energyManager.toPacketInt());
        iCrafting.func_71112_a(containerEngine, 4, this.heat);
    }

    @Override
    @Optional.Method(modid="BuildCraftAPI|statements")
    public Collection<ITriggerExternal> getExternalTriggers(ForgeDirection side, TileEntity tile) {
        LinkedList<ITriggerExternal> res = new LinkedList<ITriggerExternal>();
        res.add(FactoryTriggers.lowFuel25);
        res.add(FactoryTriggers.lowFuel10);
        return res;
    }
}

