/*
 * Decompiled with CFR 0.152.
 */
package forestry.energy.gadgets;

import forestry.api.core.ForestryAPI;
import forestry.api.fuels.EngineBronzeFuel;
import forestry.api.fuels.FuelManager;
import forestry.core.EnumErrorCode;
import forestry.core.config.Config;
import forestry.core.fluids.FluidHelper;
import forestry.core.fluids.Fluids;
import forestry.core.fluids.TankManager;
import forestry.core.fluids.tanks.FilteredTank;
import forestry.core.fluids.tanks.StandardTank;
import forestry.core.gadgets.Engine;
import forestry.core.gadgets.TileBase;
import forestry.core.interfaces.ILiquidTankContainer;
import forestry.core.inventory.IInventoryAdapter;
import forestry.core.inventory.TileInventoryAdapter;
import forestry.core.network.GuiId;
import forestry.core.network.PacketPayload;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.ICrafting;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidContainerRegistry;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTankInfo;

public class EngineBronze
extends Engine
implements ISidedInventory,
ILiquidTankContainer {
    public static final short SLOT_CAN = 0;
    private final FilteredTank fuelTank;
    private final FilteredTank heatingTank;
    private final TankManager tankManager;
    public int burnTime;
    public int totalTime;
    public int currentFluidId = -1;
    private boolean shutdown;

    @Override
    public PacketPayload getPacketPayload() {
        PacketPayload payload = super.getPacketPayload();
        if (this.shutdown) {
            payload.append(new int[]{1});
        } else {
            payload.append(new int[]{0});
        }
        return payload;
    }

    @Override
    public void fromPacketPayload(PacketPayload payload) {
        super.fromPacketPayload(payload);
        this.shutdown = payload.intPayload[3] > 0;
    }

    public EngineBronze() {
        super(10000, 300000, 5000);
        this.setHints(Config.hints.get("engine.bronze"));
        this.setInternalInventory(new TileInventoryAdapter(this, 1, "Items"){

            @Override
            public boolean canSlotAccept(int slotIndex, ItemStack itemStack) {
                if (slotIndex == 0) {
                    Fluid fluid = FluidHelper.getFluidInContainer(itemStack);
                    return EngineBronze.this.tankManager.accepts(fluid);
                }
                return false;
            }
        });
        this.fuelTank = new FilteredTank(10000, FuelManager.bronzeEngineFuel.keySet());
        this.fuelTank.tankMode = StandardTank.TankMode.INPUT;
        this.heatingTank = new FilteredTank(10000, FluidRegistry.LAVA);
        this.heatingTank.tankMode = StandardTank.TankMode.INPUT;
        this.tankManager = new TankManager(this.fuelTank, this.heatingTank);
    }

    @Override
    public TankManager getTankManager() {
        return this.tankManager;
    }

    @Override
    public void openGui(EntityPlayer player, TileBase tile) {
        player.openGui(ForestryAPI.instance, GuiId.EngineBronzeGUI.ordinal(), player.field_70170_p, this.field_145851_c, this.field_145848_d, this.field_145849_e);
    }

    @Override
    public void updateServerSide() {
        super.updateServerSide();
        if (this.field_145850_b.func_82737_E() % 20L * 10L != 0L) {
            return;
        }
        IInventoryAdapter inventory = this.getInternalInventory();
        if (inventory.func_70301_a(0) != null) {
            FluidHelper.drainContainers(this.tankManager, (IInventory)inventory, 0);
        }
        if (this.getHeatLevel() <= 0.2 && this.heatingTank.getFluidAmount() <= 0) {
            this.setErrorState(EnumErrorCode.NOHEAT);
        } else if (this.burnTime <= 0 && this.fuelTank.getFluidAmount() <= 0) {
            this.setErrorState(EnumErrorCode.NOFUEL);
        } else {
            this.setErrorState(EnumErrorCode.OK);
        }
    }

    @Override
    public void burn() {
        this.currentOutput = 0;
        if (this.isActivated() && (this.fuelTank.getFluidAmount() >= 1000 || this.burnTime > 0)) {
            double heatStage = this.getHeatLevel();
            if (heatStage > 0.25 && this.shutdown) {
                this.shutdown(false);
            } else if (this.shutdown && this.heatingTank.getFluidAmount() > 0 && Fluids.LAVA.is(this.heatingTank.getFluid())) {
                this.addHeat(20);
                this.heatingTank.drain(1, true);
            }
            if (heatStage > 0.2) {
                if (this.burnTime > 0) {
                    --this.burnTime;
                    this.currentOutput = this.determineFuelValue(FluidRegistry.getFluid((int)this.currentFluidId));
                    this.energyManager.generateEnergy(this.currentOutput);
                } else {
                    this.burnTime = this.totalTime = this.determineBurnTime(this.fuelTank.getFluid().getFluid());
                    this.currentFluidId = this.fuelTank.getFluid().getFluid().getID();
                    this.fuelTank.drain(1000, true);
                }
            } else {
                this.shutdown(true);
            }
        }
        if (this.burnTime <= 0) {
            this.currentFluidId = -1;
        }
    }

    private void shutdown(boolean val) {
        this.shutdown = val;
    }

    @Override
    public int dissipateHeat() {
        FluidStack fuelFluidStack;
        EngineBronzeFuel fuel;
        double heatStage;
        if (this.heat <= 0) {
            return 0;
        }
        int loss = 1;
        if (!this.isBurning()) {
            ++loss;
        }
        if ((heatStage = this.getHeatLevel()) > 0.55) {
            ++loss;
        }
        if (this.fuelTank.getFluidAmount() > 0 && (fuel = FuelManager.bronzeEngineFuel.get((fuelFluidStack = this.fuelTank.getFluid()).getFluid())) != null) {
            loss *= fuel.dissipationMultiplier;
        }
        this.heat -= loss;
        return loss;
    }

    @Override
    public int generateHeat() {
        int generate = 0;
        if (this.isActivated() && this.burnTime > 0) {
            double heatStage = this.getHeatLevel();
            if (heatStage >= 0.75) {
                generate += 3;
            } else if (heatStage > 0.24) {
                generate += 2;
            } else if (heatStage > 0.2) {
                ++generate;
            }
        }
        this.heat += generate;
        return generate;
    }

    private int determineFuelValue(Fluid fluid) {
        if (FuelManager.bronzeEngineFuel.containsKey(fluid)) {
            return FuelManager.bronzeEngineFuel.get((Object)fluid).powerPerCycle;
        }
        return 0;
    }

    private int determineBurnTime(Fluid fluid) {
        if (FuelManager.bronzeEngineFuel.containsKey(fluid)) {
            return FuelManager.bronzeEngineFuel.get((Object)fluid).burnDuration;
        }
        return 0;
    }

    protected ItemStack replenishByContainer(ItemStack inventoryStack, FluidContainerRegistry.FluidContainerData container, StandardTank tank) {
        if (container == null) {
            return inventoryStack;
        }
        if (tank.fill(container.fluid, false) >= container.fluid.amount) {
            tank.fill(container.fluid, true);
            if (container.filledContainer != null && container.filledContainer.func_77973_b().hasContainerItem(container.filledContainer)) {
                inventoryStack = container.emptyContainer.func_77946_l();
            } else {
                --inventoryStack.field_77994_a;
            }
        }
        return inventoryStack;
    }

    @Override
    public boolean isBurning() {
        return this.mayBurn() && this.burnTime > 0;
    }

    @Override
    public int getBurnTimeRemainingScaled(int i) {
        if (this.totalTime == 0) {
            return 0;
        }
        return this.burnTime * i / this.totalTime;
    }

    public int getOperatingTemperatureScaled(int i) {
        return (int)Math.round((double)(this.heat * i) / ((double)this.maxHeat * 0.2));
    }

    public int getFuelScaled(int i) {
        return this.fuelTank.getFluidAmount() * i / 10000;
    }

    public int getHeatingFuelScaled(int i) {
        return this.heatingTank.getFluidAmount() * i / 10000;
    }

    @Override
    public void func_145839_a(NBTTagCompound nbt) {
        Fluid fluid;
        super.func_145839_a(nbt);
        this.burnTime = nbt.func_74762_e("EngineBurnTime");
        this.totalTime = nbt.func_74762_e("EngineTotalTime");
        if (nbt.func_74764_b("currentFluid") && (fluid = FluidRegistry.getFluid((String)nbt.func_74779_i("currentFluid"))) != null) {
            this.currentFluidId = fluid.getID();
        }
        this.tankManager.readTanksFromNBT(nbt);
    }

    @Override
    public void func_145841_b(NBTTagCompound nbt) {
        super.func_145841_b(nbt);
        nbt.func_74768_a("EngineBurnTime", this.burnTime);
        nbt.func_74768_a("EngineTotalTime", this.totalTime);
        Fluid fluid = FluidRegistry.getFluid((int)this.currentFluidId);
        if (fluid != null) {
            nbt.func_74778_a("currentFluid", fluid.getName());
        }
        this.tankManager.writeTanksToNBT(nbt);
    }

    @Override
    public void getGUINetworkData(int id, int data) {
        switch (id -= this.tankManager.maxMessageId() + 1) {
            case 0: {
                this.burnTime = data;
                break;
            }
            case 1: {
                this.totalTime = data;
                break;
            }
            case 2: {
                this.currentOutput = data;
                break;
            }
            case 3: {
                this.energyManager.fromPacketInt(data);
                break;
            }
            case 4: {
                this.heat = data;
                break;
            }
            case 5: {
                this.currentFluidId = data;
            }
        }
    }

    @Override
    public void sendGUINetworkData(Container containerEngine, ICrafting iCrafting) {
        int i = this.tankManager.maxMessageId() + 1;
        iCrafting.func_71112_a(containerEngine, i, this.burnTime);
        iCrafting.func_71112_a(containerEngine, i + 1, this.totalTime);
        iCrafting.func_71112_a(containerEngine, i + 2, this.currentOutput);
        iCrafting.func_71112_a(containerEngine, i + 3, this.energyManager.toPacketInt());
        iCrafting.func_71112_a(containerEngine, i + 4, this.heat);
        iCrafting.func_71112_a(containerEngine, i + 5, this.currentFluidId);
    }

    public int fill(ForgeDirection from, FluidStack resource, boolean doFill) {
        return this.tankManager.fill(from, resource, doFill);
    }

    public FluidStack drain(ForgeDirection from, FluidStack resource, boolean doDrain) {
        return this.tankManager.drain(from, resource, doDrain);
    }

    public FluidStack drain(ForgeDirection from, int maxDrain, boolean doDrain) {
        return this.tankManager.drain(from, maxDrain, doDrain);
    }

    public boolean canFill(ForgeDirection from, Fluid fluid) {
        return this.tankManager.canFill(from, fluid);
    }

    public boolean canDrain(ForgeDirection from, Fluid fluid) {
        return this.tankManager.canDrain(from, fluid);
    }

    public FluidTankInfo[] getTankInfo(ForgeDirection from) {
        return this.tankManager.getTankInfo(from);
    }
}

