/*
 * Decompiled with CFR 0.152.
 */
package forestry.energy;

import cofh.api.energy.EnergyStorage;
import cofh.api.energy.IEnergyHandler;
import cofh.api.energy.IEnergyReceiver;
import forestry.core.GameMode;
import forestry.core.utils.BlockUtil;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.util.ForgeDirection;

public class EnergyManager
implements IEnergyHandler {
    private final int energyPerWork;
    private final EnergyStorage energyStorage;
    private EnergyTransferMode mode = EnergyTransferMode.BOTH;

    public EnergyManager(int maxTransfer, int energyPerWork, int capacity) {
        this.energyPerWork = EnergyManager.scaleForDifficulty(energyPerWork);
        this.energyStorage = new EnergyStorage(EnergyManager.scaleForDifficulty(capacity), EnergyManager.scaleForDifficulty(maxTransfer), EnergyManager.scaleForDifficulty(maxTransfer));
    }

    private static int scaleForDifficulty(int energyPerUse) {
        return Math.round((float)energyPerUse * GameMode.getGameMode().getFloatSetting("energy.demand.modifier"));
    }

    public void setExtractOnly() {
        this.mode = EnergyTransferMode.EXTRACT;
    }

    public void setReceiveOnly() {
        this.mode = EnergyTransferMode.RECEIVE;
    }

    private boolean canExtract() {
        switch (this.mode) {
            case EXTRACT: 
            case BOTH: {
                return true;
            }
        }
        return false;
    }

    private boolean canReceive() {
        switch (this.mode) {
            case BOTH: 
            case RECEIVE: {
                return true;
            }
        }
        return false;
    }

    public EnergyManager readFromNBT(NBTTagCompound nbt) {
        NBTTagCompound energyManagerNBT = nbt.func_74775_l("EnergyManager");
        NBTTagCompound energyStorageNBT = energyManagerNBT.func_74775_l("EnergyStorage");
        this.energyStorage.readFromNBT(energyStorageNBT);
        return this;
    }

    public NBTTagCompound writeToNBT(NBTTagCompound nbt) {
        NBTTagCompound energyStorageNBT = new NBTTagCompound();
        this.energyStorage.writeToNBT(energyStorageNBT);
        NBTTagCompound energyManagerNBT = new NBTTagCompound();
        energyManagerNBT.func_74782_a("EnergyStorage", (NBTBase)energyStorageNBT);
        nbt.func_74782_a("EnergyManager", (NBTBase)energyManagerNBT);
        return nbt;
    }

    public int toPacketInt() {
        return this.energyStorage.getEnergyStored();
    }

    public void fromPacketInt(int packetInt) {
        this.energyStorage.setEnergyStored(packetInt);
    }

    @Override
    public int receiveEnergy(ForgeDirection from, int maxReceive, boolean simulate) {
        if (!this.canReceive()) {
            return 0;
        }
        return this.energyStorage.receiveEnergy(maxReceive, simulate);
    }

    @Override
    public int extractEnergy(ForgeDirection from, int maxExtract, boolean simulate) {
        if (!this.canExtract()) {
            return 0;
        }
        return this.energyStorage.extractEnergy(maxExtract, simulate);
    }

    @Override
    public int getEnergyStored(ForgeDirection from) {
        return this.energyStorage.getEnergyStored();
    }

    public int getTotalEnergyStored() {
        return this.energyStorage.getEnergyStored();
    }

    @Override
    public int getMaxEnergyStored(ForgeDirection from) {
        return this.energyStorage.getMaxEnergyStored();
    }

    public int getMaxEnergyStored() {
        return this.energyStorage.getMaxEnergyStored();
    }

    public int getMaxEnergyReceived() {
        return this.energyStorage.getMaxReceive();
    }

    @Override
    public boolean canConnectEnergy(ForgeDirection from) {
        return true;
    }

    public int getEnergyPerWork() {
        return this.energyPerWork;
    }

    public boolean consumeEnergyToDoWork() {
        if (this.energyStorage.getEnergyStored() < this.energyPerWork) {
            return false;
        }
        this.energyStorage.modifyEnergyStored(-this.energyPerWork);
        return true;
    }

    public int sendEnergy(ForgeDirection orientation, TileEntity tile) {
        return this.sendEnergy(orientation, tile, Integer.MAX_VALUE);
    }

    public int sendEnergy(ForgeDirection orientation, TileEntity tile, int amount) {
        int sent = 0;
        if (BlockUtil.isEnergyReceiver(orientation.getOpposite(), tile)) {
            IEnergyReceiver receptor = (IEnergyReceiver)tile;
            int extractable = this.energyStorage.extractEnergy(amount, true);
            if (extractable > 0) {
                sent = receptor.receiveEnergy(orientation.getOpposite(), extractable, false);
                this.energyStorage.extractEnergy(sent, false);
            }
        }
        return sent;
    }

    public void drainEnergy(int amount) {
        this.energyStorage.modifyEnergyStored(-amount);
    }

    public void generateEnergy(int amount) {
        this.energyStorage.modifyEnergyStored(amount);
    }

    private static enum EnergyTransferMode {
        EXTRACT,
        RECEIVE,
        BOTH;

    }
}

