/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.vect;

import forestry.core.vect.IVect;
import forestry.core.vect.Vect;

public class MutableVect
implements IVect {
    public int x;
    public int y;
    public int z;

    public MutableVect(int x, int y, int z) {
        this.x = x;
        this.y = y;
        this.z = z;
    }

    public MutableVect(IVect vect) {
        this.x = vect.getX();
        this.y = vect.getY();
        this.z = vect.getZ();
    }

    @Override
    public MutableVect add(IVect other) {
        this.x += other.getX();
        this.y += other.getY();
        this.z += other.getZ();
        return this;
    }

    @Override
    public MutableVect add(int x, int y, int z) {
        this.x += x;
        this.y += y;
        this.z += z;
        return this;
    }

    public boolean advancePositionInArea(Vect area) {
        if (this.z < area.z - 1) {
            ++this.z;
        } else {
            this.z = 0;
            if (this.x < area.x - 1) {
                ++this.x;
            } else {
                this.x = 0;
                if (this.y < area.y - 1) {
                    ++this.y;
                } else {
                    return false;
                }
            }
        }
        return true;
    }

    @Override
    public int getX() {
        return this.x;
    }

    @Override
    public int getY() {
        return this.y;
    }

    @Override
    public int getZ() {
        return this.z;
    }
}

