/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.utils;

import buildcraft.api.tools.IToolWrench;
import cpw.mods.fml.common.registry.EntityRegistry;
import forestry.api.core.ForestryAPI;
import forestry.api.core.ITileStructure;
import forestry.core.gadgets.TileForestry;
import forestry.core.proxy.Proxies;
import forestry.core.utils.EnumTankLevel;
import forestry.core.utils.StackUtils;
import forestry.core.vect.Vect;
import java.security.MessageDigest;
import java.security.cert.Certificate;
import java.util.Arrays;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.InventoryLargeChest;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityChest;
import net.minecraft.util.MathHelper;
import net.minecraft.world.World;
import net.minecraft.world.biome.BiomeGenBase;

public class Utils {
    private static Random rand;
    private static final String HEX = "0123456789abcdef";

    public static int getUID() {
        if (rand == null) {
            rand = new Random();
        }
        return rand.nextInt();
    }

    public static void dropInventory(TileForestry tile, World world, int x, int y, int z) {
        block6: {
            block5: {
                if (tile == null) {
                    return;
                }
                if (!(tile instanceof ITileStructure)) break block5;
                IInventory inventory = ((ITileStructure)((Object)tile)).getInventory();
                if (inventory == null) break block6;
                for (int i = 0; i < inventory.func_70302_i_(); ++i) {
                    if (inventory.func_70301_a(i) == null) continue;
                    StackUtils.dropItemStackAsEntity(inventory.func_70301_a(i), world, x, y, z);
                    inventory.func_70299_a(i, null);
                }
                break block6;
            }
            for (int slot = 0; slot < tile.func_70302_i_(); ++slot) {
                ItemStack itemstack = tile.func_70301_a(slot);
                if (itemstack == null) continue;
                float f = world.field_73012_v.nextFloat() * 0.8f + 0.1f;
                float f1 = world.field_73012_v.nextFloat() * 0.8f + 0.1f;
                float f2 = world.field_73012_v.nextFloat() * 0.8f + 0.1f;
                while (itemstack.field_77994_a > 0) {
                    int stackPartial = world.field_73012_v.nextInt(21) + 10;
                    if (stackPartial > itemstack.field_77994_a) {
                        stackPartial = itemstack.field_77994_a;
                    }
                    ItemStack drop = itemstack.func_77979_a(stackPartial);
                    EntityItem entityitem = new EntityItem(world, (double)((float)x + f), (double)((float)y + f1), (double)((float)z + f2), drop);
                    float accel = 0.05f;
                    entityitem.field_70159_w = (float)world.field_73012_v.nextGaussian() * accel;
                    entityitem.field_70181_x = (float)world.field_73012_v.nextGaussian() * accel + 0.2f;
                    entityitem.field_70179_y = (float)world.field_73012_v.nextGaussian() * accel;
                    world.func_72838_d((Entity)entityitem);
                }
                tile.func_70299_a(slot, null);
            }
        }
    }

    public static IInventory getChest(IInventory inventory) {
        Vect[] adjacent;
        if (!(inventory instanceof TileEntityChest)) {
            return inventory;
        }
        TileEntityChest chest = (TileEntityChest)inventory;
        for (Vect pos : adjacent = new Vect[]{new Vect(chest.field_145851_c + 1, chest.field_145848_d, chest.field_145849_e), new Vect(chest.field_145851_c - 1, chest.field_145848_d, chest.field_145849_e), new Vect(chest.field_145851_c, chest.field_145848_d, chest.field_145849_e + 1), new Vect(chest.field_145851_c, chest.field_145848_d, chest.field_145849_e - 1)}) {
            TileEntity otherchest = chest.func_145831_w().func_147438_o(pos.x, pos.y, pos.z);
            if (!(otherchest instanceof TileEntityChest)) continue;
            return new InventoryLargeChest("", (IInventory)chest, (IInventory)((TileEntityChest)otherchest));
        }
        return inventory;
    }

    public static <T> T[] concat(T[] first, T[] second) {
        T[] result = Arrays.copyOf(first, first.length + second.length);
        System.arraycopy(second, 0, result, first.length, second.length);
        return result;
    }

    public static int[] concat(int[] first, int[] second) {
        int[] result = Arrays.copyOf(first, first.length + second.length);
        System.arraycopy(second, 0, result, first.length, second.length);
        return result;
    }

    public static short[] concat(short[] first, short[] second) {
        short[] result = Arrays.copyOf(first, first.length + second.length);
        System.arraycopy(second, 0, result, first.length, second.length);
        return result;
    }

    public static float[] concat(float[] first, float[] second) {
        float[] result = Arrays.copyOf(first, first.length + second.length);
        System.arraycopy(second, 0, result, first.length, second.length);
        return result;
    }

    public static boolean canWrench(EntityPlayer player, int x, int y, int z) {
        ItemStack itemstack = player.func_71045_bC();
        if (itemstack == null) {
            return false;
        }
        if (!(itemstack.func_77973_b() instanceof IToolWrench)) {
            return false;
        }
        IToolWrench wrench = (IToolWrench)itemstack.func_77973_b();
        return wrench.canWrench(player, x, y, z);
    }

    public static void useWrench(EntityPlayer player, int x, int y, int z) {
        ItemStack itemstack = player.func_71045_bC();
        if (itemstack == null) {
            return;
        }
        if (!(itemstack.func_77973_b() instanceof IToolWrench)) {
            return;
        }
        ((IToolWrench)itemstack.func_77973_b()).wrenchUsed(player, x, y, z);
    }

    public static EnumTankLevel rateTankLevel(int scaled) {
        if (scaled < 5) {
            return EnumTankLevel.EMPTY;
        }
        if (scaled < 30) {
            return EnumTankLevel.LOW;
        }
        if (scaled < 60) {
            return EnumTankLevel.MEDIUM;
        }
        if (scaled < 90) {
            return EnumTankLevel.HIGH;
        }
        return EnumTankLevel.MAXIMUM;
    }

    public static boolean isReplaceableBlock(World world, int x, int y, int z) {
        Block block = world.func_147439_a(x, y, z);
        return Utils.isReplaceableBlock(block);
    }

    public static boolean isReplaceableBlock(Block block) {
        return block == Blocks.field_150395_bd || block == Blocks.field_150329_H || block == Blocks.field_150330_I || block == Blocks.field_150431_aC || block.func_149688_o().func_76222_j();
    }

    public static boolean isLiquidBlock(World world, int x, int y, int z) {
        return Utils.isLiquidBlock(world.func_147439_a(x, y, z));
    }

    public static boolean isLiquidBlock(Block block) {
        return block == Blocks.field_150355_j || block == Blocks.field_150358_i || block == Blocks.field_150353_l || block == Blocks.field_150356_k;
    }

    public static boolean isUseableByPlayer(EntityPlayer player, TileEntity tile) {
        int x = tile.field_145851_c;
        int y = tile.field_145848_d;
        int z = tile.field_145849_e;
        World world = tile.func_145831_w();
        if (tile.func_145837_r()) {
            return false;
        }
        if (world.func_147438_o(x, y, z) != tile) {
            return false;
        }
        return player.func_70092_e((double)x + 0.5, (double)y + 0.5, (double)z + 0.5) <= 64.0;
    }

    public static BiomeGenBase getBiomeAt(World world, int x, int z) {
        return world.getBiomeGenForCoordsBody(x, z);
    }

    public static Entity spawnEntity(World world, Class<? extends Entity> entityClass, double x, double y, double z) {
        if (!EntityList.field_75626_c.containsKey(entityClass)) {
            return null;
        }
        return Utils.spawnEntity(world, EntityList.func_75620_a((String)((String)EntityList.field_75626_c.get(entityClass)), (World)world), x, y, z);
    }

    public static Entity spawnEntity(World world, Entity spawn, double x, double y, double z) {
        if (spawn != null && spawn instanceof EntityLiving) {
            EntityLiving living = (EntityLiving)spawn;
            spawn.func_70012_b(x, y, z, MathHelper.func_76142_g((float)(world.field_73012_v.nextFloat() * 360.0f)), 0.0f);
            living.field_70759_as = living.field_70177_z;
            living.field_70761_aq = living.field_70177_z;
            living.func_110161_a(null);
            world.func_72838_d(spawn);
            living.func_70642_aH();
        }
        return spawn;
    }

    public static void registerEntity(Class<? extends Entity> entityClass, String ident, int id, int eggForeground, int eggBackground, int trackingRange, int updateFrequency, boolean sendVelocity) {
        EntityRegistry.registerModEntity(entityClass, (String)ident, (int)id, (Object)ForestryAPI.instance, (int)trackingRange, (int)updateFrequency, (boolean)sendVelocity);
        Proxies.log.finer("Registered entity %s (%s) with id %s.", ident, entityClass.toString(), id);
    }

    public static int addRGBComponents(int colour, int r, int g, int b) {
        r = ((colour & 0xFF0000) >> 16) + r;
        g = ((colour & 0xFF00) >> 8) + g;
        b = (colour & 0xFF) + b;
        r = r <= 255 ? r : 255;
        g = g <= 255 ? g : 255;
        b = b <= 255 ? b : 255;
        return (r & 0xFF) << 16 | (g & 0xFF) << 8 | b & 0xFF;
    }

    public static int multiplyRGBComponents(int colour, float factor) {
        int r = (int)((float)((colour & 0xFF0000) >> 16) * factor);
        int g = (int)((float)((colour & 0xFF00) >> 8) * factor);
        int b = (int)((float)(colour & 0xFF) * factor);
        r = r <= 255 ? r : 255;
        g = g <= 255 ? g : 255;
        b = b <= 255 ? b : 255;
        return (r & 0xFF) << 16 | (g & 0xFF) << 8 | b & 0xFF;
    }

    public static String getFingerprint(Certificate certificate) {
        if (certificate == null) {
            return "Certificate invalid";
        }
        try {
            MessageDigest md = MessageDigest.getInstance("SHA-1");
            byte[] der = certificate.getEncoded();
            md.update(der);
            byte[] digest = md.digest();
            return Utils.tohex(digest);
        }
        catch (Exception ex) {
            return null;
        }
    }

    private static String tohex(byte[] checksum) {
        StringBuilder hex = new StringBuilder(2 * checksum.length);
        for (byte bty : checksum) {
            hex.append(HEX.charAt((bty & 0xF0) >> 4)).append(HEX.charAt(bty & 0xF));
        }
        return hex.toString();
    }
}

