/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.utils;

import java.util.IllegalFormatException;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.StatCollector;

public class StringUtil {
    public static boolean canTranslate(String key) {
        return StatCollector.func_94522_b((String)("for." + key));
    }

    public static boolean canTranslateTile(String key) {
        return StatCollector.func_94522_b((String)("tile.for." + key));
    }

    public static String localize(String key) {
        return StatCollector.func_74838_a((String)("for." + key)).replace("\\n", "\n").replace("@", "%").replace("\\%", "@");
    }

    public static String localizeTile(String key) {
        return StatCollector.func_74838_a((String)("tile.for." + key)).replace("\\n", "\n").replace("@", "%").replace("\\%", "@");
    }

    public static String localizeAndFormat(String key, Object ... args) {
        return StringUtil.localizeAndFormatRaw("for." + key, args);
    }

    public static String localizeAndFormatRaw(String key, Object ... args) {
        String text = StatCollector.func_74838_a((String)key).replace("\\n", "\n").replace("@", "%").replace("\\%", "@");
        try {
            return String.format(text, args);
        }
        catch (IllegalFormatException ex) {
            return "Format error: " + text;
        }
    }

    public static String cleanTags(String tag) {
        return tag.replaceAll("[Ff]orestry\\p{Punct}", "").replaceAll("\\.[Ff]or\\p{Punct}", ".").replaceFirst("^tile\\.", "").replaceFirst("^item\\.", "");
    }

    public static String cleanItemName(ItemStack stack) {
        return StringUtil.cleanTags(stack.func_77977_a());
    }

    public static String cleanItemName(Item item) {
        return StringUtil.cleanTags(item.func_77658_a());
    }

    public static String cleanBlockName(Block block) {
        return StringUtil.cleanTags(block.func_149739_a());
    }

    public static String capitalize(String s) {
        if (s.length() == 0) {
            return s;
        }
        return s.substring(0, 1).toUpperCase() + s.substring(1).toLowerCase();
    }

    public static String append(String delim, String source, String appendix) {
        if (source.length() <= 0) {
            return appendix;
        }
        if (appendix.length() <= 0) {
            return source;
        }
        return source + delim + appendix;
    }

    public static String readableBoolean(boolean flag, String trueStr, String falseStr) {
        if (flag) {
            return trueStr;
        }
        return falseStr;
    }

    public static String floatAsPercent(float val) {
        return (int)(val * 100.0f) + " %";
    }

    public static String line(int length) {
        StringBuilder line = new StringBuilder();
        for (int i = 0; i < length; ++i) {
            line.append("-");
        }
        return line.toString();
    }
}

