/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.network;

import forestry.core.network.PacketCoordinates;
import forestry.core.network.PacketPayload;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;

public class PacketUpdate
extends PacketCoordinates {
    public PacketPayload payload;

    public PacketUpdate() {
    }

    public PacketUpdate(int id) {
        this(id, (PacketPayload)null);
    }

    public PacketUpdate(int id, PacketPayload payload) {
        this(id, 0, 0, 0, payload);
    }

    public PacketUpdate(int id, int posX, int posY, int posZ, PacketPayload payload) {
        super(id, posX, posY, posZ);
        this.payload = payload;
    }

    public PacketUpdate(int id, int posX, int posY, int posZ, short val) {
        super(id, posX, posY, posZ);
        this.payload = new PacketPayload(0, 1);
        this.payload.shortPayload[0] = val;
    }

    public PacketUpdate(int id, int posX, int posY, int posZ, int val) {
        super(id, posX, posY, posZ);
        this.payload = new PacketPayload(1, 0);
        this.payload.intPayload[0] = val;
    }

    @Override
    public void writeData(DataOutputStream data) throws IOException {
        super.writeData(data);
        if (this.payload == null) {
            data.writeInt(0);
            data.writeInt(0);
            data.writeInt(0);
            data.writeInt(0);
            return;
        }
        data.writeInt(this.payload.intPayload.length);
        data.writeInt(this.payload.shortPayload.length);
        data.writeInt(this.payload.floatPayload.length);
        data.writeInt(this.payload.stringPayload.length);
        for (int intData : this.payload.intPayload) {
            data.writeInt(intData);
        }
        for (short shortData : this.payload.shortPayload) {
            data.writeShort(shortData);
        }
        for (float floatData : this.payload.floatPayload) {
            data.writeFloat(floatData);
        }
        for (String stringData : this.payload.stringPayload) {
            data.writeUTF(stringData);
        }
    }

    @Override
    public void readData(DataInputStream data) throws IOException {
        int i;
        super.readData(data);
        this.payload = new PacketPayload();
        this.payload.intPayload = new int[data.readInt()];
        this.payload.shortPayload = new short[data.readInt()];
        this.payload.floatPayload = new float[data.readInt()];
        this.payload.stringPayload = new String[data.readInt()];
        for (i = 0; i < this.payload.intPayload.length; ++i) {
            this.payload.intPayload[i] = data.readInt();
        }
        for (i = 0; i < this.payload.shortPayload.length; ++i) {
            this.payload.shortPayload[i] = data.readShort();
        }
        for (i = 0; i < this.payload.floatPayload.length; ++i) {
            this.payload.floatPayload[i] = data.readFloat();
        }
        for (i = 0; i < this.payload.stringPayload.length; ++i) {
            this.payload.stringPayload[i] = data.readUTF();
        }
    }
}

