/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.network;

import com.mojang.authlib.GameProfile;
import forestry.api.core.ErrorStateRegistry;
import forestry.api.core.IErrorState;
import forestry.core.EnumErrorCode;
import forestry.core.gadgets.TileForestry;
import forestry.core.network.PacketUpdate;
import forestry.core.utils.EnumAccess;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.UUID;
import net.minecraftforge.common.util.ForgeDirection;

public class PacketTileUpdate
extends PacketUpdate {
    private ForgeDirection orientation = ForgeDirection.WEST;
    private IErrorState errorState = EnumErrorCode.OK;
    private boolean isOwnable = false;
    private EnumAccess access = EnumAccess.SHARED;
    private GameProfile owner = null;

    public PacketTileUpdate() {
    }

    public PacketTileUpdate(TileForestry tile) {
        super(0, tile.getPacketPayload());
        this.posX = tile.field_145851_c;
        this.posY = tile.field_145848_d;
        this.posZ = tile.field_145849_e;
        this.orientation = tile.getOrientation();
        this.errorState = tile.getErrorState();
        this.isOwnable = tile.isOwnable();
        this.access = tile.getAccess();
        this.owner = tile.getOwnerProfile();
    }

    @Override
    public void writeData(DataOutputStream data) throws IOException {
        super.writeData(data);
        data.writeByte(this.orientation.ordinal());
        data.writeShort(this.errorState.getID());
        if (this.isOwnable) {
            data.writeByte(this.access.ordinal());
            if (this.owner == null) {
                data.writeBoolean(false);
            } else {
                data.writeBoolean(true);
                data.writeLong(this.owner.getId().getMostSignificantBits());
                data.writeLong(this.owner.getId().getLeastSignificantBits());
                data.writeUTF(this.owner.getName());
            }
        } else {
            data.writeInt(-1);
        }
    }

    @Override
    public void readData(DataInputStream data) throws IOException {
        super.readData(data);
        this.orientation = ForgeDirection.getOrientation((int)data.readByte());
        this.errorState = ErrorStateRegistry.getErrorState(data.readShort());
        byte ordinal = data.readByte();
        boolean bl = this.isOwnable = ordinal >= 0;
        if (this.isOwnable) {
            this.access = EnumAccess.values()[ordinal];
            this.owner = data.readBoolean() ? new GameProfile(new UUID(data.readLong(), data.readLong()), data.readUTF()) : null;
        }
    }

    public ForgeDirection getOrientation() {
        return this.orientation;
    }

    public IErrorState getErrorState() {
        return this.errorState;
    }

    public EnumAccess getAccess() {
        return this.access;
    }

    public GameProfile getOwner() {
        return this.owner;
    }
}

