/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.network;

import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.eventhandler.Event;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.network.FMLEventChannel;
import cpw.mods.fml.common.network.FMLNetworkEvent;
import cpw.mods.fml.common.network.NetworkRegistry;
import cpw.mods.fml.common.network.internal.FMLProxyPacket;
import forestry.api.core.ForestryEvent;
import forestry.api.genetics.AlleleManager;
import forestry.api.genetics.IBreedingTracker;
import forestry.api.genetics.ISpeciesRoot;
import forestry.core.circuits.ItemCircuitBoard;
import forestry.core.gadgets.TileForestry;
import forestry.core.gui.ContainerLiquidTanks;
import forestry.core.gui.ContainerSocketed;
import forestry.core.gui.IGuiSelectable;
import forestry.core.interfaces.IPacketHandler;
import forestry.core.interfaces.ISocketable;
import forestry.core.network.ForestryPacket;
import forestry.core.network.ILocatedPacket;
import forestry.core.network.INetworkedEntity;
import forestry.core.network.PacketCoordinates;
import forestry.core.network.PacketFXSignal;
import forestry.core.network.PacketGuiInteger;
import forestry.core.network.PacketInventoryStack;
import forestry.core.network.PacketNBT;
import forestry.core.network.PacketSocketUpdate;
import forestry.core.network.PacketTileNBT;
import forestry.core.network.PacketTileUpdate;
import forestry.core.network.PacketUpdate;
import forestry.core.proxy.Proxies;
import forestry.plugins.PluginManager;
import io.netty.buffer.ByteBufInputStream;
import java.io.DataInputStream;
import java.io.InputStream;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.network.NetHandlerPlayServer;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.MinecraftForge;

public class PacketHandler {
    private final FMLEventChannel channel = NetworkRegistry.INSTANCE.newEventDrivenChannel("FOR");

    public PacketHandler() {
        this.channel.register((Object)this);
    }

    @SubscribeEvent
    public void onPacket(FMLNetworkEvent.ServerCustomPacketEvent event) {
        this.onPacketData((InputStream)new ByteBufInputStream(event.packet.payload()), ((NetHandlerPlayServer)event.handler).field_147369_b);
    }

    @SubscribeEvent
    public void onPacket(FMLNetworkEvent.ClientCustomPacketEvent event) {
        this.onPacketData((InputStream)new ByteBufInputStream(event.packet.payload()), null);
    }

    public void onPacketData(InputStream is, EntityPlayerMP player) {
        DataInputStream data = new DataInputStream(is);
        try {
            byte packetId = data.readByte();
            switch (packetId) {
                case 0: {
                    PacketTileUpdate packetT = new PacketTileUpdate();
                    packetT.readData(data);
                    this.onTileUpdate(packetT);
                    break;
                }
                case 1: {
                    PacketUpdate packetUpdate = new PacketUpdate();
                    packetUpdate.readData(data);
                    this.onTileUpdate(packetUpdate);
                    break;
                }
                case 5: {
                    PacketTileNBT packetN = new PacketTileNBT();
                    packetN.readData(data);
                    this.onTileUpdate(packetN);
                    break;
                }
                case 72: {
                    PacketSocketUpdate packetS = new PacketSocketUpdate();
                    packetS.readData(data);
                    this.onSocketUpdate(packetS);
                    break;
                }
                case 3: {
                    PacketInventoryStack packetQ = new PacketInventoryStack();
                    packetQ.readData(data);
                    this.onInventoryStack(packetQ);
                    break;
                }
                case 4: {
                    PacketFXSignal packetF = new PacketFXSignal();
                    packetF.readData(data);
                    packetF.executeFX();
                    break;
                }
                case 40: {
                    PacketUpdate packetU = new PacketUpdate();
                    packetU.readData(data);
                    this.onPipetteClick(packetU, player);
                    break;
                }
                case 71: {
                    PacketUpdate packetU = new PacketUpdate();
                    packetU.readData(data);
                    this.onSolderingIronClick(packetU, (EntityPlayer)player);
                    break;
                }
                case 70: {
                    PacketUpdate packetU = new PacketUpdate();
                    packetU.readData(data);
                    this.onChipsetClick(packetU, (EntityPlayer)player);
                    break;
                }
                case 50: {
                    PacketCoordinates packetC = new PacketCoordinates();
                    packetC.readData(data);
                    this.onAccessSwitch(packetC, (EntityPlayer)player);
                    break;
                }
                case 32: {
                    PacketUpdate packetI = new PacketUpdate();
                    packetI.readData(data);
                    this.onGuiSelection(packetI);
                    break;
                }
                case 30: {
                    PacketUpdate packetZ = new PacketUpdate();
                    packetZ.readData(data);
                    this.onGuiChange((EntityPlayer)player, packetZ);
                    break;
                }
                case 60: {
                    PacketNBT packetTR = new PacketNBT();
                    packetTR.readData(data);
                    this.onGenomeTrackerUpdate(packetTR);
                    break;
                }
                case 92: {
                    PacketGuiInteger packet = new PacketGuiInteger();
                    packet.readData(data);
                    break;
                }
                default: {
                    for (IPacketHandler handler : PluginManager.packetHandlers) {
                        handler.onPacketData(packetId, data, (EntityPlayer)player);
                    }
                    break;
                }
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public void sendPacket(FMLProxyPacket packet) {
        if (FMLCommonHandler.instance().getEffectiveSide().isClient()) {
            this.channel.sendToServer(packet);
        } else {
            this.channel.sendToAll(packet);
        }
    }

    public void sendPacket(FMLProxyPacket packet, EntityPlayerMP player) {
        this.channel.sendTo(packet, player);
    }

    private void onGenomeTrackerUpdate(PacketNBT packet) {
        assert (FMLCommonHandler.instance().getEffectiveSide().isClient());
        EntityPlayer player = Proxies.common.getPlayer();
        IBreedingTracker tracker = null;
        String type = packet.getTagCompound().func_74779_i("TYPE");
        ISpeciesRoot root = AlleleManager.alleleRegistry.getSpeciesRoot(type);
        if (root != null) {
            tracker = root.getBreedingTracker(Proxies.common.getRenderWorld(), player.func_146103_bH());
        }
        if (tracker != null) {
            tracker.decodeFromNBT(packet.getTagCompound());
            MinecraftForge.EVENT_BUS.post((Event)new ForestryEvent.SyncedBreedingTracker(tracker, player));
        }
    }

    private void onGuiChange(EntityPlayer player, PacketUpdate packet) {
        assert (FMLCommonHandler.instance().getEffectiveSide().isServer());
        if (!(player.field_71070_bA instanceof IGuiSelectable)) {
            return;
        }
        ((IGuiSelectable)player.field_71070_bA).handleSelectionChange(player, packet);
    }

    private void onGuiSelection(PacketUpdate packet) {
        assert (FMLCommonHandler.instance().getEffectiveSide().isClient());
        EntityPlayer player = Proxies.common.getPlayer();
        Container container = player.field_71070_bA;
        if (!(container instanceof IGuiSelectable)) {
            return;
        }
        ((IGuiSelectable)container).setSelection(packet);
    }

    private void onSocketUpdate(PacketSocketUpdate packet) {
        assert (FMLCommonHandler.instance().getEffectiveSide().isClient());
        TileEntity tile = Proxies.common.getRenderWorld().func_147438_o(packet.posX, packet.posY, packet.posZ);
        if (!(tile instanceof ISocketable)) {
            return;
        }
        ISocketable socketable = (ISocketable)tile;
        for (int i = 0; i < packet.itemstacks.length; ++i) {
            socketable.setSocket(i, packet.itemstacks[i]);
        }
    }

    private void onTileUpdate(ForestryPacket packet) {
        TileEntity tile = ((ILocatedPacket)((Object)packet)).getTarget(Proxies.common.getRenderWorld());
        if (tile instanceof INetworkedEntity) {
            ((INetworkedEntity)tile).fromPacket(packet);
        }
    }

    private void onInventoryStack(PacketInventoryStack packet) {
        TileEntity tile = Proxies.common.getRenderWorld().func_147438_o(packet.posX, packet.posY, packet.posZ);
        if (tile == null) {
            return;
        }
        if (tile instanceof IInventory) {
            ((IInventory)tile).func_70299_a(packet.slotIndex, packet.itemstack);
        }
    }

    private void onChipsetClick(PacketUpdate packet, EntityPlayer player) {
        assert (FMLCommonHandler.instance().getEffectiveSide().isServer());
        if (!(player.field_71070_bA instanceof ContainerSocketed)) {
            return;
        }
        ItemStack itemstack = player.field_71071_by.func_70445_o();
        if (!(itemstack.func_77973_b() instanceof ItemCircuitBoard)) {
            return;
        }
        ((ContainerSocketed)player.field_71070_bA).handleChipsetClick(packet.payload.intPayload[0], player, itemstack);
    }

    private void onSolderingIronClick(PacketUpdate packet, EntityPlayer player) {
        assert (FMLCommonHandler.instance().getEffectiveSide().isServer());
        if (!(player.field_71070_bA instanceof ContainerSocketed)) {
            return;
        }
        ItemStack itemstack = player.field_71071_by.func_70445_o();
        ((ContainerSocketed)player.field_71070_bA).handleSolderingIronClick(packet.payload.intPayload[0], player, itemstack);
    }

    private void onAccessSwitch(PacketCoordinates packet, EntityPlayer playerEntity) {
        assert (FMLCommonHandler.instance().getEffectiveSide().isServer());
        TileForestry tile = (TileForestry)playerEntity.field_70170_p.func_147438_o(packet.posX, packet.posY, packet.posZ);
        if (tile == null) {
            return;
        }
        tile.switchAccessRule(playerEntity);
    }

    private void onPipetteClick(PacketUpdate packet, EntityPlayerMP player) {
        assert (FMLCommonHandler.instance().getEffectiveSide().isServer());
        if (!(player.field_71070_bA instanceof ContainerLiquidTanks)) {
            return;
        }
        ((ContainerLiquidTanks)player.field_71070_bA).handlePipetteClick(packet.payload.intPayload[0], player);
    }
}

