/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.inventory;

import forestry.api.core.INBTTagable;
import forestry.core.interfaces.IFilterSlotDelegate;
import forestry.core.utils.StackUtils;
import forestry.core.utils.Utils;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;

public class ItemInventory
implements IInventory,
IFilterSlotDelegate,
INBTTagable {
    public final Class<? extends Item> itemClass;
    public final boolean isItemInventory;
    public ItemStack parent;
    protected ItemStack[] inventoryStacks;

    public ItemInventory(Class<? extends Item> itemClass, int size, ItemStack itemstack) {
        this.itemClass = itemClass;
        this.inventoryStacks = new ItemStack[size];
        this.parent = itemstack;
        this.isItemInventory = true;
        this.setUID(false);
        this.readFromNBT(itemstack.func_77978_p());
    }

    public static int getOccupiedSlotCount(ItemStack itemStack) {
        NBTTagCompound nbt = itemStack.func_77978_p();
        if (nbt == null) {
            return 0;
        }
        int count = 0;
        if (nbt.func_74764_b("Items")) {
            NBTTagList nbttaglist = nbt.func_150295_c("Items", 10);
            for (int i = 0; i < nbttaglist.func_74745_c(); ++i) {
                NBTTagCompound nbttagcompound1 = nbttaglist.func_150305_b(i);
                ItemStack itemStack1 = ItemStack.func_77949_a((NBTTagCompound)nbttagcompound1);
                if (itemStack1 == null || itemStack1.field_77994_a <= 0) continue;
                ++count;
            }
        }
        return count;
    }

    protected void setUID(boolean override) {
        if (this.parent.func_77978_p() == null) {
            this.parent.func_77982_d(new NBTTagCompound());
        }
        NBTTagCompound nbt = this.parent.func_77978_p();
        if (override || !nbt.func_74764_b("UID")) {
            nbt.func_74768_a("UID", Utils.getUID());
        }
    }

    public void onGuiSaved(EntityPlayer player) {
        this.parent = this.findParentInInventory(player);
        if (this.parent != null) {
            this.save();
        }
    }

    public ItemStack findParentInInventory(EntityPlayer player) {
        for (int i = 0; i < player.field_71071_by.func_70302_i_(); ++i) {
            ItemStack stack = player.field_71071_by.func_70301_a(i);
            if (!StackUtils.isIdenticalItem(stack, this.parent)) continue;
            return stack;
        }
        return this.parent;
    }

    public void save() {
        NBTTagCompound nbt = this.parent.func_77978_p();
        if (nbt == null) {
            nbt = new NBTTagCompound();
        }
        this.writeToNBT(nbt);
        this.parent.func_77982_d(nbt);
    }

    @Override
    public void readFromNBT(NBTTagCompound nbt) {
        if (nbt == null) {
            return;
        }
        if (nbt.func_74764_b("Items")) {
            NBTTagList nbttaglist = nbt.func_150295_c("Items", 10);
            this.inventoryStacks = new ItemStack[this.func_70302_i_()];
            for (int i = 0; i < nbttaglist.func_74745_c(); ++i) {
                NBTTagCompound nbttagcompound1 = nbttaglist.func_150305_b(i);
                byte byte0 = nbttagcompound1.func_74771_c("Slot");
                if (byte0 < 0 || byte0 >= this.inventoryStacks.length) continue;
                this.inventoryStacks[byte0] = ItemStack.func_77949_a((NBTTagCompound)nbttagcompound1);
            }
        }
    }

    @Override
    public void writeToNBT(NBTTagCompound nbt) {
        NBTTagList nbttaglist = new NBTTagList();
        for (int i = 0; i < this.inventoryStacks.length; ++i) {
            if (this.inventoryStacks[i] == null) continue;
            NBTTagCompound nbttagcompound1 = new NBTTagCompound();
            nbttagcompound1.func_74774_a("Slot", (byte)i);
            this.inventoryStacks[i].func_77955_b(nbttagcompound1);
            nbttaglist.func_74742_a((NBTBase)nbttagcompound1);
        }
        nbt.func_74782_a("Items", (NBTBase)nbttaglist);
    }

    public ItemStack func_70298_a(int i, int j) {
        if (this.inventoryStacks[i] == null) {
            return null;
        }
        if (this.inventoryStacks[i].field_77994_a <= j) {
            ItemStack product = this.inventoryStacks[i];
            this.inventoryStacks[i] = null;
            return product;
        }
        ItemStack product = this.inventoryStacks[i].func_77979_a(j);
        if (this.inventoryStacks[i].field_77994_a == 0) {
            this.inventoryStacks[i] = null;
        }
        return product;
    }

    public void func_70299_a(int i, ItemStack itemstack) {
        this.inventoryStacks[i] = itemstack;
    }

    public ItemStack func_70301_a(int i) {
        return this.inventoryStacks[i];
    }

    public int func_70302_i_() {
        return this.inventoryStacks.length;
    }

    public String func_145825_b() {
        return "BeeBag";
    }

    public int func_70297_j_() {
        return 64;
    }

    public void func_70296_d() {
    }

    public boolean func_70300_a(EntityPlayer entityplayer) {
        return true;
    }

    public boolean func_145818_k_() {
        return true;
    }

    public boolean func_94041_b(int slotIndex, ItemStack itemStack) {
        return this.canSlotAccept(slotIndex, itemStack);
    }

    @Override
    public boolean canSlotAccept(int slotIndex, ItemStack itemStack) {
        return true;
    }

    @Override
    public boolean isLocked(int slotIndex) {
        return false;
    }

    public void func_70295_k_() {
    }

    public void func_70305_f() {
    }

    public ItemStack func_70304_b(int slot) {
        if (this.inventoryStacks[slot] == null) {
            return null;
        }
        ItemStack toReturn = this.inventoryStacks[slot];
        this.inventoryStacks[slot] = null;
        return toReturn;
    }
}

