/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.gui;

import forestry.core.gui.Ledger;
import forestry.core.gui.LedgerManager;
import forestry.core.interfaces.IHintSource;
import forestry.core.render.TextureManager;
import forestry.core.utils.StringUtil;
import java.util.Random;

public class HintLedger
extends Ledger {
    private final int position;
    private final String[] hints;

    public HintLedger(LedgerManager manager, IHintSource tile) {
        super(manager);
        this.hints = tile.getHints();
        this.maxHeight = 96;
        this.position = new Random().nextInt(this.hints.length);
        this.overlayColor = manager.gui.fontColor.get("ledger.hint.background");
    }

    @Override
    public void draw(int x, int y) {
        this.drawBackground(x, y);
        this.drawIcon(TextureManager.getInstance().getDefault("misc/hint"), x + 3, y + 4);
        if (!this.isFullyOpened()) {
            return;
        }
        this.manager.minecraft.field_71466_p.func_78261_a(StringUtil.localize("gui.didyouknow") + "?", x + 22, y + 8, this.manager.gui.fontColor.get("ledger.hint.header"));
        this.manager.minecraft.field_71466_p.func_78279_b(StringUtil.localize("hints." + this.hints[this.position] + ".desc"), x + 22, y + 20, this.maxWidth - 28, this.manager.gui.fontColor.get("ledger.hint.text"));
    }

    @Override
    public String getTooltip() {
        return StringUtil.localize("hints." + this.hints[this.position] + ".tag");
    }
}

