/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.gui;

import forestry.api.core.IErrorState;
import forestry.core.EnumErrorCode;
import forestry.core.gui.Ledger;
import forestry.core.gui.LedgerManager;
import forestry.core.interfaces.IErrorSource;
import forestry.core.utils.StringUtil;

public class ErrorLedger
extends Ledger {
    private final IErrorSource tile;

    public ErrorLedger(LedgerManager manager, IErrorSource tile) {
        super(manager);
        this.tile = tile;
        this.maxHeight = 72;
        this.overlayColor = manager.gui.fontColor.get("ledger.error.background");
    }

    @Override
    public void draw(int x, int y) {
        IErrorState state = this.tile.getErrorState();
        if (state == EnumErrorCode.OK) {
            return;
        }
        this.drawBackground(x, y);
        this.drawIcon(state.getIcon(), x + 3, y + 4);
        if (this.isFullyOpened()) {
            this.manager.minecraft.field_71466_p.func_78261_a(this.getTooltip(), x + 22, y + 8, this.manager.gui.fontColor.get("ledger.error.header"));
            this.manager.minecraft.field_71466_p.func_78279_b(StringUtil.localize(this.tile.getErrorState().getHelp()), x + 22, y + 20, this.maxWidth - 28, this.manager.gui.fontColor.get("ledger.error.text"));
        }
    }

    @Override
    public boolean isVisible() {
        IErrorState state = this.tile.getErrorState();
        return state != EnumErrorCode.OK;
    }

    @Override
    public String getTooltip() {
        return StringUtil.localize(this.tile.getErrorState().getDescription());
    }
}

