/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.gui;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import forestry.api.core.IToolPipette;
import forestry.core.fluids.tanks.StandardTank;
import forestry.core.gadgets.TileForestry;
import forestry.core.gui.ContainerForestry;
import forestry.core.interfaces.ILiquidTankContainer;
import forestry.core.network.PacketPayload;
import forestry.core.network.PacketUpdate;
import forestry.core.proxy.Proxies;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.inventory.ICrafting;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.FluidStack;

public class ContainerLiquidTanks
extends ContainerForestry {
    private final ILiquidTankContainer tile;

    public <T extends TileForestry> ContainerLiquidTanks(T tile) {
        super(tile);
        this.tile = (ILiquidTankContainer)((Object)tile);
    }

    @SideOnly(value=Side.CLIENT)
    public void handlePipetteClickClient(int slot, EntityPlayer player) {
        ItemStack itemstack = player.field_71071_by.func_70445_o();
        if (itemstack == null || !(itemstack.func_77973_b() instanceof IToolPipette)) {
            return;
        }
        PacketPayload payload = new PacketPayload(1, 0, 0);
        payload.intPayload[0] = slot;
        Proxies.net.sendToServer(new PacketUpdate(40, payload));
    }

    public void handlePipetteClick(int slot, EntityPlayerMP player) {
        ItemStack itemstack = player.field_71071_by.func_70445_o();
        if (itemstack == null) {
            return;
        }
        Item held = itemstack.func_77973_b();
        if (!(held instanceof IToolPipette)) {
            return;
        }
        IToolPipette pipette = (IToolPipette)held;
        StandardTank tank = this.tile.getTankManager().get(slot);
        int liquidAmount = tank.getFluidAmount();
        if (pipette.canPipette(itemstack) && liquidAmount > 0) {
            if (liquidAmount > 0) {
                FluidStack fillAmount = tank.drain(1000, false);
                int filled = pipette.fill(itemstack, fillAmount, true);
                tank.drain(filled, true);
                player.func_71113_k();
            }
        } else {
            FluidStack potential = pipette.drain(itemstack, pipette.getCapacity(itemstack), false);
            if (potential != null) {
                pipette.drain(itemstack, tank.fill(potential, true), true);
                player.func_71113_k();
            }
        }
    }

    public void func_75137_b(int messageId, int data) {
        super.func_75137_b(messageId, data);
        this.tile.getTankManager().processGuiUpdate(messageId, data);
        this.tile.getGUINetworkData(messageId, data);
    }

    public void func_75142_b() {
        super.func_75142_b();
        this.tile.getTankManager().updateGuiData(this, this.field_75149_d);
        for (Object crafter : this.field_75149_d) {
            this.tile.sendGUINetworkData(this, (ICrafting)crafter);
        }
    }

    public void func_75132_a(ICrafting icrafting) {
        super.func_75132_a(icrafting);
        this.tile.getTankManager().initGuiData(this, icrafting);
    }

    public StandardTank getTank(int slot) {
        return this.tile.getTankManager().get(slot);
    }
}

