/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.gui;

import forestry.core.gadgets.TileForestry;
import forestry.core.gui.slots.SlotForestry;
import forestry.core.interfaces.IRestrictedAccess;
import forestry.core.inventory.ItemInventory;
import forestry.core.utils.StackUtils;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;

public class ContainerForestry
extends Container {
    protected final IInventory inventoryAccess;
    protected final IRestrictedAccess restrictedAccess;

    public ContainerForestry(TileForestry tileForestry) {
        this.inventoryAccess = tileForestry;
        this.restrictedAccess = tileForestry;
    }

    public ContainerForestry(ItemInventory itemInventory) {
        this.inventoryAccess = itemInventory;
        this.restrictedAccess = null;
    }

    public ItemStack func_75144_a(int slotIndex, int button, int modifier, EntityPlayer player) {
        Slot slot;
        if (player == null) {
            return null;
        }
        if (this.restrictedAccess != null && !this.restrictedAccess.allowsAlteration(player)) {
            return null;
        }
        Slot slot2 = slot = slotIndex < 0 ? null : (Slot)this.field_75151_b.get(slotIndex);
        if (slot instanceof SlotForestry && ((SlotForestry)slot).isPhantom()) {
            return this.slotClickPhantom(slot, button, modifier, player);
        }
        return super.func_75144_a(slotIndex, button, modifier, player);
    }

    private ItemStack slotClickPhantom(Slot slot, int mouseButton, int modifier, EntityPlayer player) {
        ItemStack stack = null;
        ItemStack stackSlot = slot.func_75211_c();
        if (stackSlot != null) {
            stack = stackSlot.func_77946_l();
        }
        if (mouseButton == 2) {
            this.fillPhantomSlot(slot, null, mouseButton, modifier);
        } else if (mouseButton == 0 || mouseButton == 1) {
            InventoryPlayer playerInv = player.field_71071_by;
            ItemStack stackHeld = playerInv.func_70445_o();
            if (stackSlot == null) {
                if (stackHeld != null && slot.func_75214_a(stackHeld)) {
                    this.fillPhantomSlot(slot, stackHeld, mouseButton, modifier);
                }
            } else if (stackHeld == null) {
                this.adjustPhantomSlot(slot, mouseButton, modifier);
            } else if (slot.func_75214_a(stackHeld)) {
                if (StackUtils.isIdenticalItem(stackSlot, stackHeld)) {
                    this.adjustPhantomSlot(slot, mouseButton, modifier);
                } else {
                    this.fillPhantomSlot(slot, stackHeld, mouseButton, modifier);
                }
            }
        } else if (mouseButton == 5) {
            InventoryPlayer playerInv = player.field_71071_by;
            ItemStack stackHeld = playerInv.func_70445_o();
            if (!slot.func_75216_d()) {
                this.fillPhantomSlot(slot, stackHeld, mouseButton, modifier);
            }
        }
        return stack;
    }

    protected void adjustPhantomSlot(Slot slot, int mouseButton, int modifier) {
        int stackSize;
        if (!((SlotForestry)slot).canAdjustPhantom()) {
            return;
        }
        ItemStack stackSlot = slot.func_75211_c();
        if (modifier == 1) {
            stackSize = mouseButton == 0 ? (stackSlot.field_77994_a + 1) / 2 : stackSlot.field_77994_a * 2;
        } else {
            int n = stackSize = mouseButton == 0 ? stackSlot.field_77994_a - 1 : stackSlot.field_77994_a + 1;
        }
        if (stackSize > slot.func_75219_a()) {
            stackSize = slot.func_75219_a();
        }
        stackSlot.field_77994_a = stackSize;
        if (stackSlot.field_77994_a <= 0) {
            stackSlot = null;
        }
        slot.func_75215_d(stackSlot);
    }

    protected void fillPhantomSlot(Slot slot, ItemStack stackHeld, int mouseButton, int modifier) {
        int stackSize;
        if (!((SlotForestry)slot).canAdjustPhantom()) {
            return;
        }
        if (stackHeld == null) {
            slot.func_75215_d(null);
            return;
        }
        int n = stackSize = mouseButton == 0 ? stackHeld.field_77994_a : 1;
        if (stackSize > slot.func_75219_a()) {
            stackSize = slot.func_75219_a();
        }
        ItemStack phantomStack = stackHeld.func_77946_l();
        phantomStack.field_77994_a = stackSize;
        slot.func_75215_d(phantomStack);
    }

    protected boolean shiftItemStack(ItemStack stackToShift, int start, int end) {
        ItemStack stackInSlot;
        Slot slot;
        int slotIndex;
        boolean changed = false;
        if (stackToShift.func_77985_e()) {
            for (slotIndex = start; stackToShift.field_77994_a > 0 && slotIndex < end; ++slotIndex) {
                slot = (Slot)this.field_75151_b.get(slotIndex);
                stackInSlot = slot.func_75211_c();
                if (stackInSlot == null || !StackUtils.isIdenticalItem(stackInSlot, stackToShift)) continue;
                int resultingStackSize = stackInSlot.field_77994_a + stackToShift.field_77994_a;
                int max = Math.min(stackToShift.func_77976_d(), slot.func_75219_a());
                if (resultingStackSize <= max) {
                    stackToShift.field_77994_a = 0;
                    stackInSlot.field_77994_a = resultingStackSize;
                    slot.func_75218_e();
                    changed = true;
                    continue;
                }
                if (stackInSlot.field_77994_a >= max) continue;
                stackToShift.field_77994_a -= max - stackInSlot.field_77994_a;
                stackInSlot.field_77994_a = max;
                slot.func_75218_e();
                changed = true;
            }
        }
        if (stackToShift.field_77994_a > 0) {
            for (slotIndex = start; stackToShift.field_77994_a > 0 && slotIndex < end; ++slotIndex) {
                slot = (Slot)this.field_75151_b.get(slotIndex);
                stackInSlot = slot.func_75211_c();
                if (stackInSlot != null) continue;
                int max = Math.min(stackToShift.func_77976_d(), slot.func_75219_a());
                stackInSlot = stackToShift.func_77946_l();
                stackInSlot.field_77994_a = Math.min(stackToShift.field_77994_a, max);
                stackToShift.field_77994_a -= stackInSlot.field_77994_a;
                slot.func_75215_d(stackInSlot);
                slot.func_75218_e();
                changed = true;
            }
        }
        return changed;
    }

    private boolean tryShiftItem(ItemStack stackToShift, int numSlots) {
        for (int machineIndex = 0; machineIndex < numSlots - 36; ++machineIndex) {
            SlotForestry slotForestry;
            Slot slot = (Slot)this.field_75151_b.get(machineIndex);
            if (slot instanceof SlotForestry && (!(slotForestry = (SlotForestry)slot).canShift() || slotForestry.isPhantom()) || !slot.func_75214_a(stackToShift) || !this.shiftItemStack(stackToShift, machineIndex, machineIndex + 1)) continue;
            return true;
        }
        return false;
    }

    public ItemStack func_82846_b(EntityPlayer player, int slotIndex) {
        if (player == null) {
            return null;
        }
        if (this.restrictedAccess != null && !this.restrictedAccess.allowsAlteration(player)) {
            return null;
        }
        ItemStack originalStack = null;
        Slot slot = (Slot)this.field_75151_b.get(slotIndex);
        int numSlots = this.field_75151_b.size();
        if (slot != null && slot.func_75216_d()) {
            ItemStack stackInSlot = slot.func_75211_c();
            originalStack = stackInSlot.func_77946_l();
            if ((slotIndex < numSlots - 36 || !this.tryShiftItem(stackInSlot, numSlots)) && (slotIndex >= numSlots - 36 && slotIndex < numSlots - 9 ? !this.shiftItemStack(stackInSlot, numSlots - 9, numSlots) : (slotIndex >= numSlots - 9 && slotIndex < numSlots ? !this.shiftItemStack(stackInSlot, numSlots - 36, numSlots - 9) : !this.shiftItemStack(stackInSlot, numSlots - 36, numSlots)))) {
                return null;
            }
            slot.func_75220_a(stackInSlot, originalStack);
            if (stackInSlot.field_77994_a <= 0) {
                slot.func_75215_d(null);
            } else {
                slot.func_75218_e();
            }
            if (stackInSlot.field_77994_a == originalStack.field_77994_a) {
                return null;
            }
            slot.func_82870_a(player, stackInSlot);
        }
        return originalStack;
    }

    public final boolean func_75145_c(EntityPlayer entityplayer) {
        if (this.inventoryAccess == null) {
            return true;
        }
        return this.inventoryAccess.func_70300_a(entityplayer);
    }
}

