/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.genetics;

import com.google.common.base.Objects;
import forestry.api.arboriculture.EnumTreeChromosome;
import forestry.api.genetics.IAllele;
import forestry.api.genetics.IAlleleSpecies;
import forestry.api.genetics.IChromosome;
import forestry.api.genetics.IChromosomeType;
import forestry.api.genetics.IGenome;
import forestry.core.config.Config;
import forestry.core.genetics.Chromosome;
import forestry.core.proxy.Proxies;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;

public abstract class Genome
implements IGenome {
    private static final String SLOT_TAG = "Slot";
    private IChromosome[] chromosomes;

    public Genome(NBTTagCompound nbttagcompound) {
        this.chromosomes = new Chromosome[this.getDefaultTemplate().length];
        this.readFromNBT(nbttagcompound);
    }

    private IAllele[] getDefaultTemplate() {
        return this.getSpeciesRoot().getDefaultTemplate();
    }

    public Genome(IChromosome[] chromosomes) {
        if (chromosomes.length != this.getDefaultTemplate().length) {
            throw new IllegalArgumentException(String.format("Tried to create a genome for '%s' from an invalid chromosome template.", this.getSpeciesRoot().getUID()));
        }
        this.chromosomes = chromosomes;
    }

    public static Chromosome getChromosome(ItemStack itemStack, IChromosomeType chromosomeType) {
        NBTTagCompound nbtTagCompound = itemStack.func_77978_p();
        if (nbtTagCompound == null) {
            return null;
        }
        NBTTagCompound genome = nbtTagCompound.func_74775_l("Genome");
        if (genome == null) {
            return null;
        }
        NBTTagList chromosomes = genome.func_150295_c("Chromosomes", 10);
        if (chromosomes == null) {
            return null;
        }
        for (int i = 0; i < chromosomes.func_74745_c(); ++i) {
            NBTTagCompound chromosomeTag = chromosomes.func_150305_b(i);
            byte byte0 = chromosomeTag.func_74771_c(SLOT_TAG);
            if (byte0 != chromosomeType.ordinal()) continue;
            return Chromosome.loadChromosomeFromNBT(chromosomeTag);
        }
        return null;
    }

    public static IAllele getActiveAllele(ItemStack itemStack, IChromosomeType chromosomeType) {
        Chromosome chromosome = Genome.getChromosome(itemStack, chromosomeType);
        if (chromosome == null) {
            return null;
        }
        return chromosome.getActiveAllele();
    }

    @Override
    public void readFromNBT(NBTTagCompound nbttagcompound) {
        IChromosome speciesChromosome;
        NBTTagList nbttaglist = nbttagcompound.func_150295_c("Chromosomes", 10);
        this.chromosomes = new Chromosome[this.chromosomes.length];
        Boolean invalidGenome = false;
        for (int i = 0; i < nbttaglist.func_74745_c(); ++i) {
            NBTTagCompound nbttagcompound1 = nbttaglist.func_150305_b(i);
            byte byte0 = nbttagcompound1.func_74771_c(SLOT_TAG);
            if (byte0 < 0 || byte0 >= this.chromosomes.length) continue;
            Chromosome chromosome = Chromosome.loadChromosomeFromNBT(nbttagcompound1);
            this.chromosomes[byte0] = chromosome;
            if (Config.clearInvalidChromosomes && chromosome.overrideInvalidAlleles(this.getDefaultTemplate()[byte0], this.getSpeciesRoot().getKaryotype()[byte0].getAlleleClass())) {
                invalidGenome = true;
            }
            if (!chromosome.hasInvalidAlleles(this.getSpeciesRoot().getKaryotype()[byte0].getAlleleClass())) continue;
            throw new RuntimeException("Found Chromosome with invalid Alleles.\nNBTTagCompound: " + nbttaglist + "\nSee config option \"genetics.clear.invalid.chromosomes\".");
        }
        if (invalidGenome.booleanValue()) {
            Proxies.log.warning("Overrode alleles for genome:\n{0}\nOriginal NBTTagCompound: {1}", this, nbttaglist);
        }
        if ((speciesChromosome = this.chromosomes[EnumTreeChromosome.SPECIES.ordinal()]) != null) {
            IAlleleSpecies species = (IAlleleSpecies)speciesChromosome.getActiveAllele();
            IAllele[] template = this.getSpeciesRoot().getTemplate(species.getUID());
            for (int i = 0; i < this.chromosomes.length; ++i) {
                if (this.chromosomes[i] != null || template[i] == null) continue;
                this.chromosomes[i] = new Chromosome(template[i]);
            }
        }
    }

    @Override
    public void writeToNBT(NBTTagCompound nbttagcompound) {
        NBTTagList nbttaglist = new NBTTagList();
        for (int i = 0; i < this.chromosomes.length; ++i) {
            if (this.chromosomes[i] == null) continue;
            NBTTagCompound nbttagcompound1 = new NBTTagCompound();
            nbttagcompound1.func_74774_a(SLOT_TAG, (byte)i);
            this.chromosomes[i].writeToNBT(nbttagcompound1);
            nbttaglist.func_74742_a((NBTBase)nbttagcompound1);
        }
        nbttagcompound.func_74782_a("Chromosomes", (NBTBase)nbttaglist);
    }

    @Override
    public IChromosome[] getChromosomes() {
        return this.chromosomes;
    }

    @Override
    public IAllele getActiveAllele(int chromosome) {
        return this.chromosomes[chromosome].getActiveAllele();
    }

    @Override
    public IAllele getActiveAllele(IChromosomeType chromosomeType) {
        return this.chromosomes[chromosomeType.ordinal()].getActiveAllele();
    }

    @Override
    public IAllele getInactiveAllele(int chromosome) {
        return this.chromosomes[chromosome].getInactiveAllele();
    }

    @Override
    public IAllele getInactiveAllele(IChromosomeType chromosomeType) {
        return this.chromosomes[chromosomeType.ordinal()].getInactiveAllele();
    }

    @Override
    public boolean isGeneticEqual(IGenome other) {
        IChromosome[] genetics = other.getChromosomes();
        if (this.chromosomes.length != genetics.length) {
            return false;
        }
        for (int i = 0; i < this.chromosomes.length; ++i) {
            IChromosome chromosome = this.chromosomes[i];
            IChromosome otherChromosome = genetics[i];
            if (chromosome == null && otherChromosome == null) continue;
            if (chromosome == null || otherChromosome == null) {
                return false;
            }
            if (!chromosome.getPrimaryAllele().getUID().equals(otherChromosome.getPrimaryAllele().getUID())) {
                return false;
            }
            if (chromosome.getSecondaryAllele().getUID().equals(otherChromosome.getSecondaryAllele().getUID())) continue;
            return false;
        }
        return true;
    }

    public String toString() {
        Objects.ToStringHelper toStringHelper = Objects.toStringHelper((Object)this);
        int i = 0;
        for (IChromosome chromosome : this.chromosomes) {
            toStringHelper.add(String.valueOf(i++), (Object)chromosome);
        }
        return toStringHelper.toString();
    }
}

