/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.genetics;

import forestry.api.genetics.IAlleleArea;
import forestry.core.genetics.Allele;
import forestry.core.utils.StringUtil;
import forestry.core.vect.Vect;

public class AlleleArea
extends Allele
implements IAlleleArea {
    private final int[] area;

    public AlleleArea(String uid, int[] value) {
        this(uid, value, false);
    }

    public AlleleArea(String uid, int[] value, boolean isDominant) {
        super(uid, isDominant);
        this.area = value;
    }

    @Override
    public int[] getValue() {
        return this.area;
    }

    public Vect getArea() {
        return new Vect(this.area);
    }

    public AlleleArea setName(String customPrefix, String name) {
        String customName = "gui." + customPrefix + "." + name;
        this.name = StringUtil.canTranslate(customName) ? customName : "gui." + name;
        return this;
    }
}

