/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.gadgets;

import buildcraft.api.tiles.IHasWork;
import cpw.mods.fml.common.Optional;
import forestry.core.gadgets.TileBase;
import forestry.core.interfaces.IPowerHandler;
import forestry.core.interfaces.IRenderableMachine;
import forestry.core.proxy.Proxies;
import forestry.core.utils.EnumTankLevel;
import forestry.energy.EnergyManager;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.common.util.ForgeDirection;

@Optional.Interface(iface="buildcraft.api.tiles.IHasWork", modid="BuildCraftAPI|tiles")
public abstract class TilePowered
extends TileBase
implements IRenderableMachine,
IPowerHandler,
IHasWork {
    public static final int WORK_CYCLES = 4;
    protected final EnergyManager energyManager;
    private int workCounter;

    public TilePowered(int maxTransfer, int energyPerWork, int capacity) {
        this.energyManager = new EnergyManager(maxTransfer, energyPerWork, capacity);
        this.energyManager.setReceiveOnly();
    }

    public abstract boolean isWorking();

    public boolean hasResourcesMin(float percentage) {
        return false;
    }

    public boolean hasFuelMin(float percentage) {
        return false;
    }

    public abstract boolean hasWork();

    @Override
    public void func_145845_h() {
        super.func_145845_h();
        if (!Proxies.common.isSimulating(this.field_145850_b)) {
            return;
        }
        if (this.workCounter < 4 && this.energyManager.consumeEnergyToDoWork()) {
            ++this.workCounter;
        }
        if (this.workCounter >= 4 && this.field_145850_b.func_82737_E() % 5L == 0L && this.workCycle()) {
            this.workCounter = 0;
        }
    }

    public abstract boolean workCycle();

    @Override
    public void func_145841_b(NBTTagCompound nbt) {
        super.func_145841_b(nbt);
        this.energyManager.writeToNBT(nbt);
    }

    @Override
    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.energyManager.readFromNBT(nbt);
    }

    @Override
    public EnumTankLevel getPrimaryLevel() {
        return EnumTankLevel.EMPTY;
    }

    @Override
    public EnumTankLevel getSecondaryLevel() {
        return EnumTankLevel.EMPTY;
    }

    @Override
    public EnergyManager getEnergyManager() {
        return this.energyManager;
    }

    @Override
    public int receiveEnergy(ForgeDirection from, int maxReceive, boolean simulate) {
        return this.energyManager.receiveEnergy(from, maxReceive, simulate);
    }

    @Override
    public int extractEnergy(ForgeDirection from, int maxReceive, boolean simulate) {
        return this.energyManager.extractEnergy(from, maxReceive, simulate);
    }

    @Override
    public int getEnergyStored(ForgeDirection from) {
        return this.energyManager.getEnergyStored(from);
    }

    @Override
    public int getMaxEnergyStored(ForgeDirection from) {
        return this.energyManager.getMaxEnergyStored(from);
    }

    @Override
    public boolean canConnectEnergy(ForgeDirection from) {
        return this.energyManager.canConnectEnergy(from);
    }
}

