/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.gadgets;

import forestry.api.core.ForestryAPI;
import forestry.api.genetics.ISpeciesRoot;
import forestry.core.GuiHandler;
import forestry.core.config.Config;
import forestry.core.gadgets.TileBase;
import forestry.core.gui.IPagedInventory;
import forestry.core.inventory.TileInventoryAdapter;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;

public abstract class TileNaturalistChest
extends TileBase
implements IPagedInventory {
    private final int guiID;

    public TileNaturalistChest(ISpeciesRoot speciesRoot, int guiId) {
        this.setInternalInventory(new NaturalistInventoryAdapter(this, 125, "Items", speciesRoot));
        this.setHints(Config.hints.get("apiarist.chest"));
        this.guiID = guiId;
    }

    @Override
    public void openGui(EntityPlayer player, TileBase tile) {
        player.openGui(ForestryAPI.instance, this.guiID, player.field_70170_p, this.field_145851_c, this.field_145848_d, this.field_145849_e);
    }

    @Override
    public void flipPage(EntityPlayer player, int page) {
        player.openGui(ForestryAPI.instance, GuiHandler.encodeGuiData(this.guiID, page), player.field_70170_p, this.field_145851_c, this.field_145848_d, this.field_145849_e);
    }

    @Override
    public void updateServerSide() {
    }

    @Override
    public boolean throwsErrors() {
        return false;
    }

    private static class NaturalistInventoryAdapter
    extends TileInventoryAdapter {
        private final ISpeciesRoot speciesRoot;

        public NaturalistInventoryAdapter(TileNaturalistChest tile, int size, String name, ISpeciesRoot speciesRoot) {
            super(tile, size, name);
            this.speciesRoot = speciesRoot;
        }

        @Override
        public boolean canSlotAccept(int slotIndex, ItemStack itemstack) {
            return this.speciesRoot.isMember(itemstack);
        }
    }
}

