/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.gadgets;

import com.mojang.authlib.GameProfile;
import forestry.api.core.ForestryAPI;
import forestry.api.genetics.AlleleManager;
import forestry.api.genetics.IIndividual;
import forestry.core.gadgets.NaturalistGame;
import forestry.core.gadgets.TileBase;
import forestry.core.interfaces.ICrafter;
import forestry.core.interfaces.IRenderableMachine;
import forestry.core.inventory.InvTools;
import forestry.core.inventory.TileInventoryAdapter;
import forestry.core.network.ForestryPacket;
import forestry.core.network.GuiId;
import forestry.core.network.PacketTileNBT;
import forestry.core.network.PacketTileUpdate;
import forestry.core.proxy.Proxies;
import forestry.core.utils.EnumTankLevel;
import forestry.core.utils.GeneticsUtil;
import forestry.core.utils.GuiUtil;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;

public class TileEscritoire
extends TileBase
implements ISidedInventory,
IRenderableMachine,
ICrafter {
    public static final short SLOT_ANALYZE = 0;
    public static final short SLOT_RESULTS_1 = 1;
    public static final short SLOTS_RESULTS_COUNT = 6;
    public static final short SLOT_INPUT_1 = 7;
    public static final short SLOTS_INPUT_COUNT = 5;
    private final NaturalistGame game = new NaturalistGame();

    public TileEscritoire() {
        this.setInternalInventory(new TileInventoryAdapter(this, 12, "Items"){

            @Override
            public boolean canSlotAccept(int slotIndex, ItemStack itemStack) {
                if (slotIndex >= 7 && slotIndex < 7 + Math.min(TileEscritoire.this.game.getSampleSize(), 5)) {
                    ItemStack specimen = this.func_70301_a(0);
                    if (specimen == null) {
                        return false;
                    }
                    IIndividual individual = AlleleManager.alleleRegistry.getIndividual(specimen);
                    return individual != null && individual.getGenome().getPrimary().getResearchSuitability(itemStack) > 0.0f;
                }
                if (slotIndex == 0) {
                    return AlleleManager.alleleRegistry.isIndividual(itemStack);
                }
                return false;
            }

            @Override
            public boolean isLocked(int slotIndex) {
                if (slotIndex == 0) {
                    return false;
                }
                if (this.func_70301_a(0) == null) {
                    return true;
                }
                return GuiUtil.isIndexInRange(slotIndex, 7, 5) && slotIndex >= 7 + TileEscritoire.this.game.getSampleSize();
            }

            @Override
            public boolean func_102008_b(int slotIndex, ItemStack itemstack, int side) {
                return GuiUtil.isIndexInRange(slotIndex, 1, 6);
            }

            @Override
            public void func_70299_a(int slotIndex, ItemStack itemstack) {
                super.func_70299_a(slotIndex, itemstack);
                if (slotIndex == 0 && Proxies.common.isSimulating(TileEscritoire.this.field_145850_b)) {
                    ItemStack ersatz;
                    if (!AlleleManager.alleleRegistry.isIndividual(this.func_70301_a(0)) && this.func_70301_a(0) != null && (ersatz = GeneticsUtil.convertSaplingToGeneticEquivalent(this.func_70301_a(0))) != null) {
                        this.func_70299_a(0, ersatz);
                    }
                    TileEscritoire.this.game.initialize(this.func_70301_a(0));
                }
            }
        });
    }

    @Override
    public void openGui(EntityPlayer player, TileBase tile) {
        player.openGui(ForestryAPI.instance, GuiId.NaturalistBenchGUI.ordinal(), player.field_70170_p, this.field_145851_c, this.field_145848_d, this.field_145849_e);
    }

    @Override
    public void func_145841_b(NBTTagCompound nbttagcompound) {
        super.func_145841_b(nbttagcompound);
        this.game.writeToNBT(nbttagcompound);
    }

    @Override
    public void func_145839_a(NBTTagCompound nbttagcompound) {
        super.func_145839_a(nbttagcompound);
        this.game.readFromNBT(nbttagcompound);
    }

    public NaturalistGame getGame() {
        return this.game;
    }

    public void processTurnResult(GameProfile gameProfile) {
        if (!this.game.isWon()) {
            return;
        }
        IIndividual individual = AlleleManager.alleleRegistry.getIndividual(this.getInternalInventory().func_70301_a(0));
        if (individual == null) {
            return;
        }
        for (ItemStack itemstack : individual.getGenome().getPrimary().getResearchBounty(this.field_145850_b, gameProfile, individual, this.game.getBountyLevel())) {
            InvTools.addStack((IInventory)this.getInternalInventory(), itemstack, 1, 6, false, true);
        }
    }

    private boolean areProbeSlotsFilled() {
        int filledSlots = 0;
        int required = this.game.getSampleSize() < 5 ? this.game.getSampleSize() : 5;
        for (int i = 7; i < 7 + required; ++i) {
            if (this.getInternalInventory().func_70301_a(i) == null) continue;
            ++filledSlots;
        }
        return filledSlots >= required;
    }

    public void probe() {
        if (!this.field_145850_b.field_72995_K && this.getInternalInventory().func_70301_a(0) != null && this.areProbeSlotsFilled()) {
            this.game.probe(this.getInternalInventory().func_70301_a(0), (IInventory)this, 7, 5);
        }
    }

    @Override
    public void fromPacket(ForestryPacket packetRaw) {
        if (packetRaw instanceof PacketTileUpdate) {
            super.fromPacket(packetRaw);
            return;
        }
        PacketTileNBT packet = (PacketTileNBT)packetRaw;
        this.func_145839_a(packet.getTagCompound());
    }

    public void sendBoard(EntityPlayer player) {
        Proxies.net.sendToPlayer(new PacketTileNBT(5, this), player);
    }

    @Override
    public EnumTankLevel getPrimaryLevel() {
        return EnumTankLevel.EMPTY;
    }

    @Override
    public EnumTankLevel getSecondaryLevel() {
        return EnumTankLevel.EMPTY;
    }

    @Override
    public ItemStack takenFromSlot(int slotIndex, boolean consumeRecipe, EntityPlayer player) {
        if (slotIndex == 0) {
            this.game.reset();
        }
        return null;
    }

    @Override
    public ItemStack getResult() {
        return null;
    }

    @Override
    public boolean canTakeStack(int slotIndex) {
        return true;
    }
}

