/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.gadgets;

import forestry.api.core.ForestryAPI;
import forestry.api.genetics.AlleleManager;
import forestry.api.genetics.IIndividual;
import forestry.core.EnumErrorCode;
import forestry.core.config.ForestryItem;
import forestry.core.fluids.FluidHelper;
import forestry.core.fluids.Fluids;
import forestry.core.fluids.TankManager;
import forestry.core.fluids.tanks.FilteredTank;
import forestry.core.gadgets.TileBase;
import forestry.core.gadgets.TilePowered;
import forestry.core.interfaces.ILiquidTankContainer;
import forestry.core.inventory.InvTools;
import forestry.core.inventory.TileInventoryAdapter;
import forestry.core.inventory.wrappers.IInvSlot;
import forestry.core.inventory.wrappers.InventoryIterator;
import forestry.core.inventory.wrappers.InventoryMapper;
import forestry.core.network.GuiId;
import forestry.core.utils.GuiUtil;
import java.util.Stack;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.ICrafting;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTankInfo;

public class TileAnalyzer
extends TilePowered
implements ISidedInventory,
ILiquidTankContainer {
    public static final int TIME_TO_ANALYZE = 125;
    public static final int HONEY_REQUIRED = 100;
    public static final short SLOT_ANALYZE = 0;
    public static final short SLOT_CAN = 1;
    public static final short SLOT_INPUT_1 = 2;
    public static final short SLOT_INPUT_COUNT = 6;
    public static final short SLOT_OUTPUT_1 = 8;
    public static final short SLOT_OUTPUT_COUNT = 4;
    private int analyzeTime;
    public final FilteredTank resourceTank;
    private final TankManager tankManager;
    private final Stack<ItemStack> pendingProducts = new Stack();
    private final IInventory invInput;

    public TileAnalyzer() {
        super(800, 40, 5000);
        this.setInternalInventory(new TileInventoryAdapter(this, 12, "Items"){

            @Override
            public boolean canSlotAccept(int slotIndex, ItemStack itemStack) {
                if (GuiUtil.isIndexInRange(slotIndex, 2, 6)) {
                    return AlleleManager.alleleRegistry.isIndividual(itemStack);
                }
                if (slotIndex == 1) {
                    Fluid fluid = FluidHelper.getFluidInContainer(itemStack);
                    return TileAnalyzer.this.resourceTank.accepts(fluid);
                }
                return false;
            }

            @Override
            public boolean func_102008_b(int slotIndex, ItemStack stack, int side) {
                return GuiUtil.isIndexInRange(slotIndex, 8, 4);
            }
        });
        this.resourceTank = new FilteredTank(10000, Fluids.HONEY.getFluid());
        this.tankManager = new TankManager(this.resourceTank);
        this.invInput = new InventoryMapper((IInventory)this.getInternalInventory(), 2, 6);
    }

    @Override
    public void openGui(EntityPlayer player, TileBase tile) {
        player.openGui(ForestryAPI.instance, GuiId.AnalyzerGUI.ordinal(), player.field_70170_p, this.field_145851_c, this.field_145848_d, this.field_145849_e);
    }

    @Override
    public void func_145841_b(NBTTagCompound nbttagcompound) {
        super.func_145841_b(nbttagcompound);
        nbttagcompound.func_74768_a("AnalyzeTime", this.analyzeTime);
        this.tankManager.writeTanksToNBT(nbttagcompound);
        NBTTagList nbttaglist = new NBTTagList();
        ItemStack[] pending = this.pendingProducts.toArray(new ItemStack[this.pendingProducts.size()]);
        for (int i = 0; i < pending.length; ++i) {
            if (pending[i] == null) continue;
            NBTTagCompound nbttagcompound1 = new NBTTagCompound();
            nbttagcompound1.func_74774_a("Slot", (byte)i);
            pending[i].func_77955_b(nbttagcompound1);
            nbttaglist.func_74742_a((NBTBase)nbttagcompound1);
        }
        nbttagcompound.func_74782_a("PendingProducts", (NBTBase)nbttaglist);
    }

    @Override
    public void func_145839_a(NBTTagCompound nbttagcompound) {
        super.func_145839_a(nbttagcompound);
        this.analyzeTime = nbttagcompound.func_74762_e("AnalyzeTime");
        this.tankManager.readTanksFromNBT(nbttagcompound);
        NBTTagList nbttaglist = nbttagcompound.func_150295_c("PendingProducts", 10);
        for (int i = 0; i < nbttaglist.func_74745_c(); ++i) {
            NBTTagCompound nbttagcompound1 = nbttaglist.func_150305_b(i);
            this.pendingProducts.add(ItemStack.func_77949_a((NBTTagCompound)nbttagcompound1));
        }
    }

    @Override
    protected void updateServerSide() {
        IInvSlot slot;
        FluidHelper.drainContainers(this.tankManager, (IInventory)this, 1);
        ItemStack can = this.func_70301_a(1);
        if (ForestryItem.honeyDrop.isItemEqual(can) && this.resourceTank.fill(Fluids.HONEY.getFluid(100), false) == 100) {
            this.func_70299_a(1, InvTools.depleteItem(can));
            this.resourceTank.fill(Fluids.HONEY.getFluid(100), true);
        }
        for (int i = 0; i < this.invInput.func_70302_i_(); ++i) {
            IIndividual individual;
            ItemStack inputStack = this.invInput.func_70301_a(i);
            if (inputStack == null || !AlleleManager.alleleRegistry.isIndividual(inputStack) || !(individual = AlleleManager.alleleRegistry.getIndividual(inputStack)).isAnalyzed()) continue;
            this.pendingProducts.push(inputStack);
            this.invInput.func_70298_a(i, inputStack.field_77994_a);
        }
        this.tryAddPending();
        if (!this.pendingProducts.isEmpty()) {
            this.setErrorState(EnumErrorCode.NOSPACE);
            return;
        }
        if (this.analyzeTime == 0 && (slot = this.getInputSlot()) == null) {
            this.setErrorState(EnumErrorCode.NOTHINGANALYZE);
            return;
        }
        if (this.resourceTank.getFluidAmount() < 100) {
            this.setErrorState(EnumErrorCode.NORESOURCE);
            return;
        }
        if (this.energyManager.getTotalEnergyStored() == 0) {
            this.setErrorState(EnumErrorCode.NOPOWER);
            return;
        }
        this.setErrorState(EnumErrorCode.OK);
    }

    @Override
    public boolean workCycle() {
        ItemStack stackToAnalyze = this.func_70301_a(0);
        if (this.analyzeTime > 0 && stackToAnalyze != null && AlleleManager.alleleRegistry.isIndividual(stackToAnalyze)) {
            --this.analyzeTime;
            if (this.analyzeTime > 0) {
                this.setErrorState(EnumErrorCode.OK);
                return true;
            }
            IIndividual individual = AlleleManager.alleleRegistry.getIndividual(stackToAnalyze);
            if (individual == null) {
                return false;
            }
            individual.analyze();
            NBTTagCompound nbttagcompound = new NBTTagCompound();
            individual.writeToNBT(nbttagcompound);
            stackToAnalyze.func_77982_d(nbttagcompound);
            this.pendingProducts.push(stackToAnalyze);
            this.func_70299_a(0, null);
            this.sendNetworkUpdate();
            return true;
        }
        this.analyzeTime = 0;
        if (stackToAnalyze != null) {
            return false;
        }
        if (this.getErrorState() != EnumErrorCode.OK) {
            return false;
        }
        IInvSlot slot = this.getInputSlot();
        ItemStack inputStack = slot.getStackInSlot();
        this.func_70299_a(0, inputStack);
        slot.setStackInSlot(null);
        this.resourceTank.drain(100, true);
        this.analyzeTime = 125;
        this.sendNetworkUpdate();
        return true;
    }

    private IInvSlot getInputSlot() {
        for (IInvSlot slot : InventoryIterator.getIterable(this.invInput)) {
            ItemStack inputStack = slot.getStackInSlot();
            if (inputStack == null || !AlleleManager.alleleRegistry.isIndividual(inputStack)) continue;
            return slot;
        }
        return null;
    }

    private boolean tryAddPending() {
        if (this.pendingProducts.isEmpty()) {
            return false;
        }
        ItemStack next = this.pendingProducts.peek();
        if (InvTools.tryAddStack((IInventory)this.getInternalInventory(), next, 8, this.getInternalInventory().func_70302_i_() - 8, true)) {
            this.pendingProducts.pop();
            return true;
        }
        return false;
    }

    @Override
    public boolean isWorking() {
        return this.analyzeTime > 0;
    }

    @Override
    public boolean hasWork() {
        if (!this.pendingProducts.isEmpty()) {
            return true;
        }
        if (this.analyzeTime > 0) {
            return true;
        }
        return this.getErrorState() == EnumErrorCode.OK || this.getErrorState() == EnumErrorCode.NOPOWER;
    }

    public int getProgressScaled(int i) {
        return this.analyzeTime * i / 125;
    }

    public int getResourceScaled(int i) {
        return this.resourceTank.getFluidAmount() * i / 10000;
    }

    public ItemStack getIndividualOnDisplay() {
        return this.func_70301_a(0);
    }

    @Override
    public void getGUINetworkData(int i, int j) {
        switch (i -= this.tankManager.maxMessageId() + 1) {
            case 0: {
                this.analyzeTime = j;
            }
        }
    }

    @Override
    public void sendGUINetworkData(Container container, ICrafting iCrafting) {
        int i = this.tankManager.maxMessageId() + 1;
        iCrafting.func_71112_a(container, i, this.analyzeTime);
    }

    @Override
    public TankManager getTankManager() {
        return this.tankManager;
    }

    public int fill(ForgeDirection from, FluidStack resource, boolean doFill) {
        return this.tankManager.fill(from, resource, doFill);
    }

    public FluidStack drain(ForgeDirection from, FluidStack resource, boolean doDrain) {
        return this.tankManager.drain(from, resource, doDrain);
    }

    public FluidStack drain(ForgeDirection from, int maxDrain, boolean doDrain) {
        return this.tankManager.drain(from, maxDrain, doDrain);
    }

    public boolean canFill(ForgeDirection from, Fluid fluid) {
        return this.tankManager.canFill(from, fluid);
    }

    public boolean canDrain(ForgeDirection from, Fluid fluid) {
        return this.tankManager.canDrain(from, fluid);
    }

    public FluidTankInfo[] getTankInfo(ForgeDirection from) {
        return this.tankManager.getTankInfo(from);
    }
}

