/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.gadgets;

import forestry.core.gadgets.TileBase;
import forestry.core.network.PacketPayload;

public abstract class Mill
extends TileBase {
    public int charge = 0;
    public float speed = 0.01f;
    public int stage = 0;
    public float progress;

    @Override
    public void updateClientSide() {
        this.update(false);
    }

    @Override
    public void updateServerSide() {
        this.update(true);
    }

    @Override
    public PacketPayload getPacketPayload() {
        PacketPayload payload = new PacketPayload(2, 1, 0);
        payload.intPayload[0] = this.charge;
        payload.intPayload[1] = this.stage;
        payload.floatPayload[0] = this.speed;
        return payload;
    }

    @Override
    public void fromPacketPayload(PacketPayload payload) {
        this.charge = payload.intPayload[0];
        this.stage = payload.intPayload[1];
        this.speed = payload.floatPayload[0];
    }

    private void update(boolean isSimulating) {
        if (this.charge <= 0) {
            if (this.stage > 0) {
                this.progress += this.speed;
            }
            if ((double)this.progress > 0.5) {
                this.stage = 2;
            }
            if (this.progress > 1.0f) {
                this.progress = 0.0f;
                this.stage = 0;
            }
            return;
        }
        this.progress += this.speed;
        if (this.stage <= 0) {
            this.stage = 1;
        }
        if ((double)this.progress > 0.5 && this.stage == 1) {
            this.stage = 2;
            if (this.charge < 7 && isSimulating) {
                ++this.charge;
                this.sendNetworkUpdate();
            }
        }
        if (this.progress > 1.0f) {
            this.progress = 0.0f;
            this.stage = 0;
            if (this.charge >= 7) {
                this.activate();
            }
        }
    }

    protected abstract void activate();
}

