/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.gadgets;

import cofh.api.energy.IEnergyConnection;
import forestry.core.TemperatureState;
import forestry.core.gadgets.TileBase;
import forestry.core.network.PacketPayload;
import forestry.core.utils.BlockUtil;
import forestry.energy.EnergyManager;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.ICrafting;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public abstract class Engine
extends TileBase
implements IEnergyConnection {
    public boolean isActive = false;
    public int stagePiston = 0;
    public float pistonSpeedServer = 0.0f;
    protected int currentOutput = 0;
    public final int maxEnergy;
    public final int maxEnergyExtracted;
    public int heat;
    protected final int maxHeat;
    protected boolean forceCooldown = false;
    public float progress;
    protected final EnergyManager energyManager;

    @Override
    public PacketPayload getPacketPayload() {
        PacketPayload payload = new PacketPayload(3, 1, 0);
        payload.intPayload[0] = this.isActive ? 1 : 0;
        payload.intPayload[1] = this.energyManager.toPacketInt();
        payload.intPayload[2] = this.heat;
        payload.floatPayload[0] = this.pistonSpeedServer;
        return payload;
    }

    @Override
    public void fromPacketPayload(PacketPayload payload) {
        this.isActive = payload.intPayload[0] > 0;
        this.energyManager.fromPacketInt(payload.intPayload[1]);
        this.heat = payload.intPayload[2];
        this.pistonSpeedServer = payload.floatPayload[0];
    }

    public Engine(int maxHeat, int maxEnergy, int maxEnergyExtracted) {
        this.maxHeat = maxHeat;
        this.maxEnergy = maxEnergy;
        this.maxEnergyExtracted = maxEnergyExtracted;
        this.energyManager = new EnergyManager(2000, 100, 1000000);
        this.energyManager.setReceiveOnly();
    }

    @Override
    public void rotateAfterPlacement(World world, int x, int y, int z, EntityLivingBase entityliving, ItemStack itemstack) {
        this.rotateEngine();
    }

    protected void addHeat(int i) {
        this.heat += i;
        if (this.heat > this.maxHeat) {
            this.heat = this.maxHeat;
        }
    }

    public abstract int dissipateHeat();

    public abstract int generateHeat();

    public boolean mayBurn() {
        return !this.forceCooldown;
    }

    public abstract void burn();

    @Override
    public void updateClientSide() {
        if (this.stagePiston != 0) {
            this.progress += this.pistonSpeedServer;
            if (this.progress > 1.0f) {
                this.stagePiston = 0;
                this.progress = 0.0f;
            }
        } else if (this.isActive) {
            this.stagePiston = 1;
        }
    }

    @Override
    public void updateServerSide() {
        TemperatureState energyState = this.getTemperatureState();
        if (energyState == TemperatureState.MELTING && this.heat > 0) {
            this.forceCooldown = true;
        } else if (this.forceCooldown && this.heat <= 0) {
            this.forceCooldown = false;
        }
        TileEntity tile = this.field_145850_b.func_147438_o(this.field_145851_c + this.getOrientation().offsetX, this.field_145848_d + this.getOrientation().offsetY, this.field_145849_e + this.getOrientation().offsetZ);
        float newPistonSpeed = this.getPistonSpeed();
        if (newPistonSpeed != this.pistonSpeedServer) {
            this.pistonSpeedServer = newPistonSpeed;
            this.sendNetworkUpdate();
        }
        if (this.stagePiston != 0) {
            this.progress += this.pistonSpeedServer;
            if ((double)this.progress > 0.25 && this.stagePiston == 1) {
                this.stagePiston = 2;
                this.energyManager.sendEnergy(this.getOrientation(), tile);
            } else if ((double)this.progress >= 0.5) {
                this.progress = 0.0f;
                this.stagePiston = 0;
            }
        } else if (this.canPowerTo(tile)) {
            if (this.energyManager.getEnergyStored(this.getOrientation()) > 0) {
                this.stagePiston = 1;
                this.setActive(true);
            } else {
                this.setActive(false);
            }
        } else {
            this.setActive(false);
        }
        this.dissipateHeat();
        this.generateHeat();
        if (this.mayBurn()) {
            this.burn();
        } else {
            this.energyManager.drainEnergy(20);
        }
    }

    private boolean canPowerTo(TileEntity tile) {
        return this.isActivated() && BlockUtil.isEnergyReceiver(this.getOrientation().getOpposite(), tile);
    }

    private void setActive(boolean isActive) {
        if (this.isActive == isActive) {
            return;
        }
        this.isActive = isActive;
        this.sendNetworkUpdate();
    }

    public void rotateEngine() {
        for (int i = this.getOrientation().ordinal() + 1; i <= this.getOrientation().ordinal() + 6; ++i) {
            ForgeDirection orient = ForgeDirection.values()[i % 6];
            TileEntity tile = this.field_145850_b.func_147438_o(this.field_145851_c + orient.offsetX, this.field_145848_d + orient.offsetY, this.field_145849_e + orient.offsetZ);
            if (!BlockUtil.isEnergyReceiver(this.getOrientation().getOpposite(), tile)) continue;
            this.setOrientation(orient);
            this.field_145850_b.func_147459_d(this.field_145851_c, this.field_145848_d, this.field_145849_e, this.field_145850_b.func_147439_a(this.field_145851_c, this.field_145848_d, this.field_145849_e));
            this.field_145850_b.func_147479_m(this.field_145851_c, this.field_145848_d, this.field_145849_e);
            break;
        }
    }

    protected double getHeatLevel() {
        return (double)this.heat / (double)this.maxHeat;
    }

    public abstract boolean isBurning();

    public int getBurnTimeRemainingScaled(int i) {
        return 0;
    }

    public boolean hasFuelMin(float percentage) {
        return false;
    }

    public int getCurrentOutput() {
        if (this.isBurning() && this.isActivated()) {
            return this.currentOutput;
        }
        return 0;
    }

    public int getHeat() {
        return this.heat;
    }

    public TemperatureState getTemperatureState() {
        double scaledHeat = (double)this.heat / (double)this.maxHeat;
        if (scaledHeat < 0.2) {
            return TemperatureState.COOL;
        }
        if (scaledHeat < 0.45) {
            return TemperatureState.WARMED_UP;
        }
        if (scaledHeat < 0.65) {
            return TemperatureState.OPERATING_TEMPERATURE;
        }
        if (scaledHeat < 0.85) {
            return TemperatureState.RUNNING_HOT;
        }
        if (scaledHeat < 1.0) {
            return TemperatureState.OVERHEATING;
        }
        return TemperatureState.MELTING;
    }

    public float getPistonSpeed() {
        switch (this.getTemperatureState()) {
            case COOL: {
                return 0.03f;
            }
            case WARMED_UP: {
                return 0.04f;
            }
            case OPERATING_TEMPERATURE: {
                return 0.05f;
            }
            case RUNNING_HOT: {
                return 0.06f;
            }
            case OVERHEATING: {
                return 0.07f;
            }
            case MELTING: {
                return 0.08f;
            }
        }
        return 0.0f;
    }

    @Override
    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.energyManager.readFromNBT(nbt);
        this.heat = nbt.func_74762_e("EngineHeat");
        this.progress = nbt.func_74760_g("EngineProgress");
        this.forceCooldown = nbt.func_74767_n("ForceCooldown");
    }

    @Override
    public void func_145841_b(NBTTagCompound nbt) {
        super.func_145841_b(nbt);
        this.energyManager.writeToNBT(nbt);
        nbt.func_74768_a("EngineHeat", this.heat);
        nbt.func_74776_a("EngineProgress", this.progress);
        nbt.func_74757_a("ForceCooldown", this.forceCooldown);
    }

    public abstract void getGUINetworkData(int var1, int var2);

    public abstract void sendGUINetworkData(Container var1, ICrafting var2);

    @Override
    public boolean canConnectEnergy(ForgeDirection from) {
        return this.energyManager.canConnectEnergy(from);
    }

    public EnergyManager getEnergyManager() {
        return this.energyManager;
    }
}

