/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.circuits;

import forestry.api.circuits.ChipsetManager;
import forestry.api.circuits.ICircuit;
import forestry.api.circuits.ICircuitLayout;
import forestry.api.circuits.ISolderManager;
import forestry.api.core.ForestryAPI;
import forestry.api.core.IErrorState;
import forestry.core.EnumErrorCode;
import forestry.core.circuits.CircuitRegistry;
import forestry.core.circuits.EnumCircuitBoardType;
import forestry.core.circuits.ISolderingIron;
import forestry.core.circuits.ItemCircuitBoard;
import forestry.core.interfaces.IErrorSource;
import forestry.core.inventory.ItemInventory;
import forestry.core.items.ItemForestry;
import forestry.core.network.GuiId;
import forestry.core.proxy.Proxies;
import forestry.core.utils.RevolvingList;
import java.util.ArrayList;
import java.util.Collection;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;

public class ItemSolderingIron
extends ItemForestry
implements ISolderingIron {
    public ItemSolderingIron() {
        this.func_77625_d(1);
        this.func_77656_e(5);
    }

    public boolean func_77662_d() {
        return true;
    }

    public ItemStack func_77659_a(ItemStack itemstack, World world, EntityPlayer entityplayer) {
        if (Proxies.common.isSimulating(world)) {
            entityplayer.openGui(ForestryAPI.instance, GuiId.SolderingIronGUI.ordinal(), world, (int)entityplayer.field_70165_t, (int)entityplayer.field_70163_u, (int)entityplayer.field_70161_v);
        }
        return itemstack;
    }

    public static class SolderingInventory
    extends ItemInventory
    implements IErrorSource {
        private final RevolvingList<ICircuitLayout> layouts = new RevolvingList<ICircuitLayout>(ChipsetManager.circuitRegistry.getRegisteredLayouts().values());
        private EnumErrorCode errorState;
        private final short blankSlot = 0;
        private final short finishedSlot = 1;
        private final short ingredientSlot1 = (short)2;
        private final short ingredientSlotCount = (short)4;

        public SolderingInventory(ItemStack itemStack) {
            super(ItemSolderingIron.class, 6, itemStack);
            this.init();
        }

        @Override
        public int func_70297_j_() {
            return 1;
        }

        private void init() {
            this.layouts.setCurrent(ChipsetManager.circuitRegistry.getDefaultLayout());
        }

        public ICircuitLayout getLayout() {
            return this.layouts.getCurrent();
        }

        public void setLayout(String uid) {
            this.layouts.setCurrent(ChipsetManager.circuitRegistry.getLayout(uid));
        }

        public void advanceLayout() {
            this.layouts.rotateRight();
        }

        public void regressLayout() {
            this.layouts.rotateLeft();
        }

        private Collection<ICircuit> getCircuits(EnumCircuitBoardType type, boolean doConsume) {
            ArrayList<ICircuit> circuits = new ArrayList<ICircuit>();
            for (short i = 0; i < type.sockets; i = (short)(i + 1)) {
                CircuitRecipe recipe;
                ItemStack ingredient = this.inventoryStacks[2 + i];
                if (ingredient == null || (recipe = SolderManager.getMatchingRecipe(this.layouts.getCurrent(), ingredient)) == null || this.getCount(recipe.circuit, circuits) >= recipe.circuit.getLimit()) continue;
                if (doConsume) {
                    this.func_70298_a(2 + i, ((CircuitRecipe)recipe).resource.field_77994_a);
                }
                circuits.add(recipe.circuit);
            }
            return circuits;
        }

        public void trySolder() {
            if (this.layouts.getCurrent() == CircuitRegistry.DUMMY_LAYOUT) {
                return;
            }
            ItemStack blank = this.inventoryStacks[0];
            if (blank == null) {
                return;
            }
            if (blank.field_77994_a > 1) {
                return;
            }
            if (this.inventoryStacks[1] != null) {
                return;
            }
            if (!ChipsetManager.circuitRegistry.isChipset(blank)) {
                return;
            }
            if (blank.func_77960_j() < 0 || blank.func_77960_j() >= EnumCircuitBoardType.values().length) {
                return;
            }
            EnumCircuitBoardType type = EnumCircuitBoardType.values()[blank.func_77960_j()];
            Collection<ICircuit> circuits = this.getCircuits(type, false);
            if (circuits.size() <= 0) {
                return;
            }
            if (circuits.size() != type.sockets) {
                this.errorState = EnumErrorCode.CIRCUITMISMATCH;
                return;
            }
            circuits = this.getCircuits(type, true);
            this.inventoryStacks[1] = ItemCircuitBoard.createCircuitboard(type, this.layouts.getCurrent(), circuits.toArray(new ICircuit[circuits.size()]));
            this.inventoryStacks[0] = null;
        }

        public int getCount(ICircuit circuit, ArrayList<ICircuit> circuits) {
            int count = 0;
            for (ICircuit other : circuits) {
                if (!other.getUID().equals(circuit.getUID())) continue;
                ++count;
            }
            return count;
        }

        @Override
        public void func_70296_d() {
            this.errorState = EnumErrorCode.OK;
            this.trySolder();
        }

        @Override
        public boolean throwsErrors() {
            return true;
        }

        @Override
        public IErrorState getErrorState() {
            if (this.layouts.getCurrent() == CircuitRegistry.DUMMY_LAYOUT) {
                return EnumErrorCode.NOCIRCUITLAYOUT;
            }
            if (this.inventoryStacks[0] == null) {
                return EnumErrorCode.NOCIRCUITBOARD;
            }
            if (this.inventoryStacks[0].field_77994_a > 1) {
                return EnumErrorCode.WRONGSTACKSIZE;
            }
            if (this.errorState != EnumErrorCode.OK) {
                return this.errorState;
            }
            return EnumErrorCode.OK;
        }

        @Override
        public boolean canSlotAccept(int slotIndex, ItemStack itemStack) {
            if (itemStack == null) {
                return false;
            }
            Item item = itemStack.func_77973_b();
            if (slotIndex == 0) {
                return item instanceof ItemCircuitBoard;
            }
            if (slotIndex >= 2 && slotIndex < 6) {
                CircuitRecipe recipe = SolderManager.getMatchingRecipe(this.layouts.getCurrent(), itemStack);
                return recipe != null;
            }
            return false;
        }
    }

    public static class SolderManager
    implements ISolderManager {
        public static final ArrayList<CircuitRecipe> recipes = new ArrayList();

        @Override
        public void addRecipe(ICircuitLayout layout, ItemStack resource, ICircuit circuit) {
            if (layout == null) {
                throw new IllegalArgumentException("layout may not be null");
            }
            if (resource == null) {
                throw new IllegalArgumentException("resource may not be null");
            }
            if (circuit == null) {
                throw new IllegalArgumentException("circuit may not be null");
            }
            recipes.add(new CircuitRecipe(layout, resource, circuit));
        }

        public static CircuitRecipe getMatchingRecipe(ICircuitLayout layout, ItemStack resource) {
            if (layout == null || resource == null) {
                return null;
            }
            for (CircuitRecipe recipe : recipes) {
                if (!recipe.matches(layout, resource)) continue;
                return recipe;
            }
            return null;
        }
    }

    public static class CircuitRecipe {
        private final ICircuitLayout layout;
        private final ItemStack resource;
        public final ICircuit circuit;

        public CircuitRecipe(ICircuitLayout layout, ItemStack resource, ICircuit circuit) {
            this.resource = resource;
            this.layout = layout;
            this.circuit = circuit;
        }

        public boolean matches(ICircuitLayout layout, ItemStack itemstack) {
            if (!this.layout.getUID().equals(layout.getUID())) {
                return false;
            }
            return itemstack.func_77969_a(this.resource);
        }
    }
}

