/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.circuits;

import forestry.api.circuits.ICircuit;
import forestry.api.circuits.ICircuitBoard;
import forestry.api.circuits.ICircuitLayout;
import forestry.api.circuits.ICircuitLibrary;
import forestry.api.circuits.ICircuitRegistry;
import forestry.core.circuits.CircuitBoard;
import forestry.core.circuits.CircuitLayout;
import forestry.core.circuits.CircuitLibrary;
import forestry.core.config.ForestryItem;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;
import net.minecraft.world.WorldSavedData;

public class CircuitRegistry
implements ICircuitRegistry {
    public static final ICircuitLayout DUMMY_LAYOUT = new CircuitLayout("dummy");
    public static final Map<String, ICircuitLayout> DUMMY_MAP = new LinkedHashMap<String, ICircuitLayout>();
    private final Map<String, ICircuitLayout> layoutMap = new LinkedHashMap<String, ICircuitLayout>();
    private final Map<String, ICircuit> circuitMap = new LinkedHashMap<String, ICircuit>();
    private final Map<Integer, String> legacyMap = new HashMap<Integer, String>();

    @Override
    public ICircuitLibrary getCircuitLibrary(World world, String playername) {
        CircuitLibrary library = (CircuitLibrary)world.func_72943_a(CircuitLibrary.class, "CircuitLibrary_" + playername);
        if (library == null) {
            library = new CircuitLibrary(playername);
            world.func_72823_a("CircuitLibrary_" + playername, (WorldSavedData)library);
        }
        return library;
    }

    @Override
    public ICircuitLayout getDefaultLayout() {
        if (this.layoutMap.containsKey("forestry.engine.tin")) {
            return this.layoutMap.get("forestry.engine.tin");
        }
        if (!this.layoutMap.isEmpty()) {
            return this.layoutMap.values().iterator().next();
        }
        return DUMMY_LAYOUT;
    }

    @Override
    public Map<String, ICircuitLayout> getRegisteredLayouts() {
        if (this.layoutMap.isEmpty()) {
            return DUMMY_MAP;
        }
        return this.layoutMap;
    }

    @Override
    public void registerLayout(ICircuitLayout layout) {
        this.layoutMap.put(layout.getUID(), layout);
    }

    @Override
    public ICircuitLayout getLayout(String uid) {
        if (this.layoutMap.containsKey(uid)) {
            return this.layoutMap.get(uid);
        }
        return null;
    }

    @Override
    public Map<String, ICircuit> getRegisteredCircuits() {
        return this.circuitMap;
    }

    @Override
    public void registerCircuit(ICircuit circuit) {
        this.circuitMap.put(circuit.getUID(), circuit);
    }

    @Override
    public ICircuit getCircuit(String uid) {
        return this.circuitMap.get(uid);
    }

    @Override
    public void registerLegacyMapping(int id, String uid) {
        this.legacyMap.put(id, uid);
    }

    @Override
    public ICircuit getFromLegacyMap(int id) {
        if (!this.legacyMap.containsKey(id)) {
            return null;
        }
        return this.getCircuit(this.legacyMap.get(id));
    }

    public void initialize() {
    }

    @Override
    public boolean isChipset(ItemStack itemstack) {
        return ForestryItem.circuitboards.isItemEqual(itemstack);
    }

    @Override
    public ICircuitBoard getCircuitboard(ItemStack itemstack) {
        NBTTagCompound nbttagcompound = itemstack.func_77978_p();
        if (nbttagcompound == null) {
            return null;
        }
        return new CircuitBoard(nbttagcompound);
    }

    static {
        DUMMY_MAP.put("dummy", DUMMY_LAYOUT);
    }
}

