/*
 * Decompiled with CFR 0.152.
 */
package forestry.core;

import com.google.common.collect.ImmutableList;
import cpw.mods.fml.common.IWorldGenerator;
import cpw.mods.fml.common.event.FMLInterModComms;
import cpw.mods.fml.common.network.IGuiHandler;
import cpw.mods.fml.common.network.NetworkRegistry;
import cpw.mods.fml.common.registry.GameRegistry;
import forestry.api.apiculture.FlowerManager;
import forestry.api.core.ForestryAPI;
import forestry.api.fuels.EngineBronzeFuel;
import forestry.api.fuels.EngineCopperFuel;
import forestry.api.fuels.FermenterFuel;
import forestry.api.fuels.FuelManager;
import forestry.api.fuels.MoistenerFuel;
import forestry.api.fuels.RainSubstrate;
import forestry.core.EnumErrorCode;
import forestry.core.EventHandlerCore;
import forestry.core.ForestryConstants;
import forestry.core.GameMode;
import forestry.core.GuiHandler;
import forestry.core.WorldGenerator;
import forestry.core.config.Config;
import forestry.core.config.ForestryItem;
import forestry.core.config.Version;
import forestry.core.fluids.Fluids;
import forestry.core.gadgets.TileEngine;
import forestry.core.gadgets.TileMachine;
import forestry.core.gadgets.TileMill;
import forestry.core.proxy.Proxies;
import forestry.plugins.PluginManager;
import java.io.File;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.server.MinecraftServer;
import net.minecraftforge.common.MinecraftForge;

public class ForestryCore {
    public void preInit(File modLocation, Object basemod) {
        ForestryAPI.instance = basemod;
        ForestryAPI.forestryConstants = new ForestryConstants();
        MinecraftForge.EVENT_BUS.register((Object)new EventHandlerCore());
        Config.load();
        if (!Config.disableVersionCheck) {
            Version.versionCheck();
        }
        EnumErrorCode.init();
        PluginManager.runPreInit();
    }

    public void init(Object basemod) {
        FuelManager.fermenterFuel.put(ForestryItem.fertilizerCompound.getItemStack(), new FermenterFuel(ForestryItem.fertilizerCompound.getItemStack(), GameMode.getGameMode().getIntegerSetting("fermenter.value.fertilizer"), GameMode.getGameMode().getIntegerSetting("fermenter.cycles.fertilizer")));
        FuelManager.fermenterFuel.put(ForestryItem.fertilizerBio.getItemStack(), new FermenterFuel(ForestryItem.fertilizerBio.getItemStack(), GameMode.getGameMode().getIntegerSetting("fermenter.value.compost"), GameMode.getGameMode().getIntegerSetting("fermenter.cycles.compost")));
        FuelManager.fermenterFuel.put(ForestryItem.mulch.getItemStack(), new FermenterFuel(ForestryItem.mulch.getItemStack(), GameMode.getGameMode().getIntegerSetting("fermenter.value.compost"), GameMode.getGameMode().getIntegerSetting("fermenter.cycles.compost")));
        FuelManager.moistenerResource.put(new ItemStack(Items.field_151015_O), new MoistenerFuel(new ItemStack(Items.field_151015_O), ForestryItem.mouldyWheat.getItemStack(), 0, 300));
        FuelManager.moistenerResource.put(ForestryItem.mouldyWheat.getItemStack(), new MoistenerFuel(ForestryItem.mouldyWheat.getItemStack(), ForestryItem.decayingWheat.getItemStack(), 1, 600));
        FuelManager.moistenerResource.put(ForestryItem.decayingWheat.getItemStack(), new MoistenerFuel(ForestryItem.decayingWheat.getItemStack(), ForestryItem.mulch.getItemStack(), 2, 900));
        FuelManager.copperEngineFuel.put(ForestryItem.peat.getItemStack(), new EngineCopperFuel(ForestryItem.peat.getItemStack(), 10, 5000));
        FuelManager.copperEngineFuel.put(ForestryItem.bituminousPeat.getItemStack(), new EngineCopperFuel(ForestryItem.bituminousPeat.getItemStack(), 20, 6000));
        FuelManager.bronzeEngineFuel.put(Fluids.BIOMASS.getFluid(), new EngineBronzeFuel(Fluids.BIOMASS.getFluid(), 50, (int)(2500.0f * GameMode.getGameMode().getFloatSetting("fuel.biomass.biogas")), 1));
        FuelManager.bronzeEngineFuel.put(Fluids.WATER.getFluid(), new EngineBronzeFuel(Fluids.WATER.getFluid(), 10, 1000, 3));
        FuelManager.bronzeEngineFuel.put(Fluids.MILK.getFluid(), new EngineBronzeFuel(Fluids.MILK.getFluid(), 10, 10000, 3));
        FuelManager.bronzeEngineFuel.put(Fluids.SEEDOIL.getFluid(), new EngineBronzeFuel(Fluids.SEEDOIL.getFluid(), 30, 2500, 1));
        FuelManager.bronzeEngineFuel.put(Fluids.HONEY.getFluid(), new EngineBronzeFuel(Fluids.HONEY.getFluid(), 20, 2500, 1));
        FuelManager.bronzeEngineFuel.put(Fluids.JUICE.getFluid(), new EngineBronzeFuel(Fluids.JUICE.getFluid(), 10, 2500, 1));
        FuelManager.rainSubstrate.put(ForestryItem.iodineCharge.getItemStack(), new RainSubstrate(ForestryItem.iodineCharge.getItemStack(), 10000, 0.01f));
        FuelManager.rainSubstrate.put(ForestryItem.craftingMaterial.getItemStack(1, 4), new RainSubstrate(ForestryItem.craftingMaterial.getItemStack(1, 4), 0.075f));
        for (int i = 0; i < 9; ++i) {
            FlowerManager.plainFlowers.add(new ItemStack((Block)Blocks.field_150328_O, 1, i));
        }
        FlowerManager.plainFlowers.add(new ItemStack((Block)Blocks.field_150327_N));
        NetworkRegistry.INSTANCE.registerGuiHandler(basemod, (IGuiHandler)new GuiHandler());
        GameRegistry.registerTileEntity(TileMill.class, (String)"forestry.Grower");
        GameRegistry.registerTileEntity(TileEngine.class, (String)"forestry.Engine");
        GameRegistry.registerTileEntity(TileMachine.class, (String)"forestry.Machine");
        PluginManager.runInit();
    }

    public void postInit() {
        PluginManager.runPostInit();
        WorldGenerator worldGenerator = new WorldGenerator();
        GameRegistry.registerWorldGenerator((IWorldGenerator)worldGenerator, (int)0);
        Proxies.common.registerTickHandlers(worldGenerator);
        this.processIMCMessages((ImmutableList<FMLInterModComms.IMCMessage>)FMLInterModComms.fetchRuntimeMessages((Object)ForestryAPI.instance));
    }

    public void serverStarting(MinecraftServer server) {
        PluginManager.serverStarting(server);
    }

    public void processIMCMessages(ImmutableList<FMLInterModComms.IMCMessage> messages) {
        PluginManager.processIMCMessages(messages);
    }

    public String getPriorities() {
        return "after:mod_IC2;after:mod_BuildCraftCore;after:mod_BuildCraftEnergy;after:mod_BuildCraftFactory;after:mod_BuildCraftSilicon;after:mod_BuildCraftTransport;after:mod_RedPowerWorld";
    }
}

