/*
 * Decompiled with CFR 0.152.
 */
package forestry.core;

import cpw.mods.fml.common.eventhandler.Event;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import forestry.api.core.ErrorStateRegistry;
import forestry.core.interfaces.IOreDictionaryHandler;
import forestry.core.interfaces.IPickupHandler;
import forestry.core.interfaces.ISaveEventHandler;
import forestry.core.render.TextureManager;
import forestry.plugins.PluginManager;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.item.ItemStack;
import net.minecraftforge.client.event.TextureStitchEvent;
import net.minecraftforge.event.entity.player.EntityItemPickupEvent;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.oredict.OreDictionary;

public class EventHandlerCore {
    public EventHandlerCore() {
        for (String name : OreDictionary.getOreNames()) {
            for (ItemStack ore : OreDictionary.getOres((String)name)) {
                this.handleOreRegistration(name, ore);
            }
        }
    }

    @SubscribeEvent
    public void handleItemPickup(EntityItemPickupEvent event) {
        if (event.isCanceled()) {
            return;
        }
        for (IPickupHandler handler : PluginManager.pickupHandlers) {
            if (handler.onItemPickup(event.entityPlayer, event.item)) continue;
            event.setResult(Event.Result.ALLOW);
            return;
        }
    }

    @SubscribeEvent
    public void handleOreRegistration(OreDictionary.OreRegisterEvent event) {
        if (event.isCanceled()) {
            return;
        }
        this.handleOreRegistration(event.Name, event.Ore);
    }

    private void handleOreRegistration(String name, ItemStack ore) {
        for (IOreDictionaryHandler handler : PluginManager.dictionaryHandlers) {
            handler.onOreRegistration(name, ore);
        }
    }

    @SubscribeEvent
    public void handleWorldLoad(WorldEvent.Load event) {
        for (ISaveEventHandler handler : PluginManager.saveEventHandlers) {
            handler.onWorldLoad(event.world);
        }
    }

    @SubscribeEvent
    public void handleWorldSave(WorldEvent.Save event) {
        for (ISaveEventHandler handler : PluginManager.saveEventHandlers) {
            handler.onWorldSave(event.world);
        }
    }

    @SubscribeEvent
    public void handleWorldUnload(WorldEvent.Unload event) {
        for (ISaveEventHandler handler : PluginManager.saveEventHandlers) {
            handler.onWorldUnload(event.world);
        }
    }

    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public void handleTextureRemap(TextureStitchEvent.Pre event) {
        if (event.map.func_130086_a() == 1) {
            ErrorStateRegistry.initIcons((IIconRegister)event.map);
            TextureManager.getInstance().initDefaultIcons((IIconRegister)event.map);
        }
    }

    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public void handleTexturePostmap(TextureStitchEvent.Post event) {
    }
}

