/*
 * Decompiled with CFR 0.152.
 */
package forestry.arboriculture.worldgen;

import forestry.api.world.ITreeGenData;
import forestry.arboriculture.worldgen.WorldGenTree;
import forestry.core.worldgen.WorldGenBase;
import java.util.Random;

public class WorldGenPadauk
extends WorldGenTree {
    public WorldGenPadauk(ITreeGenData tree) {
        super(tree);
        this.minHeight = 7;
    }

    @Override
    public void generate() {
        this.generateTreeTrunk(this.height, this.girth);
        int leafSpawn = this.height + 1;
        this.generateAdjustedCylinder(leafSpawn--, 0.0f, 1, this.leaf);
        this.generateAdjustedCylinder(leafSpawn--, 1.5f, 1, this.leaf);
        this.generateAdjustedCylinder(leafSpawn--, 3.0f, 1, this.leaf);
        int count = 0;
        int max = 3;
        int min = 1;
        int canopyHeight = this.rand.nextInt(max - min + 1) + min;
        while (leafSpawn > 3 && count < canopyHeight) {
            this.generateAdjustedCylinder(leafSpawn--, 4.5f, 1, this.leaf);
            ++count;
            for (int i = 0; i < this.girth * 4; ++i) {
                if (!this.rand.nextBoolean()) continue;
                int[] offset = new int[]{-1, 1};
                int offsetValue = offset[new Random().nextInt(offset.length)];
                int maxBranchLength = 3;
                int branchLength = new Random().nextInt(maxBranchLength + 1);
                char[] direction = new char[]{'z', 'x'};
                char directionValue = direction[new Random().nextInt(direction.length)];
                int branchSpawn = leafSpawn;
                for (int j = 1; j < branchLength + 1; ++j) {
                    if (j == branchLength && this.rand.nextBoolean()) {
                        ++branchSpawn;
                    }
                    if (directionValue == 'z') {
                        this.addZWood(0, branchSpawn, j * offsetValue, WorldGenBase.EnumReplaceMode.ALL);
                        continue;
                    }
                    if (directionValue != 'x') continue;
                    this.addXWood(j * offsetValue, branchSpawn, 0, WorldGenBase.EnumReplaceMode.ALL);
                }
            }
        }
    }

    @Override
    public void preGenerate() {
        this.height = this.determineHeight(6, 6);
        this.girth = this.determineGirth(this.tree.getGirth(this.world, this.startX, this.startY, this.startZ));
    }
}

