/*
 * Decompiled with CFR 0.152.
 */
package forestry.arboriculture.worldgen;

import forestry.api.world.ITreeGenData;
import forestry.arboriculture.worldgen.WorldGenTree;

public class WorldGenIpe
extends WorldGenTree {
    public WorldGenIpe(ITreeGenData tree) {
        super(tree);
    }

    @Override
    public void generate() {
        this.generateTreeTrunk(this.height, this.girth);
        int leafSpawn = this.height + 1;
        float adjustedGirth = (float)this.girth * 0.65f;
        this.generateAdjustedCylinder(leafSpawn--, 0.0f, 1, this.leaf);
        this.generateAdjustedCylinder(leafSpawn--, 0.2f * adjustedGirth, 1, this.leaf);
        this.generateAdjustedCylinder(leafSpawn--, 0.2f * adjustedGirth, 1, this.leaf);
        while (leafSpawn > 7) {
            this.generateAdjustedCylinder(leafSpawn, (float)(1.25 * ((double)adjustedGirth * 0.65)), 1, this.leaf);
            --leafSpawn;
        }
        this.generateAdjustedCylinder(leafSpawn--, 1.6f * adjustedGirth, 1, this.leaf);
        this.generateAdjustedCylinder(leafSpawn--, 1.6f * adjustedGirth, 1, this.leaf);
        this.generateAdjustedCylinder(leafSpawn--, 1.6f * adjustedGirth, 1, this.leaf);
        if (this.rand.nextBoolean()) {
            this.generateAdjustedCylinder(leafSpawn--, 1.25f * adjustedGirth, 1, this.leaf);
        }
        this.generateAdjustedCylinder(leafSpawn--, 1.0f * adjustedGirth, 1, this.leaf);
    }

    @Override
    public void preGenerate() {
        this.height = this.determineHeight(8, 8);
        this.girth = this.determineGirth(this.tree.getGirth(this.world, this.startX, this.startY, this.startZ));
    }
}

